/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.screen;

import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.shedaniel.rei.RoughlyEnoughItemsState;
import me.shedaniel.rei.impl.client.gui.InternalTextures;
import me.shedaniel.rei.impl.client.gui.widget.DynamicErrorFreeEntryListWidget;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Tuple;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class WarningAndErrorScreen
extends Screen {
    private AbstractWidget buttonExit;
    private StringEntryListWidget listWidget;
    private String action;
    private Screen parent;
    private List<Tuple<String, String>> warnings;
    private List<Tuple<String, String>> errors;
    private Consumer<Screen> onContinue;

    public WarningAndErrorScreen(String action, List<Tuple<String, String>> warnings, List<Tuple<String, String>> errors, Consumer<Screen> onContinue) {
        super((Component)Component.empty());
        this.action = action;
        this.warnings = warnings;
        this.errors = errors;
        this.onContinue = onContinue;
    }

    public boolean shouldCloseOnEsc() {
        return false;
    }

    public void setParent(Screen parent) {
        this.parent = parent;
    }

    private void addText(Component string) {
        for (FormattedCharSequence s : this.font.split((FormattedText)string, this.width - 80)) {
            this.listWidget.creditsAddEntry(new TextItem(s));
        }
    }

    private void addLink(Component string, String link) {
        for (FormattedCharSequence s : this.font.split((FormattedText)string, this.width - 80)) {
            this.listWidget.creditsAddEntry(new LinkItem(s, link));
        }
    }

    public void init() {
        int i;
        this.listWidget = new StringEntryListWidget(this.minecraft, this.width, this.height, 32, this.height - 32);
        this.addWidget((GuiEventListener)this.listWidget);
        this.listWidget.max = 80;
        this.listWidget.creditsClearEntries();
        this.listWidget.creditsAddEntry(new EmptyItem());
        if (!this.warnings.isEmpty()) {
            this.listWidget.creditsAddEntry(new TextItem(Component.literal((String)"Warnings:").withStyle(ChatFormatting.GOLD).getVisualOrderText()));
        }
        for (Tuple<String, String> pair : this.warnings) {
            this.addText((Component)Component.literal((String)((String)pair.getA())));
            if (pair.getB() != null) {
                this.addLink((Component)Component.literal((String)((String)pair.getB())), (String)pair.getB());
            }
            for (i = 0; i < 2; ++i) {
                this.listWidget.creditsAddEntry(new EmptyItem());
            }
        }
        if (!this.warnings.isEmpty() && !this.errors.isEmpty()) {
            this.listWidget.creditsAddEntry(new EmptyItem());
        }
        if (!this.errors.isEmpty()) {
            this.listWidget.creditsAddEntry(new TextItem(Component.literal((String)"Errors:").withStyle(ChatFormatting.RED).getVisualOrderText()));
        }
        for (Tuple<String, String> pair : this.errors) {
            this.addText((Component)Component.literal((String)((String)pair.getA())));
            if (pair.getB() != null) {
                this.addLink((Component)Component.literal((String)((String)pair.getB())), (String)pair.getB());
            }
            for (i = 0; i < 2; ++i) {
                this.listWidget.creditsAddEntry(new EmptyItem());
            }
        }
        for (StringItem child : this.listWidget.children()) {
            this.listWidget.max = Math.max(this.listWidget.max, child.getWidth());
        }
        this.buttonExit = new Button(this, this.width / 2 - 100, this.height - 26, 200, 20, (Component)Component.literal((String)(this.errors.isEmpty() ? "Continue" : "Exit")), button -> this.onContinue.accept(this.parent), Supplier::get){};
        this.addRenderableWidget((GuiEventListener)this.buttonExit);
    }

    public boolean mouseScrolled(double double_1, double double_2, double amountX, double amountY) {
        return this.listWidget.mouseScrolled(double_1, double_2, amountX, amountY) || super.mouseScrolled(double_1, double_2, amountX, amountY);
    }

    public void render(GuiGraphics graphics, int int_1, int int_2, float float_1) {
        super.render(graphics, int_1, int_2, float_1);
        this.listWidget.render(graphics, int_1, int_2, float_1);
        if (RoughlyEnoughItemsState.getErrors().isEmpty()) {
            graphics.drawCenteredString(this.font, "Warnings during Roughly Enough Items' " + this.action, this.width / 2, 16, 0xFFFFFF);
        } else {
            graphics.drawCenteredString(this.font, "Errors during Roughly Enough Items' " + this.action, this.width / 2, 16, 0xFFFFFF);
        }
        this.buttonExit.render(graphics, int_1, int_2, float_1);
    }

    private static class StringEntryListWidget
    extends DynamicErrorFreeEntryListWidget<StringItem> {
        private boolean inFocus;
        private int max = 80;

        public StringEntryListWidget(Minecraft client, int width, int height, int startY, int endY) {
            super(client, width, height, startY, endY, InternalTextures.LEGACY_DIRT);
        }

        public void creditsClearEntries() {
            this.clearItems();
        }

        private StringItem rei_getEntry(int int_1) {
            return (StringItem)this.children().get(int_1);
        }

        public void creditsAddEntry(StringItem entry) {
            this.addItem(entry);
        }

        @Override
        public int getItemWidth() {
            return this.max;
        }

        @Override
        protected int getScrollbarPosition() {
            return this.width - 40;
        }
    }

    private static class TextItem
    extends StringItem {
        private FormattedCharSequence text;

        public TextItem(FormattedCharSequence text) {
            this.text = text;
        }

        @Override
        public void render(GuiGraphics graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            graphics.drawString(Minecraft.getInstance().font, this.text, x + 5, y, -1);
        }

        @Override
        public int getItemHeight() {
            return 12;
        }

        @Override
        public int getWidth() {
            return Minecraft.getInstance().font.width(this.text) + 10;
        }

        @Override
        public List<? extends NarratableEntry> narratables() {
            return ImmutableList.of((Object)new NarratableEntry(){

                public NarratableEntry.NarrationPriority narrationPriority() {
                    return NarratableEntry.NarrationPriority.HOVERED;
                }

                public void updateNarration(NarrationElementOutput narrationElementOutput) {
                    StringBuilder builder = new StringBuilder();
                    text.accept((i, style, j) -> {
                        builder.append(Character.toChars(j));
                        return false;
                    });
                    narrationElementOutput.add(NarratedElementType.TITLE, builder.toString());
                }
            });
        }
    }

    private static abstract class StringItem
    extends DynamicErrorFreeEntryListWidget.Entry<StringItem> {
        private StringItem() {
        }

        public abstract int getWidth();

        public void setFocused(boolean bl) {
        }

        public boolean isFocused() {
            return false;
        }
    }

    private class LinkItem
    extends StringItem {
        private FormattedCharSequence text;
        private String link;
        private boolean contains;

        public LinkItem(FormattedCharSequence text, String link) {
            this.text = text;
            this.link = link;
        }

        @Override
        public void render(GuiGraphics graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            boolean bl = this.contains = mouseX >= x && mouseX <= x + entryWidth && mouseY >= y && mouseY <= y + entryHeight;
            if (this.contains) {
                graphics.setTooltipForNextFrame(WarningAndErrorScreen.this.font, (Component)Component.literal((String)"Click to open link."), mouseX, mouseY);
                graphics.drawString(Minecraft.getInstance().font, characterVisitor -> this.text.accept((charIndex, style, codePoint) -> characterVisitor.accept(charIndex, style.applyFormat(ChatFormatting.UNDERLINE), codePoint)), x + 5, y, -14695425);
            } else {
                graphics.drawString(Minecraft.getInstance().font, this.text, x + 5, y, -14695425);
            }
        }

        @Override
        public int getItemHeight() {
            return 12;
        }

        @Override
        public int getWidth() {
            return Minecraft.getInstance().font.width(this.text) + 10;
        }

        public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
            if (this.contains && event.button() == 0) {
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                try {
                    Util.getPlatform().openUri(new URI(this.link));
                    return true;
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
            return false;
        }

        @Override
        public List<? extends NarratableEntry> narratables() {
            return ImmutableList.of((Object)new NarratableEntry(){

                public NarratableEntry.NarrationPriority narrationPriority() {
                    return NarratableEntry.NarrationPriority.HOVERED;
                }

                public void updateNarration(NarrationElementOutput narrationElementOutput) {
                    StringBuilder builder = new StringBuilder();
                    LinkItem.this.text.accept((i, style, j) -> {
                        builder.append(Character.toChars(j));
                        return false;
                    });
                    narrationElementOutput.add(NarratedElementType.TITLE, builder.toString());
                }
            });
        }
    }

    private static class EmptyItem
    extends StringItem {
        private EmptyItem() {
        }

        @Override
        public void render(GuiGraphics graphics, int i, int i1, int i2, int i3, int i4, int i5, int i6, boolean b, float v) {
        }

        @Override
        public int getItemHeight() {
            return 5;
        }

        @Override
        public int getWidth() {
            return 0;
        }

        @Override
        public List<? extends NarratableEntry> narratables() {
            return Collections.emptyList();
        }
    }
}

