/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.hints;

import java.util.List;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.ClientHelper;
import me.shedaniel.rei.api.client.gui.config.DisplayPanelLocation;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import me.shedaniel.rei.impl.common.entry.type.EntryRegistryImpl;
import me.shedaniel.rei.impl.common.entry.type.EntryRegistryListener;
import me.shedaniel.rei.impl.common.util.InstanceHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class ImportantWarningsWidget
extends WidgetWithBounds {
    private static final EntryRegistryListener LISTENER = new EntryRegistryListener(){};
    private static String prevId = "";
    private static boolean dirty = false;
    private boolean visible;
    private final Rectangle bounds;
    private final Rectangle buttonBounds = new Rectangle();
    private List<Component> texts;

    public ImportantWarningsWidget() {
        if (((EntryRegistryImpl)EntryRegistry.getInstance()).listeners.add(LISTENER)) {
            String newId;
            Object object = Minecraft.getInstance().hasSingleplayerServer() ? "integrated:" + Minecraft.getInstance().getSingleplayerServer().getWorldData().getLevelName() : (newId = InstanceHelper.connectionFromClient() != null ? "server:" + String.valueOf(InstanceHelper.connectionFromClient().getId()) : "null");
            if (!newId.equals(prevId)) {
                prevId = newId;
                dirty = true;
            }
            dirty = dirty && !ClientHelper.getInstance().canUseMovePackets();
        }
        this.visible = dirty;
        this.texts = List.of(Component.translatable((String)"text.rei.recipes.not.full.title").withStyle(ChatFormatting.RED), Component.translatable((String)"text.rei.recipes.not.full.desc", (Object[])new Object[]{Component.translatable((String)"text.rei.recipes.not.full.desc.command").withStyle(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.UNDERLINE})}).withStyle(ChatFormatting.GRAY));
        this.bounds = ScreenRegistry.getInstance().getOverlayBounds(DisplayPanelLocation.LEFT, Minecraft.getInstance().screen);
        this.bounds.setBounds(this.bounds.x + 10, this.bounds.y + 10, this.bounds.width - 20, this.bounds.height - 20);
        int heightRequired = -5;
        for (Component text : this.texts) {
            heightRequired += Minecraft.getInstance().font.wordWrapHeight((FormattedText)text, this.bounds.width * 2) / 2;
            heightRequired += 5;
        }
        this.bounds.height = Math.min(heightRequired + 20, this.bounds.height);
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        if (!this.visible) {
            return;
        }
        graphics.pose().pushMatrix();
        graphics.fill(this.bounds.x - 5, this.bounds.y - 5, this.bounds.getMaxX() + 5, this.bounds.getMaxY() + 5, -1877929711);
        int y = this.bounds.y;
        for (Component text : this.texts) {
            graphics.pose().pushMatrix();
            graphics.pose().translate((float)this.bounds.x, (float)y);
            graphics.pose().scale(0.5f, 0.5f);
            graphics.drawWordWrap(Minecraft.getInstance().font, (FormattedText)text, 0, 0, this.bounds.width * 2, -1);
            y += Minecraft.getInstance().font.wordWrapHeight((FormattedText)text, this.bounds.width * 2) / 2 + 5;
            graphics.pose().popMatrix();
        }
        MutableComponent okayText = Component.translatable((String)"text.rei.recipes.not.full.button.okay");
        graphics.pose().pushMatrix();
        graphics.pose().translate((float)(this.bounds.x + this.bounds.width / 2) - (float)Minecraft.getInstance().font.width((FormattedText)okayText) * 0.75f / 2.0f, (float)(this.bounds.getMaxY() - 9));
        graphics.pose().scale(0.75f, 0.75f);
        this.buttonBounds.setBounds(this.bounds.x, this.bounds.getMaxY() - 20, this.bounds.width, 20);
        graphics.drawString(Minecraft.getInstance().font, (Component)okayText, 0, 0, this.buttonBounds.contains(mouseX, mouseY) ? -1826 : -1426063361);
        graphics.pose().popMatrix();
        graphics.pose().popMatrix();
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
        if (this.visible && event.button() == 0 && this.buttonBounds.contains(event.x(), event.y())) {
            dirty = false;
            this.visible = false;
            Widgets.produceClickSound();
            return true;
        }
        return false;
    }

    public List<? extends GuiEventListener> children() {
        return List.of();
    }
}

