/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.config.addon;

import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.gui.widget.DynamicEntryListWidget;
import me.shedaniel.rei.api.client.config.addon.ConfigAddon;
import me.shedaniel.rei.api.client.config.addon.ConfigAddonRegistry;
import me.shedaniel.rei.impl.client.config.addon.ConfigAddonRegistryImpl;
import me.shedaniel.rei.impl.client.gui.InternalTextures;
import me.shedaniel.rei.impl.client.gui.widget.UpdatedListWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.Nullable;

public class ConfigAddonsScreen
extends Screen {
    private AddonsList rulesList;
    private final Screen parent;

    public ConfigAddonsScreen(Screen parent) {
        super((Component)Component.translatable((String)"text.rei.addons"));
        this.parent = parent;
    }

    public void init() {
        super.init();
        MutableComponent backText = Component.literal((String)"\u21a9 ").append((Component)Component.translatable((String)"gui.back"));
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)backText, button -> this.minecraft.setScreen(this.parent)).bounds(4, 4, Minecraft.getInstance().font.width((FormattedText)backText) + 10, 20).build());
        this.rulesList = (AddonsList)this.addWidget((GuiEventListener)new AddonsList(this.minecraft, this.width, this.height, 30, this.height));
        ConfigAddonRegistryImpl addonRegistry = (ConfigAddonRegistryImpl)ConfigAddonRegistry.getInstance();
        for (ConfigAddon addon : addonRegistry.getAddons()) {
            this.rulesList.addItem(new DefaultAddonEntry(this.parent, addon));
        }
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.rulesList.render(graphics, mouseX, mouseY, delta);
        super.render(graphics, mouseX, mouseY, delta);
        graphics.drawString(this.font, this.title.getVisualOrderText(), (int)((float)this.width / 2.0f - (float)this.font.width((FormattedText)this.title) / 2.0f), 12, -1);
    }

    public static class AddonsList
    extends UpdatedListWidget<AddonEntry> {
        private boolean inFocus;

        public AddonsList(Minecraft client, int width, int height, int top, int bottom) {
            super(client, width, height, top, bottom);
        }

        protected boolean isSelected(int index) {
            return false;
        }

        protected int addItem(AddonEntry item) {
            return super.addItem((DynamicEntryListWidget.Entry)item);
        }

        public int getItemWidth() {
            return this.width - 40;
        }

        protected int getScrollbarPosition() {
            return this.width - 14;
        }
    }

    public static class DefaultAddonEntry
    extends AddonEntry {
        private final Button configureButton;
        private final ConfigAddon addon;

        public DefaultAddonEntry(Screen parent, ConfigAddon addon) {
            this.addon = addon;
            this.configureButton = new Button(this, 0, 0, 20, 20, Component.nullToEmpty(null), button -> Minecraft.getInstance().setScreen(this.addon.createScreen(Minecraft.getInstance().screen)), Supplier::get){

                public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
                    super.renderWidget(graphics, mouseX, mouseY, delta);
                    graphics.blit(RenderPipelines.GUI_TEXTURED, InternalTextures.CHEST_GUI_TEXTURE, this.getX() + 3, this.getY() + 3, 0.0f, 0.0f, 14, 14, 256, 256);
                }
            };
        }

        public void render(GuiGraphics graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
            Minecraft client = Minecraft.getInstance();
            Component title = this.addon.getName();
            int i = client.font.width((FormattedText)title);
            if (i > entryWidth - 28) {
                FormattedText titleTrimmed = FormattedText.composite((FormattedText[])new FormattedText[]{client.font.substrByWidth((FormattedText)title, entryWidth - 28 - client.font.width("...")), FormattedText.of((String)"...")});
                graphics.drawString(client.font, Language.getInstance().getVisualOrder(titleTrimmed), x + 2, y + 1, 0xFFFFFF);
            } else {
                graphics.drawString(client.font, title.getVisualOrderText(), x + 2, y + 1, 0xFFFFFF);
            }
            Component subtitle = this.addon.getDescription();
            i = client.font.width((FormattedText)subtitle);
            if (i > entryWidth - 28) {
                FormattedText subtitleTrimmed = FormattedText.composite((FormattedText[])new FormattedText[]{client.font.substrByWidth((FormattedText)subtitle, entryWidth - 28 - client.font.width("...")), FormattedText.of((String)"...")});
                graphics.drawString(client.font, Language.getInstance().getVisualOrder(subtitleTrimmed), x + 2, y + 12, 0x808080);
            } else {
                graphics.drawString(client.font, subtitle.getVisualOrderText(), x + 2, y + 12, 0x808080);
            }
            this.configureButton.setX(x + entryWidth - 25);
            this.configureButton.setY(y + 1);
            this.configureButton.render(graphics, mouseX, mouseY, delta);
        }

        @Override
        public List<? extends GuiEventListener> children() {
            return Collections.singletonList(this.configureButton);
        }

        public List<? extends NarratableEntry> narratables() {
            return Collections.singletonList(this.configureButton);
        }
    }

    public static abstract class AddonEntry
    extends UpdatedListWidget.ElementEntry<AddonEntry> {
        public int getItemHeight() {
            return 26;
        }

        @Nullable
        public ComponentPath nextFocusPath(FocusNavigationEvent focusNavigationEvent) {
            return null;
        }
    }
}

