/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.client.gui.widgets;

import java.util.Stack;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.client.gui.AbstractContainerEventHandler;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.CloseableScissors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Matrix3x2f;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public abstract class Widget
extends AbstractContainerEventHandler
implements Renderable,
Renderer {
    protected final Minecraft minecraft = Minecraft.getInstance();
    protected final Font font;
    private static final Stack<Point> mouseStack = new Stack();

    public Widget() {
        this.font = this.minecraft.font;
    }

    public static Point mouse() {
        return mouseStack.empty() ? PointHelper.ofMouse() : mouseStack.peek();
    }

    public static Point pushMouse(Point mouse) {
        return mouseStack.push(mouse);
    }

    public static Point popMouse() {
        return mouseStack.pop();
    }

    public static Point translateMouse(double x, double y) {
        return Widget.translateMouse(new Matrix3x2f().translate((float)x, (float)y));
    }

    public static Point translateMouse(Matrix3x2f pose) {
        Point mouse = Widget.mouse();
        Vector3f mouseVec = new Vector3f((float)mouse.x, (float)mouse.y, 1.0f);
        pose.transform(mouseVec);
        return Widget.pushMouse(new Point((double)mouseVec.x(), (double)mouseVec.y()));
    }

    public boolean containsMouse(double mouseX, double mouseY) {
        return false;
    }

    public final boolean containsMouse(int mouseX, int mouseY) {
        return this.containsMouse((double)mouseX, (double)mouseY);
    }

    public final boolean containsMouse(Point point) {
        return this.containsMouse((double)point.x, (double)point.y);
    }

    public final boolean isMouseOver(double mouseX, double mouseY) {
        return this.containsMouse(mouseX, mouseY);
    }

    @Override
    @Deprecated
    public void render(GuiGraphics graphics, Rectangle bounds, int mouseX, int mouseY, float delta) {
        this.render(graphics, mouseX, mouseY, delta);
    }

    @ApiStatus.Experimental
    public double getZRenderingPriority() {
        return 0.0;
    }

    @ApiStatus.Experimental
    public static CloseableScissors scissor(GuiGraphics graphics, Rectangle bounds) {
        graphics.enableScissor(bounds.x, bounds.y, bounds.getMaxX(), bounds.getMaxY());
        return () -> ((GuiGraphics)graphics).disableScissor();
    }
}

