/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.common.displays.tag;

import com.google.common.collect.Maps;
import com.mojang.serialization.DataResult;
import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.networking.NetworkManager;
import dev.architectury.utils.Env;
import dev.architectury.utils.EnvExecutor;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import me.shedaniel.rei.api.common.util.UUIDUtils;
import me.shedaniel.rei.plugin.common.displays.tag.TagNode;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class TagNodes {
    public static final Identifier REQUEST_TAGS_C2S_PACKET_ID = Identifier.fromNamespaceAndPath((String)"roughlyenoughitems", (String)"request_tags_c2s");
    public static final Identifier REQUEST_TAGS_S2C_PACKET_ID = Identifier.fromNamespaceAndPath((String)"roughlyenoughitems", (String)"request_tags_s2c");
    public static final CustomPacketPayload.Type<C2STagDataPacket> REQUEST_TAGS_C2S_PACKET_TYPE = new CustomPacketPayload.Type(REQUEST_TAGS_C2S_PACKET_ID);
    public static final CustomPacketPayload.Type<S2CTagDataPacket> REQUEST_TAGS_S2C_PACKET_TYPE = new CustomPacketPayload.Type(REQUEST_TAGS_S2C_PACKET_ID);
    public static final Map<String, ResourceKey<? extends Registry<?>>> TAG_DIR_MAP = new HashMap();
    public static final ThreadLocal<String> CURRENT_TAG_DIR = new ThreadLocal();
    public static final Map<String, Map<CollectionWrapper<?>, RawTagData>> RAW_TAG_DATA_MAP = new ConcurrentHashMap();
    public static final Map<ResourceKey<? extends Registry<?>>, Map<Identifier, TagData>> TAG_DATA_MAP = new HashMap();
    public static Map<ResourceKey<? extends Registry<?>>, Consumer<Consumer<DataResult<Map<Identifier, TagData>>>>> requestedTags = new HashMap();

    public static void init() {
        EnvExecutor.runInEnv((Env)Env.CLIENT, () -> Client::init);
        EnvExecutor.runInEnv((Env)Env.SERVER, () -> Server::init);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), REQUEST_TAGS_C2S_PACKET_TYPE, C2STagDataPacket.STREAM_CODEC, (payload, context) -> {
            ResourceKey registryKey = ResourceKey.createRegistryKey((Identifier)payload.registryName);
            Map<Identifier, TagData> dataMap = TAG_DATA_MAP.getOrDefault(registryKey, Collections.emptyMap());
            S2CTagDataPacket packet = new S2CTagDataPacket(payload.uuid, dataMap);
            NetworkManager.sendToPlayer((ServerPlayer)((ServerPlayer)context.getPlayer()), (CustomPacketPayload)packet);
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void requestTagData(ResourceKey<? extends Registry<?>> resourceKey, Consumer<DataResult<Map<Identifier, TagData>>> callback) {
        if (Minecraft.getInstance().getSingleplayerServer() != null) {
            callback.accept((DataResult<Map<Identifier, TagData>>)DataResult.success(TAG_DATA_MAP.get(resourceKey)));
        } else if (!NetworkManager.canServerReceive((Identifier)REQUEST_TAGS_C2S_PACKET_ID)) {
            callback.accept((DataResult<Map<Identifier, TagData>>)DataResult.error(() -> "Cannot request tags from server"));
        } else if (requestedTags.containsKey(resourceKey)) {
            requestedTags.get(resourceKey).accept(callback);
            callback.accept((DataResult<Map<Identifier, TagData>>)DataResult.success(TAG_DATA_MAP.getOrDefault(resourceKey, Collections.emptyMap())));
        } else {
            UUID uuid = UUID.randomUUID();
            C2STagDataPacket packet = new C2STagDataPacket(uuid, resourceKey.identifier());
            Client.nextUUID = uuid;
            Client.nextResourceKey = resourceKey;
            CopyOnWriteArrayList<Consumer<DataResult<Map<Identifier, TagData>>>> callbacks = new CopyOnWriteArrayList<Consumer<DataResult<Map<Identifier, TagData>>>>();
            callbacks.add(callback);
            Client.nextCallback = mapDataResult -> {
                requestedTags.put(resourceKey, c -> c.accept(mapDataResult));
                for (Consumer consumer : callbacks) {
                    consumer.accept(mapDataResult);
                }
            };
            requestedTags.put(resourceKey, callbacks::add);
            NetworkManager.sendToServer((CustomPacketPayload)packet);
        }
    }

    public static <T> void create(TagKey<T> tagKey, Consumer<DataResult<TagNode<T>>> callback) {
        Registry registry = (Registry)BuiltInRegistries.REGISTRY.getValueOrThrow(tagKey.registry());
        TagNodes.requestTagData(tagKey.registry(), result -> callback.accept(result.flatMap(dataMap -> dataMap != null ? TagNodes.resolveTag(tagKey, registry, dataMap).orElse(DataResult.error(() -> "No tag data")) : DataResult.error(() -> "No tag data"))));
    }

    private static <T> Optional<DataResult<TagNode<T>>> resolveTag(TagKey<T> tagKey, Registry<T> registry, Map<Identifier, TagData> tagDataMap) {
        TagData tagData = tagDataMap.get(tagKey.location());
        if (tagData == null) {
            return Optional.empty();
        }
        TagNode<T> self = TagNode.ofReference(tagKey);
        ArrayList<Holder> holders = new ArrayList<Holder>();
        IntListIterator intListIterator = tagData.otherElements().iterator();
        while (intListIterator.hasNext()) {
            int element = (Integer)intListIterator.next();
            Optional holder = registry.get(element);
            if (!holder.isPresent()) continue;
            holders.add((Holder)holder.get());
        }
        if (!holders.isEmpty()) {
            self.addValuesChild((HolderSet<T>)HolderSet.direct(holders));
        }
        for (Identifier childTagId : tagData.otherTags()) {
            Optional<DataResult<TagNode<T>>> resultOptional;
            TagKey childTagKey = TagKey.create((ResourceKey)tagKey.registry(), (Identifier)childTagId);
            if (!registry.get(childTagKey).isPresent() || !(resultOptional = TagNodes.resolveTag(childTagKey, registry, tagDataMap)).isPresent()) continue;
            DataResult result = resultOptional.get();
            if (result.error().isPresent()) {
                return Optional.of(DataResult.error(() -> ((DataResult.Error)result.error().get()).message()));
            }
            self.addChild((TagNode)result.result().get());
        }
        return Optional.of(DataResult.success(self));
    }

    public record C2STagDataPacket(UUID uuid, Identifier registryName) implements CustomPacketPayload
    {
        public static final StreamCodec<RegistryFriendlyByteBuf, C2STagDataPacket> STREAM_CODEC = StreamCodec.composite(UUIDUtils.STREAM_CODEC, C2STagDataPacket::uuid, (StreamCodec)Identifier.STREAM_CODEC, C2STagDataPacket::registryName, C2STagDataPacket::new);

        @NotNull
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return REQUEST_TAGS_C2S_PACKET_TYPE;
        }
    }

    private static class Client {
        public static UUID nextUUID;
        public static ResourceKey<? extends Registry<?>> nextResourceKey;
        public static Consumer<DataResult<Map<Identifier, TagData>>> nextCallback;

        private Client() {
        }

        private static void init() {
            ClientLifecycleEvent.CLIENT_LEVEL_LOAD.register(world -> requestedTags.clear());
            NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), REQUEST_TAGS_S2C_PACKET_TYPE, S2CTagDataPacket.STREAM_CODEC, (payload, context) -> {
                if (!nextUUID.equals(payload.uuid)) {
                    return;
                }
                TAG_DATA_MAP.put(nextResourceKey, payload.map);
                nextCallback.accept((DataResult<Map<Identifier, TagData>>)DataResult.success(payload.map));
                nextUUID = null;
                nextResourceKey = null;
                nextCallback = null;
            });
        }
    }

    public record TagData(IntList otherElements, List<Identifier> otherTags) {
        public static final StreamCodec<RegistryFriendlyByteBuf, TagData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.collection(IntArrayList::new, (StreamCodec)ByteBufCodecs.VAR_INT), TagData::otherElements, (StreamCodec)ByteBufCodecs.collection(ArrayList::new, (StreamCodec)Identifier.STREAM_CODEC), TagData::otherTags, TagData::new);
    }

    public record S2CTagDataPacket(UUID uuid, Map<Identifier, TagData> map) implements CustomPacketPayload
    {
        public static final StreamCodec<RegistryFriendlyByteBuf, S2CTagDataPacket> STREAM_CODEC = StreamCodec.composite(UUIDUtils.STREAM_CODEC, S2CTagDataPacket::uuid, (StreamCodec)ByteBufCodecs.map(Maps::newHashMapWithExpectedSize, (StreamCodec)Identifier.STREAM_CODEC, TagData.STREAM_CODEC), S2CTagDataPacket::map, S2CTagDataPacket::new);

        @NotNull
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return REQUEST_TAGS_S2C_PACKET_TYPE;
        }
    }

    private static class Server {
        private Server() {
        }

        private static void init() {
            NetworkManager.registerS2CPayloadType(REQUEST_TAGS_S2C_PACKET_TYPE, S2CTagDataPacket.STREAM_CODEC);
        }
    }

    public record RawTagData(List<Identifier> otherElements, List<Identifier> otherTags) {
    }

    public static class CollectionWrapper<T> {
        private final Collection<T> collection;

        public CollectionWrapper(Collection<T> collection) {
            this.collection = collection;
        }

        public boolean equals(Object obj) {
            return obj instanceof CollectionWrapper && ((CollectionWrapper)obj).collection == this.collection;
        }

        public int hashCode() {
            return System.identityHashCode(this.collection);
        }
    }
}

