/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.common.displays.tag;

import dev.architectury.fluid.FluidStack;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.resources.Identifier;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public class DefaultTagDisplay<S, T>
implements Display {
    private final TagKey<S> key;
    private final Function<Holder<S>, EntryStack<T>> mapper;
    private final List<EntryIngredient> ingredients;

    public DefaultTagDisplay(TagKey<S> key, Function<Holder<S>, EntryStack<T>> mapper) {
        this.key = key;
        this.mapper = mapper;
        this.ingredients = CollectionUtils.map(EntryIngredients.ofTag((HolderGetter.Provider)BasicDisplay.registryAccess(), key, mapper), EntryIngredient::of);
    }

    public static DefaultTagDisplay<ItemLike, ItemStack> ofItems(TagKey<ItemLike> key) {
        return new DefaultTagDisplay<ItemLike, ItemStack>(key, DefaultTagDisplay::extractItem);
    }

    public static DefaultTagDisplay<Fluid, FluidStack> ofFluids(TagKey<Fluid> key) {
        return new DefaultTagDisplay<Fluid, FluidStack>(key, DefaultTagDisplay::extractFluid);
    }

    private static EntryStack<ItemStack> extractItem(Holder<ItemLike> holder) {
        return EntryStacks.of((ItemLike)holder.value());
    }

    private static EntryStack<FluidStack> extractFluid(Holder<Fluid> holder) {
        return EntryStacks.of((Fluid)holder.value());
    }

    @Override
    public List<EntryIngredient> getInputEntries() {
        return this.ingredients;
    }

    @Override
    public List<EntryIngredient> getOutputEntries() {
        return this.ingredients;
    }

    @Override
    public CategoryIdentifier<?> getCategoryIdentifier() {
        return BuiltinPlugin.TAG;
    }

    @Override
    public Optional<Identifier> getDisplayLocation() {
        return Optional.of(this.key.location());
    }

    @Override
    public DisplaySerializer<? extends Display> getSerializer() {
        return null;
    }

    public TagKey<S> getKey() {
        return this.key;
    }

    public Function<Holder<S>, EntryStack<T>> getMapper() {
        return this.mapper;
    }
}

