/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.common.displays.cooking;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.OptionalDouble;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.plugin.common.displays.cooking.CookingDisplay;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.Identifier;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;

public abstract class DefaultCookingDisplay
extends BasicDisplay
implements CookingDisplay {
    protected float xp;
    protected double cookTime;

    public DefaultCookingDisplay(RecipeHolder<? extends AbstractCookingRecipe> recipe) {
        this(List.of(EntryIngredients.ofIngredient(((AbstractCookingRecipe)recipe.value()).input())), List.of(EntryIngredients.of(((AbstractCookingRecipe)recipe.value()).result())), Optional.of(recipe.id().identifier()), ((AbstractCookingRecipe)recipe.value()).experience(), ((AbstractCookingRecipe)recipe.value()).cookingTime());
    }

    public DefaultCookingDisplay(List<EntryIngredient> input, List<EntryIngredient> output, Optional<Identifier> id, CompoundTag tag) {
        this(input, output, id, ((Float)tag.getFloat("xp").orElseThrow()).floatValue(), (Double)tag.getDouble("cookTime").orElseThrow());
    }

    public DefaultCookingDisplay(List<EntryIngredient> input, List<EntryIngredient> output, Optional<Identifier> id, float xp, double cookTime) {
        super(input, output, id);
        this.xp = xp;
        this.cookTime = cookTime;
    }

    @Override
    public OptionalDouble xp() {
        return OptionalDouble.of(this.xp);
    }

    @Override
    public OptionalDouble cookTime() {
        return OptionalDouble.of(this.cookTime);
    }

    protected static <D extends DefaultCookingDisplay> DisplaySerializer<D> serializer(Constructor<D> constructor) {
        return DisplaySerializer.of(RecordCodecBuilder.mapCodec(instance -> instance.group((App)EntryIngredient.codec().listOf().fieldOf("inputs").forGetter(BasicDisplay::getInputEntries), (App)EntryIngredient.codec().listOf().fieldOf("outputs").forGetter(BasicDisplay::getOutputEntries), (App)Identifier.CODEC.optionalFieldOf("location").forGetter(BasicDisplay::getDisplayLocation), (App)Codec.FLOAT.fieldOf("xp").forGetter(display -> Float.valueOf(display.xp)), (App)Codec.DOUBLE.fieldOf("cookTime").forGetter(display -> display.cookTime)).apply((Applicative)instance, constructor::create)), StreamCodec.composite((StreamCodec)EntryIngredient.streamCodec().apply(ByteBufCodecs.list()), BasicDisplay::getInputEntries, (StreamCodec)EntryIngredient.streamCodec().apply(ByteBufCodecs.list()), BasicDisplay::getOutputEntries, (StreamCodec)ByteBufCodecs.optional((StreamCodec)Identifier.STREAM_CODEC), BasicDisplay::getDisplayLocation, (StreamCodec)ByteBufCodecs.FLOAT, display -> Float.valueOf(display.xp), (StreamCodec)ByteBufCodecs.DOUBLE, display -> display.cookTime, constructor::create));
    }

    protected static interface Constructor<T extends DefaultCookingDisplay> {
        public T create(List<EntryIngredient> var1, List<EntryIngredient> var2, Optional<Identifier> var3, float var4, double var5);
    }
}

