/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.common.displays;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.OptionalDouble;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import me.shedaniel.rei.plugin.common.displays.CampfireDisplay;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.Identifier;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;

public class DefaultCampfireDisplay
extends BasicDisplay
implements CampfireDisplay {
    public static final DisplaySerializer<DefaultCampfireDisplay> SERIALIZER = DisplaySerializer.of(RecordCodecBuilder.mapCodec(instance -> instance.group((App)EntryIngredient.codec().listOf().fieldOf("inputs").forGetter(BasicDisplay::getInputEntries), (App)EntryIngredient.codec().listOf().fieldOf("outputs").forGetter(BasicDisplay::getOutputEntries), (App)Identifier.CODEC.optionalFieldOf("location").forGetter(BasicDisplay::getDisplayLocation), (App)Codec.DOUBLE.fieldOf("cookTime").forGetter(d -> d.cookTime)).apply((Applicative)instance, DefaultCampfireDisplay::new)), StreamCodec.composite((StreamCodec)EntryIngredient.streamCodec().apply(ByteBufCodecs.list()), BasicDisplay::getInputEntries, (StreamCodec)EntryIngredient.streamCodec().apply(ByteBufCodecs.list()), BasicDisplay::getOutputEntries, (StreamCodec)ByteBufCodecs.optional((StreamCodec)Identifier.STREAM_CODEC), BasicDisplay::getDisplayLocation, (StreamCodec)ByteBufCodecs.DOUBLE, d -> d.cookTime, DefaultCampfireDisplay::new));
    private final double cookTime;

    public DefaultCampfireDisplay(RecipeHolder<CampfireCookingRecipe> recipe) {
        this(List.of(EntryIngredients.ofIngredient(((CampfireCookingRecipe)recipe.value()).input())), List.of(EntryIngredients.of(((CampfireCookingRecipe)recipe.value()).result())), Optional.of(recipe.id().identifier()), ((CampfireCookingRecipe)recipe.value()).cookingTime());
    }

    public DefaultCampfireDisplay(List<EntryIngredient> inputs, List<EntryIngredient> outputs, Optional<Identifier> location, CompoundTag tag) {
        this(inputs, outputs, location, (Double)tag.getDouble("cookTime").orElseThrow());
    }

    public DefaultCampfireDisplay(List<EntryIngredient> inputs, List<EntryIngredient> outputs, Optional<Identifier> location, double cookTime) {
        super(inputs, outputs, location);
        this.cookTime = cookTime;
    }

    @Override
    public OptionalDouble cookTime() {
        return OptionalDouble.of(this.cookTime);
    }

    @Override
    public CategoryIdentifier<?> getCategoryIdentifier() {
        return BuiltinPlugin.CAMPFIRE;
    }

    @Override
    public DisplaySerializer<? extends Display> getSerializer() {
        return SERIALIZER;
    }
}

