/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common.transfer;

import java.util.List;
import java.util.function.Predicate;
import me.shedaniel.rei.api.common.entry.InputIngredient;
import me.shedaniel.rei.api.common.transfer.ItemRecipeFinder;
import me.shedaniel.rei.api.common.transfer.info.stack.SlotAccessor;
import me.shedaniel.rei.impl.common.transfer.InputSlotCrafter;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public class NewInputSlotCrafter<T extends AbstractContainerMenu, C extends Container>
extends InputSlotCrafter<T, C> {
    protected final List<SlotAccessor> inputSlots;
    protected final List<SlotAccessor> inventorySlots;
    protected final List<InputIngredient<ItemStack>> inputs;

    public NewInputSlotCrafter(T container, List<SlotAccessor> inputSlots, List<SlotAccessor> inventorySlots, List<InputIngredient<ItemStack>> inputs) {
        super(container);
        this.inputSlots = inputSlots;
        this.inventorySlots = inventorySlots;
        this.inputs = inputs;
    }

    @Override
    protected Iterable<SlotAccessor> getInputSlots() {
        return this.inputSlots;
    }

    @Override
    protected Iterable<SlotAccessor> getInventorySlots() {
        return this.inventorySlots;
    }

    @Override
    protected List<InputIngredient<ItemStack>> getInputs() {
        return this.inputs;
    }

    @Override
    protected void populateRecipeFinder(ItemRecipeFinder recipeFinder) {
        for (SlotAccessor slot : this.getInventorySlots()) {
            recipeFinder.addNormalItem(slot.getItemStack());
        }
    }

    @Override
    protected void markDirty() {
        this.player.getInventory().setChanged();
        this.container.sendAllDataToRemote();
    }

    @Override
    protected void cleanInputs() {
        for (SlotAccessor slot : this.getInputSlots()) {
            ItemStack stackToReturn = slot.getItemStack();
            if (!slot.allowModification((Player)this.player)) {
                throw new IllegalStateException("Slot " + String.valueOf(slot) + " is not modifiable!");
            }
            if (stackToReturn.isEmpty()) continue;
            while (!(stackToReturn = slot.getItemStack()).isEmpty()) {
                ItemStack stackToInsert = stackToReturn.copy();
                stackToInsert.setCount(1);
                if (!this.getDumpHandler().test(stackToInsert)) {
                    throw new IllegalStateException("rei.rei.no.slot.in.inv");
                }
                slot.takeStack(1);
            }
        }
    }

    private Predicate<ItemStack> getDumpHandler() {
        return stackToDump -> {
            SlotAccessor nextSlot;
            Iterable<SlotAccessor> inventoryStacks = this.getInventorySlots();
            SlotAccessor occupiedSlotWithRoomForStack = NewInputSlotCrafter.getOccupiedSlotWithRoomForStack(stackToDump, inventoryStacks);
            SlotAccessor emptySlot = NewInputSlotCrafter.getEmptySlot(inventoryStacks);
            SlotAccessor slotAccessor = nextSlot = occupiedSlotWithRoomForStack == null ? emptySlot : occupiedSlotWithRoomForStack;
            if (nextSlot == null) {
                return false;
            }
            ItemStack stack = stackToDump.copy();
            stack.setCount(nextSlot.getItemStack().getCount() + stack.getCount());
            nextSlot.setItemStack(stack);
            return true;
        };
    }

    static SlotAccessor getOccupiedSlotWithRoomForStack(ItemStack stack, Iterable<SlotAccessor> inventoryStacks) {
        for (SlotAccessor inventoryStack : inventoryStacks) {
            if (!NewInputSlotCrafter.canStackAddMore(inventoryStack.getItemStack(), stack)) continue;
            return inventoryStack;
        }
        return null;
    }

    static SlotAccessor getEmptySlot(Iterable<SlotAccessor> inventoryStacks) {
        for (SlotAccessor inventoryStack : inventoryStacks) {
            if (!inventoryStack.getItemStack().isEmpty()) continue;
            return inventoryStack;
        }
        return null;
    }

    static boolean canStackAddMore(ItemStack existingStack, ItemStack stack) {
        return !existingStack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)existingStack, (ItemStack)stack) && existingStack.isStackable() && existingStack.getCount() + stack.getCount() <= existingStack.getMaxStackSize();
    }
}

