/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common.entry;

import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.common.entry.type.BuiltinEntryTypes;
import me.shedaniel.rei.api.common.entry.type.EntryDefinition;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.impl.client.entry.type.types.RenderingEntryDefinition;
import me.shedaniel.rei.impl.common.entry.type.EntryTypeDeferred;
import me.shedaniel.rei.impl.common.entry.type.types.EmptyEntryDefinition;
import net.minecraft.resources.Identifier;
import net.minecraft.util.Unit;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public enum DeferringEntryTypeProviderImpl implements Function<Identifier, EntryType<?>>
{
    INSTANCE;

    Identifier RENDERING_ID = Identifier.withDefaultNamespace((String)"rendering");
    private Map<Identifier, EntryType<?>> typeCache = new ConcurrentHashMap();
    private EntryType<Unit> empty;
    @OnlyIn(value=Dist.CLIENT)
    private EntryType<Renderer> render;

    @Override
    public EntryType<?> apply(Identifier id) {
        if (id.equals((Object)BuiltinEntryTypes.EMPTY_ID)) {
            return this.typeCache.computeIfAbsent(id, this::emptyType);
        }
        if (id.equals((Object)this.RENDERING_ID) && Platform.getEnvironment() == Env.CLIENT) {
            return this.typeCache.computeIfAbsent(id, this::renderingType);
        }
        return this.typeCache.computeIfAbsent(id, EntryTypeDeferred::new);
    }

    public EntryType<Unit> emptyType(final Identifier id) {
        if (this.empty == null) {
            final int hashCode = id.hashCode();
            this.empty = new EntryType<Unit>(this){

                @Override
                public Identifier getId() {
                    return id;
                }

                @Override
                public EntryDefinition<Unit> getDefinition() {
                    return EmptyEntryDefinition.EMPTY;
                }

                public int hashCode() {
                    return hashCode;
                }
            };
        }
        return this.empty;
    }

    @OnlyIn(value=Dist.CLIENT)
    public EntryType<Renderer> renderingType(final Identifier id) {
        if (this.render == null) {
            @OnlyIn(value=Dist.CLIENT)
            class RenderType
            implements EntryType<Renderer> {
                private final int hashCode;

                RenderType() {
                    this.hashCode = id.hashCode();
                }

                @Override
                public Identifier getId() {
                    return id;
                }

                @Override
                public EntryDefinition<Renderer> getDefinition() {
                    return RenderingEntryDefinition.RENDERING;
                }

                public int hashCode() {
                    return this.hashCode;
                }
            }
            this.render = new RenderType();
        }
        return this.render;
    }
}

