/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.search.argument.type;

import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.config.SearchMode;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.impl.client.search.argument.type.ArgumentType;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.Identifier;
import net.minecraft.util.Unit;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
@ApiStatus.Internal
public final class IdentifierArgumentType
extends ArgumentType<Unit, String> {
    private static final String EMPTY = "";
    private static final Style STYLE = Style.EMPTY.withColor(TextColor.fromRgb((int)9273069));

    @Override
    public String getName() {
        return "identifier";
    }

    @Override
    @Nullable
    public String getPrefix() {
        return "*";
    }

    @Override
    public Style getHighlightedStyle() {
        return STYLE;
    }

    @Override
    public SearchMode getSearchMode() {
        return ConfigObject.getInstance().getIdentifierSearchMode();
    }

    @Override
    public String cacheData(EntryStack<?> stack) {
        String s;
        Identifier identifier = stack.getIdentifier();
        if (identifier != null && !(s = identifier.getPath()).isEmpty()) {
            return s;
        }
        return EMPTY;
    }

    @Override
    public void matches(String identifier, EntryStack<?> stack, Unit filterData, ArgumentType.ResultSink sink) {
        if (!identifier.isEmpty()) {
            sink.testString(identifier);
        }
    }

    @Override
    public Unit prepareSearchFilter(String searchText) {
        return Unit.INSTANCE;
    }
}

