/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.toast;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastManager;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.resources.Identifier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class ExportRecipeIdentifierToast
implements Toast {
    protected static final Identifier TEXTURE = Identifier.fromNamespaceAndPath((String)"roughlyenoughitems", (String)"textures/gui/toasts.png");
    private String title;
    private String subtitle;
    private long startTime;
    private boolean changed;
    private Toast.Visibility wantedVisibility = Toast.Visibility.HIDE;

    public ExportRecipeIdentifierToast(String title, @Nullable String subtitleNullable) {
        this.title = title;
        this.subtitle = subtitleNullable;
    }

    public static void addToast(String title, @Nullable String subtitleNullable) {
        Minecraft.getInstance().getToastManager().addToast((Toast)new ExportRecipeIdentifierToast(title, subtitleNullable));
    }

    public Toast.Visibility getWantedVisibility() {
        return this.wantedVisibility;
    }

    public void update(ToastManager toastManager, long l) {
        double d;
        long m;
        if (this.changed) {
            this.startTime = l;
            this.changed = false;
        }
        this.wantedVisibility = (double)(m = l - this.startTime) < (d = 5000.0 * toastManager.getNotificationDisplayTimeMultiplier()) ? Toast.Visibility.SHOW : Toast.Visibility.HIDE;
    }

    public void render(GuiGraphics graphics, Font font, long var2) {
        graphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, 0, 0, 0.0f, 0.0f, 160, 32, 256, 256);
        if (this.subtitle == null) {
            graphics.drawString(font, this.title, 18, 12, 0xAA0000, false);
        } else {
            graphics.drawString(font, this.title, 18, 7, 0xAA0000, false);
            graphics.drawString(font, this.subtitle, 18, 18, -16777216, false);
        }
    }

    public Object getToken() {
        return Type.THIS_IS_SURE_A_TYPE;
    }

    public static enum Type {
        THIS_IS_SURE_A_TYPE;

    }
}

