/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.text;

import java.util.Locale;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import me.shedaniel.math.Color;
import me.shedaniel.rei.impl.client.gui.config.options.ConfigUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Util;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class TextTransformations {
    public static FormattedCharSequence applyRainbow(FormattedCharSequence sequence, int x, int y) {
        int[] combinedX = new int[]{x};
        return sink -> sequence.accept((charIndex, style, codePoint) -> {
            if (charIndex == 0) {
                combinedX[0] = x;
            }
            int rgb = Color.HSBtoRGB((float)((float)((Util.getMillis() - (long)(combinedX[0] * 10) - (long)(y * 10)) % 2000L) / 2000.0f), (float)0.8f, (float)0.95f);
            combinedX[0] = (int)((float)combinedX[0] + Minecraft.getInstance().font.getSplitter().widthProvider.getWidth(codePoint, style));
            return sink.accept(charIndex, style.withColor(TextColor.fromRgb((int)rgb)), codePoint);
        });
    }

    public static FormattedCharSequence forwardWithTransformation(String text, CharSequenceTransformer transformer) {
        if (text.isEmpty()) {
            return FormattedCharSequence.EMPTY;
        }
        return sink -> {
            int length = text.length();
            for (int charIndex = 0; charIndex < length; ++charIndex) {
                char c = text.charAt(charIndex);
                if (Character.isHighSurrogate(c)) {
                    if (charIndex + 1 >= length) {
                        if (sink.accept(charIndex, Style.EMPTY, 65533)) break;
                        return false;
                    }
                    char forward = text.charAt(charIndex + 1);
                    if (Character.isLowSurrogate(forward)) {
                        if (!sink.accept(charIndex, Style.EMPTY, Character.toCodePoint(c, forward))) {
                            return false;
                        }
                        ++charIndex;
                        continue;
                    }
                    if (sink.accept(charIndex, Style.EMPTY, 65533)) continue;
                    return false;
                }
                if (!(Character.isSurrogate(c) ? !sink.accept(charIndex, Style.EMPTY, 65533) : !sink.accept(charIndex, transformer.apply(text, charIndex, c), (int)c))) continue;
                return false;
            }
            return true;
        };
    }

    public static MutableComponent highlightText(MutableComponent component, @Nullable String highlight, UnaryOperator<Style> styleOperator) {
        if (highlight == null) {
            return component.withStyle(styleOperator);
        }
        String string = component.getString();
        if (string.toLowerCase(Locale.ROOT).equals(highlight.toLowerCase(Locale.ROOT))) {
            return component.withStyle(styleOperator).withStyle(ChatFormatting.YELLOW);
        }
        String[] parts = string.toLowerCase(Locale.ROOT).split(Pattern.quote(highlight.toLowerCase(Locale.ROOT)));
        if (string.toLowerCase(Locale.ROOT).endsWith(highlight.toLowerCase(Locale.ROOT))) {
            String[] newParts = new String[parts.length + 1];
            System.arraycopy(parts, 0, newParts, 0, parts.length);
            newParts[parts.length] = "";
            parts = newParts;
        }
        if (parts.length <= 1) {
            return component.withStyle(styleOperator);
        }
        MutableComponent output = ConfigUtils.literal("");
        int curr = 0;
        for (int i = 0; i < parts.length; ++i) {
            output.append((Component)ConfigUtils.literal(string.substring(curr, curr + parts[i].length())).withStyle(styleOperator));
            curr += parts[i].length();
            if (i == parts.length - 1) continue;
            output.append((Component)ConfigUtils.literal(string.substring(curr, curr + highlight.length())).withStyle(styleOperator).withStyle(ChatFormatting.YELLOW));
            curr += highlight.length();
        }
        return output;
    }

    @FunctionalInterface
    public static interface CharSequenceTransformer {
        public Style apply(String var1, int var2, char var3);
    }
}

