/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.performance;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import me.shedaniel.clothconfig2.gui.widget.DynamicEntryListWidget;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.common.plugins.REIPlugin;
import me.shedaniel.rei.api.common.plugins.REIPluginProvider;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.gui.modules.Menu;
import me.shedaniel.rei.impl.client.gui.modules.entries.ToggleMenuEntry;
import me.shedaniel.rei.impl.client.gui.performance.entry.PerformanceEntryImpl;
import me.shedaniel.rei.impl.client.gui.performance.entry.SubCategoryListEntry;
import me.shedaniel.rei.impl.client.gui.screen.ScreenWithMenu;
import me.shedaniel.rei.impl.client.gui.widget.UpdatedListWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.FormattedCharSequence;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PerformanceScreen
extends ScreenWithMenu {
    private Runnable onClose;
    private PerformanceEntryListWidget list;
    private SortType sortType = SortType.ORDER;

    public PerformanceScreen(Runnable onClose) {
        super((Component)Component.translatable((String)"text.rei.performance"));
        this.onClose = onClose;
    }

    public static FormattedCharSequence formatTime(long time, boolean total) {
        TimeUnit unit = PerformanceScreen.chooseUnit(time);
        double value = (double)time / (double)TimeUnit.NANOSECONDS.convert(1L, unit);
        return Component.literal((String)(String.format(Locale.ROOT, "%.4g", value) + " " + PerformanceScreen.abbreviate(unit))).withStyle(style -> style.withColor(TextColor.fromRgb((int)PerformanceScreen.chooseColor(TimeUnit.MILLISECONDS.convert(time, TimeUnit.NANOSECONDS), total)))).getVisualOrderText();
    }

    private static int chooseColor(long time, boolean total) {
        if (time > (long)(total ? 2500 : 1000)) {
            return 0xFF5555;
        }
        if (time > (long)(total ? 700 : 300)) {
            return 16754176;
        }
        if (time > (long)(total ? 200 : 100)) {
            return 16773143;
        }
        return 0x12FF22;
    }

    private static TimeUnit chooseUnit(long nanos) {
        if (TimeUnit.DAYS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.DAYS;
        }
        if (TimeUnit.HOURS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.HOURS;
        }
        if (TimeUnit.MINUTES.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.MINUTES;
        }
        if (TimeUnit.SECONDS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.SECONDS;
        }
        if (TimeUnit.MILLISECONDS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.MILLISECONDS;
        }
        if (TimeUnit.MICROSECONDS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.MICROSECONDS;
        }
        return TimeUnit.NANOSECONDS;
    }

    private static String abbreviate(TimeUnit unit) {
        switch (unit) {
            case NANOSECONDS: {
                return "ns";
            }
            case MICROSECONDS: {
                return "\u03bcs";
            }
            case MILLISECONDS: {
                return "ms";
            }
            case SECONDS: {
                return "s";
            }
            case MINUTES: {
                return "min";
            }
            case HOURS: {
                return "h";
            }
            case DAYS: {
                return "d";
            }
        }
        throw new AssertionError();
    }

    public void init() {
        MutableComponent backText = Component.literal((String)"\u21a9 ").append((Component)Component.translatable((String)"gui.back"));
        this.addRenderableWidget((GuiEventListener)new Button.Plain(this, 4, 4, Minecraft.getInstance().font.width((FormattedText)backText) + 10, 20, (Component)backText, button -> {
            this.onClose.run();
            this.onClose = null;
        }, Supplier::get){});
        MutableComponent text = Component.translatable((String)"text.rei.sort");
        Rectangle bounds = new Rectangle(this.width - 4 - Minecraft.getInstance().font.width((FormattedText)text) - 10, 4, Minecraft.getInstance().font.width((FormattedText)text) + 10, 20);
        this.addRenderableWidget((GuiEventListener)new Button.Plain(this, bounds.x, bounds.y, bounds.width, bounds.height, (Component)text, button -> this.setMenu(new Menu(bounds, CollectionUtils.map(SortType.values(), type -> ToggleMenuEntry.of((Component)Component.translatable((String)"text.rei.sort.by", (Object[])new Object[]{type.name().toLowerCase(Locale.ROOT)}), () -> false, o -> {
            this.closeMenu();
            this.sortType = type;
            this.init(this.width, this.height);
        })), false)), Supplier::get){});
        this.list = new PerformanceEntryListWidget(this);
        long[] totalTime = new long[]{0L};
        ArrayList<SubCategoryListEntry> subCategories = new ArrayList<SubCategoryListEntry>();
        RoughlyEnoughItemsCore.PERFORMANCE_LOGGER.getStages().forEach((stage, inner) -> {
            long separateTime;
            ArrayList<PerformanceEntry> entries = new ArrayList<PerformanceEntry>();
            inner.times().forEach((obj, time) -> entries.add(new PerformanceEntryImpl((Component)Component.literal((String)(obj instanceof Pair ? this.getNameOfPlugin(obj) : Objects.toString(obj))), (long)time)));
            Collection<Long> values = inner.times().values();
            Map<Object, Long> map = inner.times();
            synchronized (map) {
                separateTime = values.stream().collect(Collectors.summarizingLong(value -> value)).getSum();
            }
            if (inner.totalNano() - separateTime > 1000000L) {
                entries.add(new PerformanceEntryImpl((Component)Component.literal((String)"Miscellaneous Operations"), inner.totalNano() - separateTime));
            }
            totalTime[0] = totalTime[0] + Math.max(inner.totalNano(), separateTime);
            if (this.sortType == SortType.DURATION) {
                entries.sort(Comparator.comparingLong(value -> value.time).reversed());
            }
            subCategories.add(new SubCategoryListEntry((Component)Component.literal((String)stage), entries, Math.max(inner.totalNano(), separateTime), false));
        });
        if (this.sortType == SortType.DURATION) {
            subCategories.sort(Comparator.comparingLong(SubCategoryListEntry::getTotalTime).reversed());
        }
        subCategories.forEach(this.list::addItem);
        this.list.children().add(0, new PerformanceEntryImpl((Component)Component.literal((String)"Total Load Time"), totalTime[0]));
        this.addWidget((GuiEventListener)this.list);
    }

    private String getNameOfPlugin(Object obj) {
        String pluginName;
        Pair pair = (Pair)obj;
        REIPluginProvider provider = (REIPluginProvider)pair.getFirst();
        REIPlugin plugin = (REIPlugin)pair.getSecond();
        Object providerName = provider.getPluginProviderName();
        if (provider.provide().size() >= 1 && !((String)providerName).equals(pluginName = plugin.getPluginProviderName())) {
            providerName = pluginName + " of " + (String)providerName;
        }
        return providerName;
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        super.render(graphics, mouseX, mouseY, delta);
        this.list.render(graphics, mouseX, mouseY, delta);
        graphics.drawString(this.font, this.title.getVisualOrderText(), (int)((float)this.width / 2.0f - (float)this.font.width((FormattedText)this.title) / 2.0f), 12, -1);
    }

    private static enum SortType {
        ORDER,
        DURATION;

    }

    private class PerformanceEntryListWidget
    extends UpdatedListWidget<PerformanceEntry> {
        public PerformanceEntryListWidget(PerformanceScreen performanceScreen) {
            super(performanceScreen.minecraft, performanceScreen.width, performanceScreen.height, 30, performanceScreen.height);
        }

        public int getItemWidth() {
            return this.width;
        }

        public int addItem(PerformanceEntry item) {
            return super.addItem((DynamicEntryListWidget.Entry)item);
        }

        protected int getScrollbarPosition() {
            return this.width - 6;
        }
    }

    public static abstract class PerformanceEntry
    extends UpdatedListWidget.ElementEntry<PerformanceEntry> {
    }
}

