/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.performance;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import me.shedaniel.clothconfig2.gui.widget.DynamicEntryListWidget;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.gui.modules.Menu;
import me.shedaniel.rei.impl.client.gui.modules.entries.ToggleMenuEntry;
import me.shedaniel.rei.impl.client.gui.screen.ScreenWithMenu;
import me.shedaniel.rei.impl.client.gui.widget.UpdatedListWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DisplayRegistryInfoScreen
extends ScreenWithMenu {
    private Runnable onClose;
    private ListWidget list;
    private SortType sortType = SortType.ID;

    public DisplayRegistryInfoScreen(Runnable onClose) {
        super((Component)Component.translatable((String)"text.rei.display_registry_analysis"));
        this.onClose = onClose;
    }

    public void init() {
        MutableComponent backText = Component.literal((String)"\u21a9 ").append((Component)Component.translatable((String)"gui.back"));
        this.addRenderableWidget((GuiEventListener)new Button.Plain(this, 4, 4, Minecraft.getInstance().font.width((FormattedText)backText) + 10, 20, (Component)backText, button -> {
            this.onClose.run();
            this.onClose = null;
        }, Supplier::get){});
        MutableComponent text = Component.translatable((String)"text.rei.sort");
        Rectangle bounds = new Rectangle(this.width - 4 - Minecraft.getInstance().font.width((FormattedText)text) - 10, 4, Minecraft.getInstance().font.width((FormattedText)text) + 10, 20);
        this.addRenderableWidget((GuiEventListener)new Button.Plain(this, bounds.x, bounds.y, bounds.width, bounds.height, (Component)text, button -> this.setMenu(new Menu(bounds, CollectionUtils.map(SortType.values(), type -> ToggleMenuEntry.of((Component)Component.translatable((String)"text.rei.sort.by", (Object[])new Object[]{type.name().toLowerCase(Locale.ROOT)}), () -> false, o -> {
            this.closeMenu();
            this.sortType = type;
            this.init(this.width, this.height);
        })), false)), Supplier::get){});
        this.list = new ListWidget(this);
        this.list.addItem(new EntryImpl((Component)Component.literal((String)"Total Displays"), DisplayRegistry.getInstance().size()));
        this.sort(DisplayRegistry.getInstance().getAll().entrySet().stream()).forEach(entry -> this.list.addItem(new EntryImpl((CategoryIdentifier)entry.getKey(), ((List)entry.getValue()).size())));
        this.addWidget((GuiEventListener)this.list);
    }

    private Stream<Map.Entry<CategoryIdentifier<?>, List<Display>>> sort(Stream<Map.Entry<CategoryIdentifier<?>, List<Display>>> stream) {
        return switch (this.sortType.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> stream.sorted(Comparator.comparingInt(value -> ((List)value.getValue()).size()).reversed());
            case 1 -> stream.sorted(Comparator.comparing(value -> ((CategoryIdentifier)value.getKey()).toString()));
        };
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        super.render(graphics, mouseX, mouseY, delta);
        this.list.render(graphics, mouseX, mouseY, delta);
        graphics.drawString(this.font, this.title.getVisualOrderText(), (int)((float)this.width / 2.0f - (float)this.font.width((FormattedText)this.title) / 2.0f), 12, -1);
    }

    private static enum SortType {
        COUNT,
        ID;

    }

    private class ListWidget
    extends UpdatedListWidget<ListEntry> {
        public ListWidget(DisplayRegistryInfoScreen displayRegistryInfoScreen) {
            super(displayRegistryInfoScreen.minecraft, displayRegistryInfoScreen.width, displayRegistryInfoScreen.height, 30, displayRegistryInfoScreen.height);
        }

        public int getItemWidth() {
            return this.width;
        }

        public int addItem(ListEntry item) {
            return super.addItem((DynamicEntryListWidget.Entry)item);
        }

        protected int getScrollbarPosition() {
            return this.width - 6;
        }
    }

    public static class EntryImpl
    extends ListEntry {
        private final Component component;
        public final int count;

        public EntryImpl(CategoryIdentifier<?> identifier, int count) {
            this((Component)Component.literal((String)identifier.getIdentifier().toString()), count);
        }

        public EntryImpl(Component component, int count) {
            this.component = component;
            this.count = count;
        }

        public void render(GuiGraphics graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
            graphics.drawString(Minecraft.getInstance().font, this.component.getVisualOrderText(), x + 4, y + 6, -1);
            FormattedCharSequence rightText = Component.translatable((String)"text.rei.display_registry_analysis.displays", (Object[])new Object[]{this.count}).getVisualOrderText();
            graphics.drawString(Minecraft.getInstance().font, rightText, x + entryWidth - 6 - 8 - Minecraft.getInstance().font.width(rightText), y + 6, -1);
        }

        public int getItemHeight() {
            return 24;
        }

        @Override
        public List<? extends GuiEventListener> children() {
            return Collections.emptyList();
        }

        public List<? extends NarratableEntry> narratables() {
            return Collections.emptyList();
        }
    }

    public static abstract class ListEntry
    extends UpdatedListWidget.ElementEntry<ListEntry> {
    }
}

