/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.Window;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.config.ConfigManager;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.favorites.FavoriteEntry;
import me.shedaniel.rei.api.client.gui.config.DisplayPanelLocation;
import me.shedaniel.rei.api.client.gui.config.SearchFieldLocation;
import me.shedaniel.rei.api.client.gui.drag.DraggingContext;
import me.shedaniel.rei.api.client.gui.drag.component.DraggableComponentProvider;
import me.shedaniel.rei.api.client.gui.drag.component.DraggableComponentVisitor;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.overlay.OverlayListWidget;
import me.shedaniel.rei.api.client.overlay.ScreenOverlay;
import me.shedaniel.rei.api.client.registry.screen.ClickArea;
import me.shedaniel.rei.api.client.registry.screen.OverlayDecider;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import me.shedaniel.rei.api.client.view.ViewSearchBuilder;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.plugins.PluginManager;
import me.shedaniel.rei.impl.client.REIRuntimeImpl;
import me.shedaniel.rei.impl.client.gui.craftable.CraftableFilter;
import me.shedaniel.rei.impl.client.gui.dragging.CurrentDraggingStack;
import me.shedaniel.rei.impl.client.gui.hints.ImportantWarningsWidget;
import me.shedaniel.rei.impl.client.gui.modules.MenuAccess;
import me.shedaniel.rei.impl.client.gui.modules.MenuHolder;
import me.shedaniel.rei.impl.client.gui.widget.ConfigButtonWidget;
import me.shedaniel.rei.impl.client.gui.widget.CraftableFilterButtonWidget;
import me.shedaniel.rei.impl.client.gui.widget.DefaultDisplayChoosePageWidget;
import me.shedaniel.rei.impl.client.gui.widget.EntryHighlighter;
import me.shedaniel.rei.impl.client.gui.widget.InternalWidgets;
import me.shedaniel.rei.impl.client.gui.widget.LateRenderable;
import me.shedaniel.rei.impl.client.gui.widget.entrylist.EntryListWidget;
import me.shedaniel.rei.impl.client.gui.widget.entrylist.PaginatedEntryListWidget;
import me.shedaniel.rei.impl.client.gui.widget.entrylist.ScrolledEntryListWidget;
import me.shedaniel.rei.impl.client.gui.widget.favorites.FavoritesListWidget;
import me.shedaniel.rei.impl.client.gui.widget.hint.HintsContainerWidget;
import me.shedaniel.rei.impl.client.gui.widget.search.OverlaySearchField;
import me.shedaniel.rei.impl.common.util.RectangleUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.CharacterEvent;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class ScreenOverlayImpl
extends ScreenOverlay {
    private static final List<Tooltip> TOOLTIPS = Lists.newArrayList();
    private static EntryListWidget entryListWidget = null;
    private static FavoritesListWidget favoritesListWidget = null;
    private final List<Widget> widgets = Lists.newLinkedList();
    public boolean shouldReload = false;
    public boolean shouldReloadSearch = false;
    private Rectangle bounds;
    private Window window;
    private Widget configButton;
    private final CurrentDraggingStack draggingStack = new CurrentDraggingStack();
    @Nullable
    public DefaultDisplayChoosePageWidget choosePageWidget;
    private final MenuHolder menuHolder = new MenuHolder();
    private final HintsContainerWidget hintsWidget = new HintsContainerWidget();

    public static EntryListWidget getEntryListWidget() {
        boolean widgetScrolled = ConfigObject.getInstance().isEntryListWidgetScrolled();
        if (entryListWidget != null) {
            if (widgetScrolled && entryListWidget instanceof ScrolledEntryListWidget) {
                return entryListWidget;
            }
            if (!widgetScrolled && entryListWidget instanceof PaginatedEntryListWidget) {
                return entryListWidget;
            }
        }
        entryListWidget = widgetScrolled ? new ScrolledEntryListWidget() : new PaginatedEntryListWidget();
        ScreenOverlayImpl overlay = ScreenOverlayImpl.getInstance();
        Rectangle overlayBounds = overlay.bounds;
        entryListWidget.updateArea(Objects.requireNonNullElse(overlayBounds, new Rectangle()), REIRuntimeImpl.getSearchField() == null ? "" : REIRuntimeImpl.getSearchField().getText());
        entryListWidget.updateEntriesPosition();
        return entryListWidget;
    }

    @Nullable
    public static FavoritesListWidget getFavoritesListWidget() {
        return favoritesListWidget;
    }

    public static ScreenOverlayImpl getInstance() {
        return (ScreenOverlayImpl)REIRuntime.getInstance().getOverlay().orElseThrow();
    }

    public void tick() {
        if (REIRuntimeImpl.getSearchField() != null) {
            REIRuntimeImpl.getSearchField().tick();
            if (Minecraft.getInstance().player != null && !PluginManager.areAnyReloading() && Minecraft.getInstance().player.tickCount % 5 == 0) {
                CraftableFilter.INSTANCE.tick();
            }
        }
    }

    @Override
    public void queueReloadOverlay() {
        this.shouldReload = true;
    }

    @Override
    public void queueReloadSearch() {
        this.shouldReloadSearch = true;
    }

    @Override
    public DraggingContext<?> getDraggingContext() {
        return this.draggingStack;
    }

    protected boolean hasSpace() {
        return !this.bounds.isEmpty();
    }

    public void init() {
        this.draggingStack.set(DraggableComponentProvider.from(ScreenRegistry.getInstance()::getDraggableComponentProviders), DraggableComponentVisitor.from(ScreenRegistry.getInstance()::getDraggableComponentVisitors));
        this.shouldReload = false;
        this.shouldReloadSearch = false;
        this.children().clear();
        this.window = Minecraft.getInstance().getWindow();
        this.bounds = ScreenOverlayImpl.calculateOverlayBounds();
        if (ConfigObject.getInstance().isFavoritesEnabled()) {
            if (favoritesListWidget == null) {
                favoritesListWidget = new FavoritesListWidget();
            }
            ScreenOverlayImpl.favoritesListWidget.favoritePanel.resetRows();
            this.widgets.add(favoritesListWidget);
        }
        OverlaySearchField searchField = REIRuntimeImpl.getSearchField();
        searchField.getBounds().setBounds(this.getSearchFieldArea());
        this.widgets.add(searchField);
        EntryListWidget entryListWidget = ScreenOverlayImpl.getEntryListWidget();
        entryListWidget.updateArea(this.bounds, searchField.getText());
        this.widgets.add(entryListWidget);
        searchField.setResponder(s -> entryListWidget.updateSearch((String)s, false));
        entryListWidget.init(this);
        this.configButton = ConfigButtonWidget.create(this);
        this.widgets.add(this.configButton);
        if (ConfigObject.getInstance().isCraftableFilterEnabled()) {
            this.widgets.add(CraftableFilterButtonWidget.create(this));
        }
        this.widgets.add(this.draggingStack);
        this.widgets.add(InternalWidgets.wrapLateRenderable(this.hintsWidget));
        this.hintsWidget.init();
        this.widgets.add(InternalWidgets.wrapLateRenderable(new ImportantWarningsWidget()));
    }

    private Rectangle getSearchFieldArea() {
        int widthRemoved = 1;
        if (ConfigObject.getInstance().isCraftableFilterEnabled()) {
            widthRemoved += 22;
        }
        if (ConfigObject.getInstance().isLowerConfigButton()) {
            widthRemoved += 22;
        }
        SearchFieldLocation searchFieldLocation = REIRuntime.getInstance().getContextualSearchFieldLocation();
        return switch (searchFieldLocation) {
            default -> throw new MatchException(null, null);
            case SearchFieldLocation.TOP_SIDE -> this.getTopSideSearchFieldArea(widthRemoved);
            case SearchFieldLocation.BOTTOM_SIDE -> this.getBottomSideSearchFieldArea(widthRemoved);
            case SearchFieldLocation.CENTER -> this.getCenterSearchFieldArea(widthRemoved);
        };
    }

    private Rectangle getTopSideSearchFieldArea(int widthRemoved) {
        return new Rectangle(this.bounds.x + 2, 4, this.bounds.width - 6 - widthRemoved, 18);
    }

    private Rectangle getBottomSideSearchFieldArea(int widthRemoved) {
        return new Rectangle(this.bounds.x + 2, this.window.getGuiScaledHeight() - 22, this.bounds.width - 6 - widthRemoved, 18);
    }

    private Rectangle getCenterSearchFieldArea(int widthRemoved) {
        Rectangle screenBounds = ScreenRegistry.getInstance().getScreenBounds(this.minecraft.screen);
        return new Rectangle(screenBounds.x, this.window.getGuiScaledHeight() - 22, screenBounds.width - widthRemoved, 18);
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        if (this.shouldReload || !ScreenOverlayImpl.calculateOverlayBounds().equals((Object)this.bounds)) {
            this.init();
            ScreenOverlayImpl.getEntryListWidget().updateSearch(REIRuntimeImpl.getSearchField().getText(), true);
        } else {
            for (OverlayDecider decider : ScreenRegistry.getInstance().getDeciders(this.minecraft.screen)) {
                if (decider == null || !decider.shouldRecalculateArea(ConfigObject.getInstance().getDisplayPanelLocation(), this.bounds)) continue;
                this.init();
                break;
            }
        }
        if (this.shouldReloadSearch || ConfigManager.getInstance().isCraftableOnlyEnabled() && CraftableFilter.INSTANCE.wasDirty()) {
            this.shouldReloadSearch = false;
            ScreenOverlayImpl.getEntryListWidget().updateSearch(REIRuntimeImpl.getSearchField().getText(), true);
        }
        if (OverlaySearchField.isHighlighting) {
            EntryHighlighter.render(graphics);
        }
        if (!this.hasSpace()) {
            return;
        }
        this.renderWidgets(graphics, mouseX, mouseY, delta);
        if (ConfigObject.getInstance().areClickableRecipeArrowsEnabled()) {
            Screen screen = Minecraft.getInstance().screen;
            ClickArea.ClickAreaContext<Screen> context = this.createClickAreaContext(mouseX, mouseY, screen);
            List<Component> clickAreaTooltips = ScreenRegistry.getInstance().getClickAreaTooltips(screen.getClass(), context);
            if (clickAreaTooltips != null && !clickAreaTooltips.isEmpty()) {
                Tooltip.create(clickAreaTooltips).queue();
            }
        }
    }

    private ClickArea.ClickAreaContext<Screen> createClickAreaContext(final double mouseX, final double mouseY, final Screen screen) {
        return new ClickArea.ClickAreaContext<Screen>(this){

            @Override
            public Screen getScreen() {
                return screen;
            }

            @Override
            public Point getMousePosition() {
                return new Point(mouseX, mouseY);
            }
        };
    }

    private static Rectangle calculateOverlayBounds() {
        Rectangle bounds = ScreenRegistry.getInstance().getOverlayBounds(ConfigObject.getInstance().getDisplayPanelLocation(), Minecraft.getInstance().screen);
        double hAlign = ConfigObject.getInstance().getDisplayPanelLocation() == DisplayPanelLocation.LEFT ? 1.0 - ConfigObject.getInstance().getHorizontalEntriesBoundariesAlignments() : ConfigObject.getInstance().getHorizontalEntriesBoundariesAlignments();
        int widthReduction = (int)Math.round((double)bounds.width * (1.0 - ConfigObject.getInstance().getHorizontalEntriesBoundariesPercentage()));
        bounds.x += (int)Math.round((double)widthReduction * hAlign);
        bounds.width -= widthReduction;
        int maxWidth = (int)Math.ceil((double)EntryListWidget.entrySize() * ConfigObject.getInstance().getHorizontalEntriesBoundariesColumns() + (double)EntryListWidget.entrySize() * 0.75);
        if (bounds.width > maxWidth) {
            bounds.x += (int)Math.round((double)(bounds.width - maxWidth) * hAlign);
            bounds.width = maxWidth;
        }
        return ScreenOverlayImpl.avoidButtons(bounds);
    }

    private static Rectangle avoidButtons(Rectangle bounds) {
        int buttonsHeight = 2;
        if (REIRuntime.getInstance().getContextualSearchFieldLocation() == SearchFieldLocation.TOP_SIDE) {
            buttonsHeight += 24;
        }
        if (!ConfigObject.getInstance().isEntryListWidgetScrolled()) {
            buttonsHeight += 22;
        }
        Rectangle area = REIRuntime.getInstance().calculateEntryListArea(bounds).clone();
        area.height = buttonsHeight;
        return RectangleUtils.excludeZones(bounds, ScreenRegistry.getInstance().exclusionZones().getExclusionZones(Minecraft.getInstance().screen).stream().filter(zone -> zone.intersects(area)));
    }

    public void lateRender(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        if (REIRuntime.getInstance().isOverlayVisible() && this.hasSpace()) {
            for (Widget widget : this.widgets) {
                if (widget instanceof LateRenderable && widget != this.menuHolder.widget()) {
                    widget.render(graphics, mouseX, mouseY, delta);
                    continue;
                }
                if (!(widget instanceof OverlaySearchField)) continue;
                OverlaySearchField field = (OverlaySearchField)widget;
                field.laterRender(graphics, mouseX, mouseY, delta);
            }
            this.menuHolder.lateRender(graphics, mouseX, mouseY, delta);
            if (this.choosePageWidget != null) {
                graphics.fillGradient(0, 0, this.window.getGuiScaledWidth(), this.window.getGuiScaledHeight(), -1072689136, -804253680);
                this.choosePageWidget.render(graphics, mouseX, mouseY, delta);
            }
        }
        if (this.choosePageWidget == null) {
            TOOLTIPS.stream().filter(Objects::nonNull).reduce((tooltip, tooltip2) -> tooltip2).ifPresent(tooltip -> this.renderTooltip(graphics, (Tooltip)tooltip));
        }
        TOOLTIPS.clear();
        if (REIRuntime.getInstance().isOverlayVisible()) {
            this.menuHolder.afterRender();
        }
        graphics.renderDeferredElements();
    }

    public void renderTooltip(GuiGraphics graphics, Tooltip tooltip) {
        this.renderTooltipInner(this.minecraft.screen, graphics, tooltip, tooltip.getX(), tooltip.getY());
    }

    protected abstract void renderTooltipInner(Screen var1, GuiGraphics var2, Tooltip var3, int var4, int var5);

    public void addTooltip(@Nullable Tooltip tooltip) {
        if (tooltip != null) {
            TOOLTIPS.add(tooltip);
        }
    }

    public void clearTooltips() {
        TOOLTIPS.clear();
    }

    public void renderWidgets(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        if (!REIRuntime.getInstance().isOverlayVisible()) {
            return;
        }
        for (Widget widget : this.widgets) {
            if (widget instanceof LateRenderable) continue;
            widget.render(graphics, mouseX, mouseY, delta);
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double amountX, double amountY) {
        if (!REIRuntime.getInstance().isOverlayVisible()) {
            return false;
        }
        if (this.menuHolder.mouseScrolled(mouseX, mouseY, amountX, amountY)) {
            return true;
        }
        if (this.hintsWidget.mouseScrolled(mouseX, mouseY, amountX, amountY)) {
            return true;
        }
        if (this.isInside(mouseX, mouseY) && ScreenOverlayImpl.getEntryListWidget().mouseScrolled(mouseX, mouseY, amountX, amountY)) {
            return true;
        }
        if (this.isNotInExclusionZones(PointHelper.getMouseX(), PointHelper.getMouseY()) && favoritesListWidget != null && favoritesListWidget.mouseScrolled(mouseX, mouseY, amountX, amountY)) {
            return true;
        }
        for (Widget widget : this.widgets) {
            if (widget == ScreenOverlayImpl.getEntryListWidget() || favoritesListWidget != null && widget == favoritesListWidget || widget == this.menuHolder.widget() || widget == this.hintsWidget || !widget.mouseScrolled(mouseX, mouseY, amountX, amountY)) continue;
            return true;
        }
        return false;
    }

    public boolean keyPressed(KeyEvent event) {
        if (!this.hasSpace()) {
            return false;
        }
        if (REIRuntime.getInstance().isOverlayVisible()) {
            if (event.isEscape() && this.choosePageWidget != null) {
                this.choosePageWidget = null;
                return true;
            }
            if (this.choosePageWidget != null) {
                return this.choosePageWidget.keyPressed(event);
            }
            if (REIRuntimeImpl.getSearchField().keyPressed(event)) {
                return true;
            }
            for (GuiEventListener guiEventListener : this.widgets) {
                if (guiEventListener == REIRuntimeImpl.getSearchField() || !guiEventListener.keyPressed(event)) continue;
                return true;
            }
        }
        if (ConfigObject.getInstance().getHideKeybind().matchesKey(event.key(), event.scancode())) {
            REIRuntime.getInstance().toggleOverlayVisible();
            return true;
        }
        EntryStack<?> stack = ScreenRegistry.getInstance().getFocusedStack(Minecraft.getInstance().screen, PointHelper.ofMouse());
        if (stack != null && !stack.isEmpty()) {
            stack = stack.copy();
            if (ConfigObject.getInstance().getRecipeKeybind().matchesKey(event.key(), event.scancode())) {
                return ViewSearchBuilder.builder().addRecipesFor(stack).open();
            }
            if (ConfigObject.getInstance().getUsageKeybind().matchesKey(event.key(), event.scancode())) {
                return ViewSearchBuilder.builder().addUsagesFor(stack).open();
            }
            if (ConfigObject.getInstance().getFavoriteKeyCode().matchesKey(event.key(), event.scancode())) {
                FavoriteEntry favoriteEntry = FavoriteEntry.fromEntryStack(stack);
                ConfigObject.getInstance().getFavoriteEntries().add(favoriteEntry);
                return true;
            }
        }
        if (!REIRuntime.getInstance().isOverlayVisible()) {
            return false;
        }
        if (ConfigObject.getInstance().getFocusSearchFieldKeybind().matchesKey(event.key(), event.scancode())) {
            REIRuntimeImpl.getSearchField().setFocused(true);
            this.setFocused((GuiEventListener)REIRuntimeImpl.getSearchField());
            REIRuntimeImpl.getSearchField().keybindFocusTime = System.currentTimeMillis();
            REIRuntimeImpl.getSearchField().keybindFocusKey = event.key();
            return true;
        }
        return false;
    }

    public boolean keyReleased(KeyEvent event) {
        if (!this.hasSpace()) {
            return false;
        }
        if (REIRuntime.getInstance().isOverlayVisible() && this.choosePageWidget == null) {
            if (REIRuntimeImpl.getSearchField().keyReleased(event)) {
                return true;
            }
            for (GuiEventListener guiEventListener : this.widgets) {
                if (guiEventListener == REIRuntimeImpl.getSearchField() || guiEventListener != this.getFocused() || !guiEventListener.keyReleased(event)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean charTyped(CharacterEvent event) {
        if (!REIRuntime.getInstance().isOverlayVisible()) {
            return false;
        }
        if (!this.hasSpace()) {
            return false;
        }
        if (this.choosePageWidget != null) {
            return this.choosePageWidget.charTyped(event);
        }
        if (REIRuntimeImpl.getSearchField().charTyped(event)) {
            return true;
        }
        for (GuiEventListener guiEventListener : this.widgets) {
            if (guiEventListener == REIRuntimeImpl.getSearchField() || !guiEventListener.charTyped(event)) continue;
            return true;
        }
        return false;
    }

    public List<Widget> children() {
        return this.widgets;
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
        boolean visible = REIRuntime.getInstance().isOverlayVisible();
        if (this.choosePageWidget != null) {
            if (this.choosePageWidget.containsMouse(event.x(), event.y())) {
                return this.choosePageWidget.mouseClicked(event, doubleClick);
            }
            this.choosePageWidget = null;
            this.init();
            return false;
        }
        if (!this.hasSpace()) {
            return false;
        }
        if (visible && this.configButton.mouseClicked(event, doubleClick)) {
            this.setFocused((GuiEventListener)this.configButton);
            if (event.button() == 0) {
                this.setDragging(true);
            }
            return true;
        }
        if (ConfigObject.getInstance().getHideKeybind().matchesMouse(event.button())) {
            REIRuntime.getInstance().toggleOverlayVisible();
            return REIRuntime.getInstance().isOverlayVisible();
        }
        EntryStack<?> stack = ScreenRegistry.getInstance().getFocusedStack(Minecraft.getInstance().screen, PointHelper.ofMouse());
        if (stack != null && !stack.isEmpty()) {
            stack = stack.copy();
            if (ConfigObject.getInstance().getRecipeKeybind().matchesMouse(event.button())) {
                return ViewSearchBuilder.builder().addRecipesFor(stack).open();
            }
            if (ConfigObject.getInstance().getUsageKeybind().matchesMouse(event.button())) {
                return ViewSearchBuilder.builder().addUsagesFor(stack).open();
            }
            if (visible && ConfigObject.getInstance().getFavoriteKeyCode().matchesMouse(event.button())) {
                FavoriteEntry favoriteEntry = FavoriteEntry.fromEntryStack(stack);
                ConfigObject.getInstance().getFavoriteEntries().add(favoriteEntry);
                return true;
            }
        }
        if (visible) {
            Widget menuWidget = this.menuHolder.widget();
            if (menuWidget != null && menuWidget.mouseClicked(event, doubleClick)) {
                this.setFocused((GuiEventListener)menuWidget);
                if (event.button() == 0) {
                    this.setDragging(true);
                }
                REIRuntimeImpl.getSearchField().setFocused(false);
                return true;
            }
            if (this.hintsWidget.mouseClicked(event, doubleClick)) {
                this.setFocused((GuiEventListener)this.hintsWidget);
                if (event.button() == 0) {
                    this.setDragging(true);
                }
                REIRuntimeImpl.getSearchField().setFocused(false);
                return true;
            }
        }
        if (ConfigObject.getInstance().areClickableRecipeArrowsEnabled()) {
            Screen screen = Minecraft.getInstance().screen;
            ClickArea.ClickAreaContext<Screen> clickAreaContext = this.createClickAreaContext(event.x(), event.y(), screen);
            if (ScreenRegistry.getInstance().executeClickArea(screen.getClass(), clickAreaContext)) {
                return true;
            }
        }
        if (!visible) {
            return false;
        }
        for (GuiEventListener guiEventListener : this.widgets) {
            if (guiEventListener == this.configButton || guiEventListener == this.menuHolder.widget() || guiEventListener == this.hintsWidget || guiEventListener == this.draggingStack || !guiEventListener.mouseClicked(event, doubleClick)) continue;
            this.setFocused(guiEventListener);
            if (event.button() == 0) {
                this.setDragging(true);
            }
            if (!(guiEventListener instanceof OverlaySearchField)) {
                REIRuntimeImpl.getSearchField().setFocused(false);
            }
            return true;
        }
        if (this.draggingStack != null) {
            this.draggingStack.mouseClicked(event, doubleClick);
        }
        if (ConfigObject.getInstance().getFocusSearchFieldKeybind().matchesMouse(event.button())) {
            REIRuntimeImpl.getSearchField().setFocused(true);
            this.setFocused((GuiEventListener)REIRuntimeImpl.getSearchField());
            REIRuntimeImpl.getSearchField().keybindFocusTime = -1L;
            REIRuntimeImpl.getSearchField().keybindFocusKey = -1;
            return true;
        }
        return false;
    }

    public boolean mouseDragged(MouseButtonEvent event, double deltaX, double deltaY) {
        if (!REIRuntime.getInstance().isOverlayVisible()) {
            return false;
        }
        if (!this.hasSpace()) {
            return false;
        }
        if (this.choosePageWidget != null) {
            return this.choosePageWidget.mouseDragged(event, deltaX, deltaY);
        }
        return this.getFocused() != null && this.isDragging() && event.button() == 0 && this.getFocused().mouseDragged(event, deltaX, deltaY);
    }

    public boolean mouseReleased(MouseButtonEvent event) {
        if (this.draggingStack != null) {
            this.draggingStack.mouseReleased(event);
        }
        return super.mouseReleased(event);
    }

    @Override
    public GuiEventListener getFocused() {
        if (this.choosePageWidget != null) {
            return this.choosePageWidget;
        }
        return super.getFocused();
    }

    public boolean isInside(double mouseX, double mouseY) {
        return this.bounds.contains(mouseX, mouseY) && this.isNotInExclusionZones(mouseX, mouseY);
    }

    @Override
    public boolean isNotInExclusionZones(double mouseX, double mouseY) {
        for (OverlayDecider decider : ScreenRegistry.getInstance().getDeciders(Minecraft.getInstance().screen)) {
            InteractionResult in = decider.isInZone(mouseX, mouseY);
            if (in == InteractionResult.PASS) continue;
            return in == InteractionResult.SUCCESS;
        }
        return true;
    }

    public boolean isInside(Point point) {
        return this.isInside(point.getX(), point.getY());
    }

    @Override
    public OverlayListWidget getEntryList() {
        return ScreenOverlayImpl.getEntryListWidget();
    }

    @Override
    public Optional<OverlayListWidget> getFavoritesList() {
        return Optional.ofNullable(ScreenOverlayImpl.getFavoritesListWidget());
    }

    public MenuAccess menuAccess() {
        return this.menuHolder;
    }

    public HintsContainerWidget getHintsContainer() {
        return this.hintsWidget;
    }
}

