/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.entry.filtering.rules;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Iterators;
import java.util.AbstractList;
import java.util.Iterator;
import me.shedaniel.rei.api.client.entry.filtering.FilteringRuleType;
import me.shedaniel.rei.api.client.entry.filtering.FilteringRuleTypeRegistry;
import me.shedaniel.rei.api.client.entry.filtering.base.BasicFilteringRule;
import me.shedaniel.rei.impl.client.entry.filtering.rules.BasicFilteringRuleImpl;
import me.shedaniel.rei.impl.client.entry.filtering.rules.BasicFilteringRuleType;
import me.shedaniel.rei.impl.client.entry.filtering.rules.ManualFilteringRuleType;
import me.shedaniel.rei.impl.client.entry.filtering.rules.SearchFilteringRuleType;
import me.shedaniel.rei.impl.common.InternalLogger;
import net.minecraft.resources.Identifier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class FilteringRuleTypeRegistryImpl
extends AbstractList<FilteringRuleType<?>>
implements FilteringRuleTypeRegistry {
    private final BiMap<Identifier, FilteringRuleType<?>> types = HashBiMap.create();

    public FilteringRuleTypeRegistryImpl() {
        this.register(Identifier.fromNamespaceAndPath((String)"roughlyenoughitems", (String)"search"), SearchFilteringRuleType.INSTANCE);
        this.register(Identifier.fromNamespaceAndPath((String)"roughlyenoughitems", (String)"manual"), ManualFilteringRuleType.INSTANCE);
        this.register(Identifier.fromNamespaceAndPath((String)"roughlyenoughitems", (String)"basic"), BasicFilteringRuleType.INSTANCE);
    }

    @Override
    public Iterator<FilteringRuleType<?>> iterator() {
        return this.types.values().iterator();
    }

    @Override
    public FilteringRuleType<?> get(int index) {
        return (FilteringRuleType)Iterators.get(this.iterator(), (int)index);
    }

    @Override
    public int size() {
        return this.types.size();
    }

    @Override
    @Nullable
    public FilteringRuleType<?> get(Identifier id) {
        return (FilteringRuleType)this.types.get((Object)id);
    }

    @Override
    @Nullable
    public Identifier getId(FilteringRuleType<?> rule) {
        return (Identifier)this.types.inverse().get(rule);
    }

    @Override
    public void register(Identifier id, FilteringRuleType<?> rule) {
        this.types.put((Object)id, rule);
        InternalLogger.getInstance().debug("Added filtering rule [%s]: %s", id, rule);
    }

    @Override
    public BasicFilteringRule<?> basic() {
        return BasicFilteringRuleImpl.INSTANCE;
    }
}

