/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.config.entries;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.gui.widget.DynamicEntryListWidget;
import me.shedaniel.rei.api.client.entry.filtering.FilteringRule;
import me.shedaniel.rei.api.client.entry.filtering.FilteringRuleType;
import me.shedaniel.rei.api.client.entry.filtering.FilteringRuleTypeRegistry;
import me.shedaniel.rei.impl.client.gui.widget.UpdatedListWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class FilteringAddRuleScreen
extends Screen {
    private final List<FilteringRule<?>> rules;
    private RulesList rulesList;
    Screen parent;

    public FilteringAddRuleScreen(List<FilteringRule<?>> rules) {
        super((Component)Component.translatable((String)"config.roughlyenoughitems.filteringRulesScreen.new"));
        this.rules = rules;
    }

    public void init() {
        super.init();
        MutableComponent backText = Component.literal((String)"\u21a9 ").append((Component)Component.translatable((String)"gui.back"));
        this.addRenderableWidget((GuiEventListener)new Button.Plain(this, 4, 4, Minecraft.getInstance().font.width((FormattedText)backText) + 10, 20, (Component)backText, button -> {
            this.minecraft.setScreen(this.parent);
            this.parent = null;
        }, Supplier::get){});
        this.rulesList = (RulesList)this.addWidget((GuiEventListener)new RulesList(this.minecraft, this.width, this.height, 30, this.height));
        for (FilteringRuleType rule : FilteringRuleTypeRegistry.getInstance()) {
            if (rule.isSingular()) continue;
            this.rulesList.addItem(new DefaultRuleEntry(this.parent, this.rules, (FilteringRule<?>)rule.createNew(), null));
        }
        this.rulesList.selectItem((DynamicEntryListWidget.Entry)((RuleEntry)((Object)this.rulesList.children().get(0))));
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        super.render(graphics, mouseX, mouseY, delta);
        this.rulesList.render(graphics, mouseX, mouseY, delta);
        graphics.drawString(this.font, this.title.getVisualOrderText(), (int)((float)this.width / 2.0f - (float)this.font.width((FormattedText)this.title) / 2.0f), 12, -1);
    }

    public void onClose() {
        this.minecraft.setScreen(this.parent);
    }

    public static class RulesList
    extends UpdatedListWidget<RuleEntry> {
        private boolean inFocus;

        public RulesList(Minecraft client, int width, int height, int top, int bottom) {
            super(client, width, height, top, bottom);
        }

        protected boolean isSelected(int index) {
            return Objects.equals(this.getSelectedItem(), this.children().get(index));
        }

        protected int addItem(RuleEntry item) {
            return super.addItem((DynamicEntryListWidget.Entry)item);
        }

        public int getItemWidth() {
            return this.width - 40;
        }

        protected int getScrollbarPosition() {
            return this.width - 14;
        }
    }

    public static class DefaultRuleEntry
    extends RuleEntry {
        private final Button addButton;
        private final Function<Screen, Screen> screenFunction;

        public DefaultRuleEntry(Screen parent, List<FilteringRule<?>> rules, FilteringRule<?> rule, Function<Screen, Screen> screenFunction) {
            super(rule);
            this.screenFunction = screenFunction == null ? rule.getType().createEntryScreen(rule) : screenFunction;
            this.addButton = new Button.Plain(this, 0, 0, 20, 20, Component.nullToEmpty((String)" + "), button -> {
                Minecraft.getInstance().setScreen(this.screenFunction.apply(parent));
                rules.add(0, rule);
            }, Supplier::get){};
            this.addButton.active = this.screenFunction != null;
        }

        public void render(GuiGraphics graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
            Minecraft client = Minecraft.getInstance();
            Component title = this.getRule().getType().getTitle(this.getRule());
            int i = client.font.width((FormattedText)title);
            if (i > entryWidth - 28) {
                FormattedText titleTrimmed = FormattedText.composite((FormattedText[])new FormattedText[]{client.font.substrByWidth((FormattedText)title, entryWidth - 28 - client.font.width("...")), FormattedText.of((String)"...")});
                graphics.drawString(client.font, Language.getInstance().getVisualOrder(titleTrimmed), x + 2, y + 1, -1);
            } else {
                graphics.drawString(client.font, title.getVisualOrderText(), x + 2, y + 1, -1);
            }
            Component subtitle = this.getRule().getType().getSubtitle(this.getRule());
            i = client.font.width((FormattedText)subtitle);
            if (i > entryWidth - 28) {
                FormattedText subtitleTrimmed = FormattedText.composite((FormattedText[])new FormattedText[]{client.font.substrByWidth((FormattedText)subtitle, entryWidth - 28 - client.font.width("...")), FormattedText.of((String)"...")});
                graphics.drawString(client.font, Language.getInstance().getVisualOrder(subtitleTrimmed), x + 2, y + 12, -8355712);
            } else {
                graphics.drawString(client.font, subtitle.getVisualOrderText(), x + 2, y + 12, -8355712);
            }
            this.addButton.setX(x + entryWidth - 25);
            this.addButton.setY(y + 1);
            this.addButton.render(graphics, mouseX, mouseY, delta);
        }

        @Override
        public List<? extends GuiEventListener> children() {
            return Collections.singletonList(this.addButton);
        }

        public List<? extends NarratableEntry> narratables() {
            return Collections.singletonList(this.addButton);
        }
    }

    public static abstract class RuleEntry
    extends UpdatedListWidget.ElementEntry<RuleEntry> {
        private final FilteringRule<?> rule;

        public RuleEntry(FilteringRule<?> rule) {
            this.rule = rule;
        }

        public FilteringRule<?> getRule() {
            return this.rule;
        }

        public int getItemHeight() {
            return 26;
        }
    }
}

