/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl;

import com.mojang.serialization.DataResult;
import dev.architectury.utils.value.BooleanValue;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.ClientHelper;
import me.shedaniel.rei.api.client.entry.filtering.FilteringRuleTypeRegistry;
import me.shedaniel.rei.api.client.entry.renderer.EntryRenderer;
import me.shedaniel.rei.api.client.favorites.FavoriteEntry;
import me.shedaniel.rei.api.client.favorites.FavoriteMenuEntry;
import me.shedaniel.rei.api.client.gui.DrawableConsumer;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Arrow;
import me.shedaniel.rei.api.client.gui.widgets.BurningFire;
import me.shedaniel.rei.api.client.gui.widgets.Button;
import me.shedaniel.rei.api.client.gui.widgets.Label;
import me.shedaniel.rei.api.client.gui.widgets.Panel;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.TooltipContext;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.screen.ClickArea;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandler;
import me.shedaniel.rei.api.client.registry.transfer.simple.SimpleTransferHandler;
import me.shedaniel.rei.api.client.view.ViewSearchBuilder;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.InputIngredient;
import me.shedaniel.rei.api.common.plugins.PluginManager;
import me.shedaniel.rei.api.common.transfer.info.stack.SlotAccessor;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.Identifier;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;

@ApiStatus.Internal
public final class ClientInternals {
    private static Supplier<ClientHelper> clientHelper = ClientInternals::throwNotSetup;
    private static Supplier<WidgetsProvider> widgetsProvider = ClientInternals::throwNotSetup;
    private static Supplier<ViewSearchBuilder> viewSearchBuilder = ClientInternals::throwNotSetup;
    private static Supplier<PluginManager<REIClientPlugin>> clientPluginManager = ClientInternals::throwNotSetup;
    private static Supplier<EntryRenderer<?>> emptyEntryRenderer = ClientInternals::throwNotSetup;
    private static Supplier<FilteringRuleTypeRegistry> filteringRuleTypeRegistry = ClientInternals::throwNotSetup;
    private static Supplier<SimpleTransferHandler> simpleTransferHandler = ClientInternals::throwNotSetup;
    private static BiFunction<Supplier<DataResult<FavoriteEntry>>, Supplier<CompoundTag>, FavoriteEntry> delegateFavoriteEntry = (supplier, toJson) -> (FavoriteEntry)ClientInternals.throwNotSetup();
    private static BiFunction<Component, List<FavoriteMenuEntry>, FavoriteMenuEntry> subMenuEntry = (supplier, toJson) -> (FavoriteMenuEntry)ClientInternals.throwNotSetup();
    private static BiFunction<Component, BooleanValue, FavoriteMenuEntry> toggleEntry = (supplier, toJson) -> (FavoriteMenuEntry)ClientInternals.throwNotSetup();
    private static Function<CompoundTag, DataResult<FavoriteEntry>> favoriteEntryFromJson = object -> (DataResult)ClientInternals.throwNotSetup();
    private static Function<Boolean, ClickArea.Result> clickAreaHandlerResult = result -> (ClickArea.Result)ClientInternals.throwNotSetup();
    private static BiFunction<@Nullable Point, Collection<Tooltip.Entry>, Tooltip> tooltipProvider = (point, texts) -> (Tooltip)ClientInternals.throwNotSetup();
    private static QuadFunction<Point, @Nullable TooltipFlag, Boolean, // Could not load outer class - annotation placement on inner may be incorrect
    Item.TooltipContext, TooltipContext> tooltipContextProvider = (point, texts, search, context) -> (TooltipContext)ClientInternals.throwNotSetup();
    private static Function<Object, Tooltip.Entry> tooltipEntryProvider = component -> (Tooltip.Entry)ClientInternals.throwNotSetup();
    private static Supplier<List<String>> jeiCompatMods = ClientInternals::throwNotSetup;
    private static Supplier<Object> builtinClientPlugin = ClientInternals::throwNotSetup;
    private static Function<List<EntryIngredient>, TooltipComponent> missingTooltip = stacks -> (TooltipComponent)ClientInternals.throwNotSetup();

    private static <T> T throwNotSetup() {
        throw new AssertionError((Object)"REI Internals have not been initialized!");
    }

    @ApiStatus.Internal
    public static <T> void attachInstance(T instance, Class<T> clazz) {
        ClientInternals.attachInstanceSupplier(instance, clazz.getSimpleName());
    }

    @ApiStatus.Internal
    public static <T> void attachInstanceSupplier(T instance, String name) {
        ClientInternals.attachInstance(() -> instance, name);
    }

    public static <T> void attachInstance(T instance, String name) {
        try {
            for (Field field : ClientInternals.class.getDeclaredFields()) {
                if (!field.getName().equalsIgnoreCase(name)) continue;
                field.setAccessible(true);
                field.set(null, instance);
                return;
            }
            throw new RuntimeException("Failed to attach " + String.valueOf(instance) + " with field name: " + name);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static ClientHelper getClientHelper() {
        return clientHelper.get();
    }

    public static WidgetsProvider getWidgetsProvider() {
        return widgetsProvider.get();
    }

    public static ViewSearchBuilder createViewSearchBuilder() {
        return viewSearchBuilder.get();
    }

    public static Object getBuiltinPlugin() {
        return builtinClientPlugin.get();
    }

    public static ClickArea.Result createClickAreaHandlerResult(boolean applicable) {
        return clickAreaHandlerResult.apply(applicable);
    }

    public static Tooltip createTooltip(@Nullable Point point, Collection<Tooltip.Entry> texts) {
        return tooltipProvider.apply(point, texts);
    }

    public static TooltipContext createTooltipContext(Point point, @Nullable TooltipFlag flag, boolean isSearch, Item.TooltipContext context) {
        return tooltipContextProvider.apply(point, flag, isSearch, context);
    }

    public static Tooltip.Entry createTooltipEntry(Object component) {
        return tooltipEntryProvider.apply(component);
    }

    public static FavoriteEntry delegateFavoriteEntry(Supplier<DataResult<FavoriteEntry>> supplier, Supplier<CompoundTag> toJoin) {
        return delegateFavoriteEntry.apply(supplier, toJoin);
    }

    public static FavoriteMenuEntry createSubMenuEntry(Component name, List<FavoriteMenuEntry> entries) {
        return subMenuEntry.apply(name, entries);
    }

    public static FavoriteMenuEntry createToggleEntry(Component name, BooleanValue value) {
        return toggleEntry.apply(name, value);
    }

    public static DataResult<FavoriteEntry> favoriteEntryFromJson(CompoundTag tag) {
        return favoriteEntryFromJson.apply(tag);
    }

    public static <T> EntryRenderer<T> getEmptyEntryRenderer() {
        return emptyEntryRenderer.get().cast();
    }

    public static List<String> getJeiCompatMods() {
        return jeiCompatMods.get();
    }

    public static PluginManager<REIClientPlugin> getPluginManager() {
        return clientPluginManager.get();
    }

    public static TooltipComponent createMissingTooltip(List<EntryIngredient> stacks) {
        return missingTooltip.apply(stacks);
    }

    public static FilteringRuleTypeRegistry getFilteringRuleTypeRegistry() {
        return filteringRuleTypeRegistry.get();
    }

    public static SimpleTransferHandler getSimpleTransferHandler() {
        return simpleTransferHandler.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface WidgetsProvider {
        public Widget wrapVanillaWidget(GuiEventListener var1);

        public WidgetWithBounds wrapRenderer(Supplier<Rectangle> var1, Renderer var2);

        public WidgetWithBounds withTranslate(WidgetWithBounds var1, Supplier<Matrix3x2f> var2);

        public Widget createDrawableWidget(DrawableConsumer var1);

        public Slot createSlot(Point var1);

        public Slot createSlot(Rectangle var1);

        public Button createButton(Rectangle var1, Component var2);

        public Panel createPanelWidget(Rectangle var1);

        public Label createLabel(Point var1, FormattedText var2);

        public Arrow createArrow(Rectangle var1);

        public BurningFire createBurningFire(Rectangle var1);

        public DrawableConsumer createTexturedConsumer(Identifier var1, int var2, int var3, int var4, int var5, float var6, float var7, int var8, int var9, int var10, int var11);

        public DrawableConsumer createFillRectangleConsumer(Rectangle var1, int var2);

        public Widget createShapelessIcon(Point var1);

        public Widget concatWidgets(List<Widget> var1);

        public WidgetWithBounds concatWidgetsWithBounds(Supplier<Rectangle> var1, List<Widget> var2);

        public WidgetWithBounds noOp();

        public WidgetWithBounds wrapOverflow(Rectangle var1, WidgetWithBounds var2);

        public WidgetWithBounds wrapScissored(Rectangle var1, Widget var2);

        public WidgetWithBounds wrapScissored(WidgetWithBounds var1);

        public WidgetWithBounds wrapPadded(int var1, int var2, int var3, int var4, WidgetWithBounds var5);
    }

    public static interface QuadFunction<T, U, V, W, R> {
        public R apply(T var1, U var2, V var3, W var4);
    }

    public static interface SimpleTransferHandler {
        public TransferHandler.Result handle(TransferHandler.Context var1, SimpleTransferHandler.MissingInputRenderer var2, List<InputIngredient<ItemStack>> var3, Iterable<SlotAccessor> var4, Iterable<SlotAccessor> var5);
    }
}

