/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.common.display;

import com.mojang.serialization.MapCodec;
import me.shedaniel.rei.api.common.display.Display;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.NonExtendable
public interface DisplaySerializer<D extends Display> {
    public MapCodec<D> codec();

    public StreamCodec<RegistryFriendlyByteBuf, D> streamCodec();

    default public boolean isPersistent() {
        return true;
    }

    public static <D extends Display> DisplaySerializer<D> of(MapCodec<D> codec, StreamCodec<RegistryFriendlyByteBuf, D> streamCodec) {
        return DisplaySerializer.of(codec, streamCodec, true);
    }

    public static <D extends Display> DisplaySerializer<D> of(final MapCodec<D> codec, final StreamCodec<RegistryFriendlyByteBuf, D> streamCodec, final boolean persistent) {
        return new DisplaySerializer<D>(){

            @Override
            public MapCodec<D> codec() {
                return codec;
            }

            @Override
            public StreamCodec<RegistryFriendlyByteBuf, D> streamCodec() {
                return streamCodec;
            }

            @Override
            public boolean isPersistent() {
                return persistent;
            }
        };
    }
}

