/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020, 2021, 2022, 2023 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.impl.common.category;

import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.impl.Internals;
import net.minecraft.class_2960;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class CategoryIdentifierImpl<D extends Display> implements CategoryIdentifier<D> {
    private final class_2960 location;
    private final int hashCode;
    
    public CategoryIdentifierImpl(class_2960 location) {
        this.location = Objects.requireNonNull(location);
        this.hashCode = location.hashCode();
    }
    
    @Override
    public class_2960 getIdentifier() {
        return location;
    }
    
    @Override
    public int hashCode() {
        return hashCode;
    }
    
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof CategoryIdentifier<?> that)) return false;
        if (obj instanceof CategoryIdentifierImpl<?> thatImpl) {
            return hashCode == obj.hashCode() && location.equals(thatImpl.location);
        }
        
        return location.equals(that.getIdentifier());
    }
    
    @Override
    public String toString() {
        return location.toString();
    }
    
    public static void attach() {
        Map<String, CategoryIdentifier<?>> cache = new ConcurrentHashMap<>();
        Internals.attachInstance((Function<String, CategoryIdentifier<?>>) id -> {
            CategoryIdentifier<?> identifier = cache.get(id);
            if (identifier != null) return identifier;
            identifier = new CategoryIdentifierImpl<>(class_2960.method_60654(id));
            cache.put(id, identifier);
            return identifier;
        }, "categoryIdentifier");
    }
}
