/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020, 2021, 2022, 2023 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.impl.client.search.argument.type;

import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.config.SearchMode;
import me.shedaniel.rei.api.common.entry.EntryStack;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3902;
import net.minecraft.class_5251;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
@Environment(EnvType.CLIENT)
public final class IdentifierArgumentType extends ArgumentType<class_3902, String> {
    private static final String EMPTY = "";
    private static final class_2583 STYLE = class_2583.field_24360.method_27703(class_5251.method_27717(0x8d7eed));
    
    @Override
    public String getName() {
        return "identifier";
    }
    
    @Override
    @Nullable
    public String getPrefix() {
        return "*";
    }
    
    @Override
    public class_2583 getHighlightedStyle() {
        return STYLE;
    }
    
    @Override
    public SearchMode getSearchMode() {
        return ConfigObject.getInstance().getIdentifierSearchMode();
    }
    
    @Override
    public String cacheData(EntryStack<?> stack) {
        class_2960 identifier = stack.getIdentifier();
        if (identifier != null) {
            String s = identifier.method_12832();
            if (!s.isEmpty()) {
                return s;
            }
        }
        return EMPTY;
    }
    
    @Override
    public void matches(String identifier, EntryStack<?> stack, class_3902 filterData, ResultSink sink) {
        if (!identifier.isEmpty()) {
            sink.testString(identifier);
        }
    }
    
    @Override
    public class_3902 prepareSearchFilter(String searchText) {
        return class_3902.field_17274;
    }
}
