/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020, 2021, 2022, 2023 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.impl.client.gui.screen.collapsible;

import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.animator.ProgressValueAnimator;
import me.shedaniel.clothconfig2.api.animator.ValueAnimator;
import me.shedaniel.clothconfig2.api.scroll.ScrollingContainer;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.ClientHelper;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.widgets.CloseableScissors;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.config.collapsible.CollapsibleConfigManager;
import me.shedaniel.rei.impl.client.gui.InternalTextures;
import me.shedaniel.rei.impl.client.gui.ScreenOverlayImpl;
import me.shedaniel.rei.impl.client.gui.text.TextTransformations;
import me.shedaniel.rei.impl.client.gui.widget.EntryRendererManager;
import me.shedaniel.rei.impl.client.gui.widget.EntryWidget;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_5481;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;

@SuppressWarnings("UnstableApiUsage")
public class CollapsibleEntryWidget extends WidgetWithBounds {
    private final boolean custom;
    private final class_2960 id;
    private final class_2561 component;
    private final Collection<Slot> stacks;
    private final CollapsibleConfigManager.CollapsibleConfigObject configObject;
    private final ProgressValueAnimator<Boolean> idDrawer = ValueAnimator.ofBoolean();
    private final ProgressValueAnimator<Boolean> modIdDrawer = ValueAnimator.ofBoolean();
    private final class_4185 toggleButton;
    @Nullable
    private final class_4185 deleteButton;
    @Nullable
    private final class_4185 configureButton;
    private final ScrollingContainer scroller = new ScrollingContainer() {
        @Override
        public Rectangle getBounds() {
            return new Rectangle(x + width / 2 - 8 * rowSize, y + 37, 16 * rowSize, height - 40);
        }
        
        @Override
        public int getMaxScrollHeight() {
            return Math.max(0, class_3532.method_38788(stacks.size(), rowSize) * 16) + 24;
        }
    };
    private int x;
    private int y;
    private int width;
    private int height;
    private int rowSize;
    
    public CollapsibleEntryWidget(boolean custom, class_2960 id, class_2561 component, Collection<EntryStack<?>> stacks,
                                  CollapsibleConfigManager.CollapsibleConfigObject configObject, Runnable markDirty) {
        this.custom = custom;
        this.id = id;
        this.component = component;
        this.stacks = CollectionUtils.map(stacks, stack -> Widgets.createSlot(new Rectangle(0, 0, 16, 16))
                .entry(stack).disableBackground());
        this.configObject = configObject;
        this.toggleButton = new class_4185(0, 0, 20, 20, class_2561.method_43471("text.rei.collapsible.entries.toggle"), button -> {
            if (this.configObject.disabledGroups.contains(this.id)) {
                this.configObject.disabledGroups.remove(this.id);
            } else {
                this.configObject.disabledGroups.add(this.id);
            }
        }, Supplier::get) {
        };
        this.toggleButton.method_25358(this.font.method_27525(toggleButton.method_25369()) + 8);
        if (this.custom) {
            this.deleteButton = new class_4185(0, 0, 20, 20, class_2561.method_43471("text.rei.collapsible.entries.delete"), button -> {
                this.configObject.customGroups.removeIf(customEntry -> customEntry.id.equals(this.id));
                markDirty.run();
            }, Supplier::get) {
            };
            this.deleteButton.method_25358(this.font.method_27525(deleteButton.method_25369()) + 8);
            this.configureButton = new class_4185(0, 0, 20, 20, class_2561.method_30163(null), button -> {
                CollapsibleEntriesScreen.setupCustom(this.id, this.component.getString(), new ArrayList<>(stacks), this.configObject, markDirty);
            }, Supplier::get) {
                @Override
                protected void method_48579(class_332 graphics, int mouseX, int mouseY, float delta) {
                    super.method_48579(graphics, mouseX, mouseY, delta);
                    graphics.method_25290(class_10799.field_56883, InternalTextures.CHEST_GUI_TEXTURE, method_46426() + 3, method_46427() + 3, 0, 0, 14, 14, 256, 256);
                }
            };
        } else {
            this.deleteButton = null;
            this.configureButton = null;
        }
    }
    
    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }
    
    public void setWidth(int width) {
        if (this.width != width) {
            this.width = width;
            this.rowSize = Math.max(1, (width - 6) / 16);
            this.height = Math.min(42 + Math.max(class_3532.method_38788(this.stacks.size(), this.rowSize) * 16 + 24, 24), 170);
        }
    }
    
    public int getHeight() {
        return this.height;
    }
    
    @Override
    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }
    
    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        this.scroller.updatePosition(delta);
        this.idDrawer.update(delta);
        this.modIdDrawer.update(delta);
        Rectangle bounds = this.getBounds();
        graphics.method_25296(bounds.x, bounds.y, bounds.getMaxX(), bounds.getMaxY(), 0xFF777777, 0xFF777777);
        graphics.method_25296(bounds.x + 1, bounds.y + 1, bounds.getMaxX() - 1, bounds.getMaxY() - 1, 0xFF151515, 0xFF151515);
        int y = bounds.y + 4;
        if (y + 9 >= 30 && y < minecraft.field_1755.field_22790) {
            renderTextScrolling(graphics, this.component, bounds.x + 4, y, bounds.width - 8, 0xFFDDDDDD);
        }
        y += 13;
        if (y + 9 >= 30 && y < minecraft.field_1755.field_22790) {
            Rectangle lineBounds = new Rectangle(bounds.x + 4, y, bounds.width - 8, 9);
            idDrawer.setTo(lineBounds.contains(mouseX, mouseY), ConfigObject.getInstance().isReducedMotion() ? 0 : 400);
            try (CloseableScissors scissors = scissor(graphics, lineBounds)) {
                graphics.method_51448().pushMatrix();
                graphics.method_51448().translate(0, (float) (-idDrawer.progress() * 10));
                graphics.method_27535(font, class_2561.method_43469("text.rei.collapsible.entries.count", this.stacks.size() + ""), bounds.x + 4, y, 0xFFAAAAAA);
                boolean enabled = !this.configObject.disabledGroups.contains(this.id);
                class_2561 sideText = class_2561.method_43471("text.rei.collapsible.entries.enabled." + enabled);
                graphics.method_27535(font, sideText, bounds.getMaxX() - 4 - font.method_27525(sideText), y, enabled ? 0xDD55FF55 : 0xDDFF5555);
                renderTextScrolling(graphics, class_2561.method_43470(this.id.toString()), bounds.x + 4, y + 10, bounds.width - 8, 0xFF777777);
                graphics.method_51448().popMatrix();
            }
        }
        y += 10;
        if (y + 9 >= 30 && y < minecraft.field_1755.field_22790) {
            Rectangle lineBounds = new Rectangle(bounds.x + 4, y, bounds.width - 8, 9);
            modIdDrawer.setTo(lineBounds.contains(mouseX, mouseY), ConfigObject.getInstance().isReducedMotion() ? 0 : 400);
            graphics.method_27535(font, class_2561.method_43471("text.rei.collapsible.entries.source").method_27693(" "), bounds.x + 4, y, 0xFFAAAAAA);
            int xo = bounds.x + 4 + font.method_27525(class_2561.method_43471("text.rei.collapsible.entries.source").method_27693(" "));
            try (CloseableScissors scissors = scissor(graphics, lineBounds)) {
                graphics.method_51448().pushMatrix();
                if (this.custom) {
                    renderTextScrolling(graphics, TextTransformations.applyRainbow(class_2561.method_43471("text.rei.collapsible.entries.source.custom").method_30937(), xo - 1, y), xo - 1, y, bounds.getWidth() - 8, 0xFFAAAAAA);
                } else {
                    graphics.method_51448().translate(0, (float) (-modIdDrawer.progress() * 10));
                    renderTextScrolling(graphics, class_2561.method_43470(ClientHelper.getInstance().getModFromModId(this.id.method_12836())), xo - 1, y, bounds.getMaxX() - 4 - (xo - 1), 0xFF777777);
                    renderTextScrolling(graphics, class_2561.method_43470(this.id.method_12836().toString()), xo - 1, y + 10, bounds.getMaxX() - 4 - (xo - 1), 0xFF777777);
                }
                graphics.method_51448().popMatrix();
            }
        }
        renderStacks(graphics, mouseX, mouseY, delta, bounds, y);
        bounds.y = this.y;
        
        this.toggleButton.method_46421(bounds.getMaxX() - 4 - toggleButton.method_25368());
        this.toggleButton.method_46419(bounds.getMaxY() - 4 - toggleButton.method_25364());
        this.toggleButton.method_25394(graphics, mouseX, mouseY, delta);
        if (this.toggleButton.method_25405(mouseX, mouseY)) {
            ScreenOverlayImpl.getInstance().clearTooltips();
        }
        if (this.custom) {
            this.deleteButton.method_46421(toggleButton.method_46426() - 2 - deleteButton.method_25368());
            this.deleteButton.method_46419(bounds.getMaxY() - 4 - deleteButton.method_25364());
            this.deleteButton.method_25394(graphics, mouseX, mouseY, delta);
            if (this.deleteButton.method_25405(mouseX, mouseY)) {
                ScreenOverlayImpl.getInstance().clearTooltips();
            }
            this.configureButton.method_46421(deleteButton.method_46426() - 2 - configureButton.method_25368());
            this.configureButton.method_46419(bounds.getMaxY() - 4 - configureButton.method_25364());
            this.configureButton.method_25394(graphics, mouseX, mouseY, delta);
            if (this.configureButton.method_25405(mouseX, mouseY)) {
                ScreenOverlayImpl.getInstance().clearTooltips();
            }
        }
    }
    
    private void renderStacks(class_332 graphics, int mouseX, int mouseY, float delta, Rectangle bounds, int y) {
        try (CloseableScissors outerScissors = scissor(graphics, new Rectangle(bounds.x, y, bounds.width, bounds.getMaxY() - 3 - y))) {
            y = bounds.y + 37 - this.scroller.scrollAmountInt();
            int x = bounds.getCenterX() - 8 * rowSize;
            int xIndex = 0;
            EntryRendererManager<EntryWidget> manager = new EntryRendererManager<>();
            for (Slot stack : this.stacks) {
                if (y + 16 >= 30 && y + 16 >= bounds.y + 37) {
                    stack.getBounds().setBounds(x + 16 * xIndex - 1, y - 1, 18, 18);
                    manager.add((EntryWidget) stack);
                }
                xIndex++;
                if (xIndex >= this.rowSize) {
                    y += 16;
                    xIndex = 0;
                    if (y >= bounds.getMaxY() || y >= minecraft.field_1755.field_22790) {
                        break;
                    }
                }
            }
            try (CloseableScissors scissors = scissor(graphics, new Rectangle(x, bounds.y + 37, 16 * rowSize, bounds.getMaxY() - 4 - (bounds.y + 37)))) {
                manager.render(graphics, mouseX, mouseY, delta);
            }
            
            if (this.stacks.size() > rowSize * 3) {
                graphics.method_25296(this.x + 1, this.y + this.height - 40, this.x + this.width - 1, this.y + this.height - 1, 0x00000000, 0xFF000000);
            }
        }
    }
    
    private void renderTextScrolling(class_332 graphics, class_2561 text, int x, int y, int width, int color) {
        this.renderTextScrolling(graphics, text.method_30937(), x, y, width, color);
    }
    
    private void renderTextScrolling(class_332 graphics, class_5481 text, int x, int y, int width, int color) {
        try (CloseableScissors scissors = scissor(graphics, new Rectangle(x, y, width, y + 9))) {
            int textWidth = this.font.method_30880(text);
            if (textWidth > width) {
                graphics.method_51448().pushMatrix();
                float textX = (System.currentTimeMillis() % ((textWidth + 10) * textWidth / 3)) / (float) textWidth * 3;
                graphics.method_51448().translate(-textX, 0);
                graphics.method_35720(font, text, x + width - textWidth - 10, y, color);
                graphics.method_35720(font, text, x + width, y, color);
                graphics.method_51448().popMatrix();
            } else {
                graphics.method_35720(font, text, x, y, color);
            }
        }
    }
    
    @Override
    public boolean method_25401(double mouseX, double mouseY, double amountX, double amountY) {
        if (this.scroller.getMaxScroll() > 0 && this.scroller.getBounds().contains(mouseX, mouseY) && amountY != 0) {
            if ((amountY < 0 || this.scroller.scrollAmountInt() != 0) && (amountY > 0 || this.scroller.scrollAmountInt() != this.scroller.getMaxScroll())) {
                this.scroller.offset(ClothConfigInitializer.getScrollStep() * -amountY, true);
                return true;
            }
        }
        
        return false;
    }
    
    @Override
    public List<? extends class_364> method_25396() {
        if (this.custom) {
            return List.of(toggleButton, deleteButton, configureButton);
        } else {
            return List.of(toggleButton);
        }
    }
}
