/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.screen;

import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.shedaniel.rei.RoughlyEnoughItemsState;
import me.shedaniel.rei.impl.client.gui.InternalTextures;
import me.shedaniel.rei.impl.client.gui.widget.DynamicErrorFreeEntryListWidget;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3417;
import net.minecraft.class_3545;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_6379;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_6880;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class WarningAndErrorScreen
extends class_437 {
    private class_339 buttonExit;
    private StringEntryListWidget listWidget;
    private String action;
    private class_437 parent;
    private List<class_3545<String, String>> warnings;
    private List<class_3545<String, String>> errors;
    private Consumer<class_437> onContinue;

    public WarningAndErrorScreen(String action, List<class_3545<String, String>> warnings, List<class_3545<String, String>> errors, Consumer<class_437> onContinue) {
        super((class_2561)class_2561.method_43473());
        this.action = action;
        this.warnings = warnings;
        this.errors = errors;
        this.onContinue = onContinue;
    }

    public boolean method_25422() {
        return false;
    }

    public void setParent(class_437 parent) {
        this.parent = parent;
    }

    private void addText(class_2561 string) {
        for (class_5481 s : this.field_22793.method_1728((class_5348)string, this.field_22789 - 80)) {
            this.listWidget.creditsAddEntry(new TextItem(s));
        }
    }

    private void addLink(class_2561 string, String link) {
        for (class_5481 s : this.field_22793.method_1728((class_5348)string, this.field_22789 - 80)) {
            this.listWidget.creditsAddEntry(new LinkItem(s, link));
        }
    }

    public void method_25426() {
        int i;
        this.listWidget = new StringEntryListWidget(this.field_22787, this.field_22789, this.field_22790, 32, this.field_22790 - 32);
        this.method_25429((class_364)this.listWidget);
        this.listWidget.max = 80;
        this.listWidget.creditsClearEntries();
        this.listWidget.creditsAddEntry(new EmptyItem());
        if (!this.warnings.isEmpty()) {
            this.listWidget.creditsAddEntry(new TextItem(class_2561.method_43470((String)"Warnings:").method_27692(class_124.field_1065).method_30937()));
        }
        for (class_3545<String, String> pair : this.warnings) {
            this.addText((class_2561)class_2561.method_43470((String)((String)pair.method_15442())));
            if (pair.method_15441() != null) {
                this.addLink((class_2561)class_2561.method_43470((String)((String)pair.method_15441())), (String)pair.method_15441());
            }
            for (i = 0; i < 2; ++i) {
                this.listWidget.creditsAddEntry(new EmptyItem());
            }
        }
        if (!this.warnings.isEmpty() && !this.errors.isEmpty()) {
            this.listWidget.creditsAddEntry(new EmptyItem());
        }
        if (!this.errors.isEmpty()) {
            this.listWidget.creditsAddEntry(new TextItem(class_2561.method_43470((String)"Errors:").method_27692(class_124.field_1061).method_30937()));
        }
        for (class_3545<String, String> pair : this.errors) {
            this.addText((class_2561)class_2561.method_43470((String)((String)pair.method_15442())));
            if (pair.method_15441() != null) {
                this.addLink((class_2561)class_2561.method_43470((String)((String)pair.method_15441())), (String)pair.method_15441());
            }
            for (i = 0; i < 2; ++i) {
                this.listWidget.creditsAddEntry(new EmptyItem());
            }
        }
        for (StringItem child : this.listWidget.method_25396()) {
            this.listWidget.max = Math.max(this.listWidget.max, child.getWidth());
        }
        this.buttonExit = new class_4185(this, this.field_22789 / 2 - 100, this.field_22790 - 26, 200, 20, (class_2561)class_2561.method_43470((String)(this.errors.isEmpty() ? "Continue" : "Exit")), button -> this.onContinue.accept(this.parent), Supplier::get){};
        this.method_37063((class_364)this.buttonExit);
    }

    public boolean method_25401(double double_1, double double_2, double amountX, double amountY) {
        return this.listWidget.method_25401(double_1, double_2, amountX, amountY) || super.method_25401(double_1, double_2, amountX, amountY);
    }

    public void method_25394(class_332 graphics, int int_1, int int_2, float float_1) {
        super.method_25394(graphics, int_1, int_2, float_1);
        this.listWidget.method_25394(graphics, int_1, int_2, float_1);
        if (RoughlyEnoughItemsState.getErrors().isEmpty()) {
            graphics.method_25300(this.field_22793, "Warnings during Roughly Enough Items' " + this.action, this.field_22789 / 2, 16, 0xFFFFFF);
        } else {
            graphics.method_25300(this.field_22793, "Errors during Roughly Enough Items' " + this.action, this.field_22789 / 2, 16, 0xFFFFFF);
        }
        this.buttonExit.method_25394(graphics, int_1, int_2, float_1);
    }

    private static class StringEntryListWidget
    extends DynamicErrorFreeEntryListWidget<StringItem> {
        private boolean inFocus;
        private int max = 80;

        public StringEntryListWidget(class_310 client, int width, int height, int startY, int endY) {
            super(client, width, height, startY, endY, InternalTextures.LEGACY_DIRT);
        }

        public void creditsClearEntries() {
            this.clearItems();
        }

        private StringItem rei_getEntry(int int_1) {
            return (StringItem)this.method_25396().get(int_1);
        }

        public void creditsAddEntry(StringItem entry) {
            this.addItem(entry);
        }

        @Override
        public int getItemWidth() {
            return this.max;
        }

        @Override
        protected int getScrollbarPosition() {
            return this.width - 40;
        }
    }

    private static class TextItem
    extends StringItem {
        private class_5481 text;

        public TextItem(class_5481 text) {
            this.text = text;
        }

        @Override
        public void render(class_332 graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            graphics.method_35720(class_310.method_1551().field_1772, this.text, x + 5, y, -1);
        }

        @Override
        public int getItemHeight() {
            return 12;
        }

        @Override
        public int getWidth() {
            return class_310.method_1551().field_1772.method_30880(this.text) + 10;
        }

        @Override
        public List<? extends class_6379> narratables() {
            return ImmutableList.of((Object)new class_6379(){

                public class_6379.class_6380 method_37018() {
                    return class_6379.class_6380.field_33785;
                }

                public void method_37020(class_6382 narrationElementOutput) {
                    StringBuilder builder = new StringBuilder();
                    text.accept((i, style, j) -> {
                        builder.append(Character.toChars(j));
                        return false;
                    });
                    narrationElementOutput.method_37033(class_6381.field_33788, builder.toString());
                }
            });
        }
    }

    private static abstract class StringItem
    extends DynamicErrorFreeEntryListWidget.Entry<StringItem> {
        private StringItem() {
        }

        public abstract int getWidth();

        public void method_25365(boolean bl) {
        }

        public boolean method_25370() {
            return false;
        }
    }

    private class LinkItem
    extends StringItem {
        private class_5481 text;
        private String link;
        private boolean contains;

        public LinkItem(class_5481 text, String link) {
            this.text = text;
            this.link = link;
        }

        @Override
        public void render(class_332 graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            boolean bl = this.contains = mouseX >= x && mouseX <= x + entryWidth && mouseY >= y && mouseY <= y + entryHeight;
            if (this.contains) {
                graphics.method_51438(WarningAndErrorScreen.this.field_22793, (class_2561)class_2561.method_43470((String)"Click to open link."), mouseX, mouseY);
                graphics.method_35720(class_310.method_1551().field_1772, characterVisitor -> this.text.accept((charIndex, style, codePoint) -> characterVisitor.accept(charIndex, style.method_27706(class_124.field_1073), codePoint)), x + 5, y, -14695425);
            } else {
                graphics.method_35720(class_310.method_1551().field_1772, this.text, x + 5, y, -14695425);
            }
        }

        @Override
        public int getItemHeight() {
            return 12;
        }

        @Override
        public int getWidth() {
            return class_310.method_1551().field_1772.method_30880(this.text) + 10;
        }

        public boolean method_25402(class_11909 event, boolean doubleClick) {
            if (this.contains && event.method_74245() == 0) {
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
                try {
                    class_156.method_668().method_673(new URI(this.link));
                    return true;
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
            return false;
        }

        @Override
        public List<? extends class_6379> narratables() {
            return ImmutableList.of((Object)new class_6379(){

                public class_6379.class_6380 method_37018() {
                    return class_6379.class_6380.field_33785;
                }

                public void method_37020(class_6382 narrationElementOutput) {
                    StringBuilder builder = new StringBuilder();
                    LinkItem.this.text.accept((i, style, j) -> {
                        builder.append(Character.toChars(j));
                        return false;
                    });
                    narrationElementOutput.method_37033(class_6381.field_33788, builder.toString());
                }
            });
        }
    }

    private static class EmptyItem
    extends StringItem {
        private EmptyItem() {
        }

        @Override
        public void render(class_332 graphics, int i, int i1, int i2, int i3, int i4, int i5, int i6, boolean b, float v) {
        }

        @Override
        public int getItemHeight() {
            return 5;
        }

        @Override
        public int getWidth() {
            return 0;
        }

        @Override
        public List<? extends class_6379> narratables() {
            return Collections.emptyList();
        }
    }
}

