/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020, 2021, 2022, 2023 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.plugin.common.displays.crafting;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.Optional;

public class MapExtendingCraftingDisplay extends DefaultCraftingDisplay {
    public static final DisplaySerializer<MapExtendingCraftingDisplay> SERIALIZER = DisplaySerializer.of(
            RecordCodecBuilder.mapCodec(instance -> instance.group(
                    Codec.INT.fieldOf("i").forGetter(d -> d.i),
                    class_2960.field_25139.optionalFieldOf("location").forGetter(MapExtendingCraftingDisplay::getDisplayLocation)
            ).apply(instance, MapExtendingCraftingDisplay::new)),
            class_9139.method_56435(
                    class_9135.field_49675,
                    d -> d.i,
                    class_9135.method_56382(class_2960.field_48267),
                    MapExtendingCraftingDisplay::getDisplayLocation,
                    MapExtendingCraftingDisplay::new
            ));
    
    private final int i;
    
    public MapExtendingCraftingDisplay(int i, Optional<class_2960> id) {
        super(getInputs(i), List.of(mapWith("X", i + 1, 1)), id);
        this.i = i;
    }
    
    private static List<EntryIngredient> getInputs(int i) {
        EntryIngredient[] inputs = new EntryIngredient[9];
        for (int j = 0; j < 9; j++) {
            if (j == 4) {
                inputs[j] = mapWith("X", i, 1);
            } else {
                inputs[j] = EntryIngredients.of(class_1802.field_8407);
            }
        }
        return List.of(inputs);
    }
    
    @Override
    @Nullable
    public DisplaySerializer<? extends Display> getSerializer() {
        return SERIALIZER;
    }
    
    public static EntryIngredient mapWith(String mapId, int scale, int count) {
        if (Platform.getEnvironment() == Env.CLIENT) {
            return mapWithClient(mapId, scale, count);
        } else {
            return EntryIngredients.of(class_1802.field_8204, count);
        }
    }
    
    @Environment(EnvType.CLIENT)
    public static EntryIngredient mapWithClient(String mapId, int scale, int count) {
        EntryIngredient stacks = EntryIngredients.of(class_1802.field_8204, count);
        String unknown = class_1074.method_4662("filled_map.unknown");
        for (EntryStack<?> stack : stacks) {
            stack.tooltipProcessor(($, tooltip) -> {
                tooltip.entries().removeIf(entry -> entry.isText() && entry.getAsText().getString().equals(unknown));
                return tooltip;
            });
            stack.tooltip(
                    class_2561.method_43469("filled_map.id", mapId).method_27692(class_124.field_1080),
                    class_2561.method_43469("filled_map.scale", (1 << scale)).method_27692(class_124.field_1080),
                    class_2561.method_43469("filled_map.level", scale, 4).method_27692(class_124.field_1080)
            );
        }
        return stacks;
    }
    
    @Override
    public boolean isShapeless() {
        return false;
    }
    
    @Override
    public int getWidth() {
        return 3;
    }
    
    @Override
    public int getHeight() {
        return 3;
    }
}
