/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020, 2021, 2022, 2023 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.plugin.common.displays.anvil;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10630;
import net.minecraft.class_156;
import net.minecraft.class_1661;
import net.minecraft.class_1706;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.ApiStatus;

import java.util.*;

public class DefaultAnvilDisplay extends BasicDisplay {
    public static final DisplaySerializer<DefaultAnvilDisplay> SERIALIZER = DisplaySerializer.of(
            RecordCodecBuilder.mapCodec(instance -> instance.group(
                    EntryIngredient.codec().listOf().fieldOf("inputs").forGetter(DefaultAnvilDisplay::getInputEntries),
                    EntryIngredient.codec().listOf().fieldOf("outputs").forGetter(DefaultAnvilDisplay::getOutputEntries),
                    class_2960.field_25139.optionalFieldOf("location").forGetter(DefaultAnvilDisplay::getDisplayLocation),
                    Codec.INT.optionalFieldOf("cost").forGetter(d -> d.cost.stream().boxed().findFirst())
            ).apply(instance, (inputs, outputs, location, cost) -> new DefaultAnvilDisplay(inputs, outputs, location, cost.stream().mapToInt(i -> i).findFirst()))),
            class_9139.method_56905(
                    EntryIngredient.streamCodec().method_56433(class_9135.method_56363()),
                    DefaultAnvilDisplay::getInputEntries,
                    EntryIngredient.streamCodec().method_56433(class_9135.method_56363()),
                    DefaultAnvilDisplay::getOutputEntries,
                    class_9135.method_56382(class_2960.field_48267),
                    DefaultAnvilDisplay::getDisplayLocation,
                    class_9135.method_56382(class_9135.field_49675),
                    d -> d.cost.stream().boxed().findFirst(),
                    (inputs, outputs, location, cost) -> new DefaultAnvilDisplay(inputs, outputs, location, cost.stream().mapToInt(i -> i).findFirst())
            ));
    
    private final OptionalInt cost;
    
    public DefaultAnvilDisplay(AnvilRecipe recipe) {
        this(
                Arrays.asList(
                        EntryIngredients.ofItemStacks(recipe.getLeftInput()),
                        EntryIngredients.ofItemStacks(recipe.getRightInputs())
                ),
                Collections.singletonList(EntryIngredients.ofItemStacks(recipe.getOutputs())),
                Optional.ofNullable(recipe.getId()),
                recipe.getCost()
        );
    }
    
    public DefaultAnvilDisplay(List<EntryIngredient> inputs, List<EntryIngredient> outputs, Optional<class_2960> location) {
        this(inputs, outputs, location, OptionalInt.empty());
    }
    
    public DefaultAnvilDisplay(List<EntryIngredient> inputs, List<EntryIngredient> outputs, Optional<class_2960> location, class_2487 tag) {
        this(inputs, outputs, location, tag.method_10545("Cost") ? class_156.method_656(() -> tag.method_10550("Cost").isPresent() ? OptionalInt.of(tag.method_10550("Cost").get()) : OptionalInt.empty()) : OptionalInt.empty());
    }
    
    public DefaultAnvilDisplay(List<EntryIngredient> inputs, List<EntryIngredient> outputs, Optional<class_2960> location, OptionalInt cost) {
        super(inputs, outputs, location);
        this.cost = cost;
    }
    
    @Override
    public CategoryIdentifier<?> getCategoryIdentifier() {
        return BuiltinPlugin.ANVIL;
    }
    
    @Override
    public DisplaySerializer<? extends Display> getSerializer() {
        return SERIALIZER;
    }
    
    public OptionalInt getCost() {
        return cost;
    }
    
    @ApiStatus.Experimental
    @ApiStatus.Internal
    @Environment(EnvType.CLIENT)
    public static Optional<Pair<class_1799, Integer>> calculateOutput(class_1799 left, class_1799 right) {
        try {
            if (class_310.method_1551().field_1724 == null) return Optional.empty();
            class_1706 menu = new class_1706(0, new class_1661(class_310.method_1551().field_1724, new class_10630()));
            menu.method_7619(0, menu.method_37422(), left);
            menu.method_7619(1, menu.method_37422(), right);
            class_1799 output = menu.method_7611(2).method_7677().method_7972();
            if (!output.method_7960()) {
                return Optional.of(Pair.of(output, menu.method_17369()));
            } else {
                return Optional.empty();
            }
        } catch (Throwable ignored) {
            return Optional.empty();
        }
    }
}
