/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020, 2021, 2022, 2023 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.plugin.client.categories.crafting.filler;

import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.plugin.common.displays.crafting.DefaultCustomShapelessDisplay;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1799;
import net.minecraft.class_1849;
import net.minecraft.class_3489;
import net.minecraft.class_7923;
import net.minecraft.class_8786;
import net.minecraft.class_9282;
import java.util.*;

public class ArmorDyeRecipeFiller implements CraftingRecipeFiller<class_1849> {
    @Override
    public Collection<Display> apply(class_8786<class_1849> recipe) {
        List<Display> displays = new ArrayList<>();
        List<EntryStack<?>> toDye = class_7923.field_41178.method_10220()
                .filter(item -> item.method_40131().method_40220(class_3489.field_48803))
                .map(EntryStacks::of)
                .<EntryStack<?>>map(EntryStack::cast)
                .toList();
        class_1767[] colors = class_1767.values();
        
        for (EntryStack<?> armor : toDye) {
            class_1799 armorStack = armor.castValue();
            for (class_1767 color : colors) {
                class_1799 output = armorStack.method_7972();
                class_1769 dyeItem = class_1769.method_7803(color);
                output = class_9282.method_57471(output, List.of(dyeItem));
                displays.add(new DefaultCustomShapelessDisplay(
                        List.of(EntryIngredient.of(armor.copy()),
                                EntryIngredients.of(dyeItem)),
                        List.of(EntryIngredients.of(output)),
                        Optional.of(recipe.comp_1932().method_29177())));
            }
            
            for (int i = 0; i < 9; i++) {
                int dyes = new Random().nextInt(2) + 2;
                List<EntryIngredient> inputs = new ArrayList<>();
                List<class_1769> dyeItems = new ArrayList<>();
                inputs.add(EntryIngredient.of(armor.copy()));
                for (int j = 0; j < dyes; j++) {
                    class_1767 color = colors[new Random().nextInt(colors.length)];
                    class_1769 dyeItem = class_1769.method_7803(color);
                    dyeItems.add(dyeItem);
                    inputs.add(EntryIngredients.of(dyeItem));
                }
                class_1799 output = armorStack.method_7972();
                output = class_9282.method_57471(output, dyeItems);
                displays.add(new DefaultCustomShapelessDisplay(
                        inputs, List.of(EntryIngredients.of(output)),
                        Optional.of(recipe.comp_1932().method_29177())));
            }
        }
        
        return displays;
    }
    
    @Override
    public Class<class_1849> getRecipeClass() {
        return class_1849.class;
    }
}
