/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020, 2021, 2022, 2023 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.mixin.fabric;

import com.google.common.base.Stopwatch;
import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMaps;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.common.InternalLogger;
import me.shedaniel.rei.plugin.common.displays.tag.TagNodes;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3497;
import net.minecraft.class_3503;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.*;

@Mixin(class_3503.class)
public class MixinTagLoader<T> {
    @Shadow
    @Final
    private String directory;
    
    @Inject(method = "loadPendingTags", at = @At("HEAD"))
    private static <T> void loadPendingTags(class_3300 resourceManager, class_2378<T> registry, CallbackInfoReturnable<Optional<class_2378.class_10106<T>>> cir) {
        class_5321<? extends class_2378<T>> resourceKey = registry.method_46765();
        TagNodes.TAG_DIR_MAP.put(class_7924.method_60916(resourceKey), resourceKey);
    }
    
    @Inject(method = "build(Ljava/util/Map;)Ljava/util/Map;", at = @At("HEAD"))
    private void load(Map<class_2960, class_3503.class_5145> map, CallbackInfoReturnable<Map<class_2960, Collection<T>>> cir) {
        TagNodes.RAW_TAG_DATA_MAP.put(directory, new HashMap<>());
        TagNodes.CURRENT_TAG_DIR.set(directory);
    }
    
    @Inject(method = "build(Ljava/util/Map;)Ljava/util/Map;", at = @At("RETURN"))
    private void loadPost(Map<class_2960, class_3503.class_5145> map, CallbackInfoReturnable<Map<class_2960, Collection<T>>> cir) {
        Map<TagNodes.CollectionWrapper<T>, class_2960> inverseMap = new HashMap<>(cir.getReturnValue().size());
        for (Map.Entry<class_2960, Collection<T>> entry : cir.getReturnValue().entrySet()) {
            inverseMap.put(new TagNodes.CollectionWrapper<>(entry.getValue()), entry.getKey());
        }
        class_5321<? extends class_2378<?>> resourceKey = TagNodes.TAG_DIR_MAP.get(directory);
        if (resourceKey == null) return;
        TagNodes.TAG_DATA_MAP.put(resourceKey, new HashMap<>());
        Map<class_2960, TagNodes.TagData> tagDataMap = TagNodes.TAG_DATA_MAP.get(resourceKey);
        if (tagDataMap == null) return;
        class_2378<T> registry = ((class_2378<class_2378<T>>) class_7923.field_41167).method_29107((class_5321<class_2378<T>>) resourceKey);
        Stopwatch stopwatch = Stopwatch.createStarted();
        
        Iterator<Map.Entry<TagNodes.CollectionWrapper<?>, TagNodes.RawTagData>> entryIterator = TagNodes.RAW_TAG_DATA_MAP.getOrDefault(directory, Reference2ObjectMaps.emptyMap())
                .entrySet().iterator();
        
        if (!entryIterator.hasNext()) return;
        
        while (entryIterator.hasNext()) {
            Map.Entry<TagNodes.CollectionWrapper<?>, TagNodes.RawTagData> entry = entryIterator.next();
            TagNodes.CollectionWrapper<?> tag = entry.getKey();
            entryIterator.remove();
            
            if (registry != null) {
                class_2960 tagLoc = inverseMap.get(tag);
                
                if (tagLoc != null) {
                    TagNodes.RawTagData rawTagData = entry.getValue();
                    IntList elements = new IntArrayList();
                    for (class_2960 element : rawTagData.otherElements()) {
                        T t = registry.method_63535(element);
                        if (t != null) {
                            elements.add(registry.method_10206(t));
                        }
                    }
                    tagDataMap.put(tagLoc, new TagNodes.TagData(elements, rawTagData.otherTags()));
                }
            }
        }
        
        InternalLogger.getInstance().debug("Processed %d tags in %s for %s", tagDataMap.size(), stopwatch.stop(), resourceKey.method_29177());
    }
    
    @Inject(method = "tryBuildTag", at = @At("RETURN"))
    private void load(class_3497.class_7474<T> lookup, List<class_3503.class_5145> entries, CallbackInfoReturnable<Either<Collection<class_3503.class_5145>, Collection<T>>> cir) {
        Collection<T> tag = cir.getReturnValue().right().orElse(null);
        if (tag != null) {
            String currentTagDirectory = TagNodes.CURRENT_TAG_DIR.get();
            if (currentTagDirectory == null) return;
            class_5321<? extends class_2378<?>> resourceKey = TagNodes.TAG_DIR_MAP.get(currentTagDirectory);
            if (resourceKey == null) return;
            Map<TagNodes.CollectionWrapper<?>, TagNodes.RawTagData> dataMap = TagNodes.RAW_TAG_DATA_MAP.get(currentTagDirectory);
            if (dataMap == null) return;
            List<class_2960> otherElements = new ArrayList<>();
            List<class_2960> otherTags = new ArrayList<>();
            
            for (class_3503.class_5145 builderEntry : entries) {
                class_3497 entry = builderEntry.comp_324();
                if (entry.field_39267) {
                    Collection<T> apply = lookup.method_43949(entry.field_15584);
                    if (apply != null) {
                        otherTags.add(entry.field_15584);
                    }
                } else {
                    T apply = lookup.method_43948(entry.field_15584, entry.field_39268);
                    if (apply != null) {
                        otherElements.add(entry.field_15584);
                    }
                }
            }
            
            dataMap.put(new TagNodes.CollectionWrapper<>(tag), new TagNodes.RawTagData(CollectionUtils.distinctToList(otherElements), CollectionUtils.distinctToList(otherTags)));
        }
    }
}
