/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020, 2021, 2022, 2023 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.impl.client.transfer;

import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.SimpleDisplayRenderer;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.impl.client.gui.widget.entrylist.EntryListWidget;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import java.util.List;

public class MissingStacksTooltip implements class_5684, class_5632 {
    private static final int MAX_WIDTH = 200;
    private final List<EntryIngredient> stacks;
    
    public MissingStacksTooltip(List<EntryIngredient> stacks) {
        this.stacks = SimpleDisplayRenderer.simplify(stacks);
    }
    
    @Override
    public int method_32661(class_327 font) {
        int entrySize = EntryListWidget.entrySize();
        int w = Math.max(1, MAX_WIDTH / entrySize);
        int height = Math.min(6, class_3532.method_15386(stacks.size() / (float) w)) * entrySize + 2;
        height += 12;
        return height;
    }
    
    @Override
    public int method_32664(class_327 font) {
        int entrySize = EntryListWidget.entrySize();
        int w = Math.max(1, MAX_WIDTH / entrySize);
        int size = stacks.size();
        int width = Math.min(size, w) * entrySize;
        width = Math.max(width, font.method_27525(class_2561.method_43471("text.rei.missing")));
        return width;
    }
    
    @Override
    public void method_32666(class_327 font, int x, int y, int width, int height, class_332 graphics) {
        int entrySize = EntryListWidget.entrySize();
        int w = Math.max(1, MAX_WIDTH / entrySize);
        int i = 0;
        for (EntryIngredient entry : stacks) {
            int x1 = x + (i % w) * entrySize;
            int y1 = y + 13 + (i / w) * entrySize;
            i++;
            if (i / w > 5) {
                class_2561 text = class_2561.method_43470("+" + (stacks.size() - w * 6 + 1)).method_27692(class_124.field_1080);
                graphics.method_27535(font, text, x1 + entrySize / 2 - font.method_27525(text) / 2, y1 + entrySize / 2 - 1, -1);
                break;
            } else {
                EntryStack<?> stack;
                if (entry.isEmpty()) stack = EntryStack.empty();
                else if (entry.size() == 1) stack = entry.get(0);
                else stack = entry.get(class_3532.method_15357((System.currentTimeMillis() / 1000 % (double) entry.size())));
                stack.render(graphics, new Rectangle(x1, y1, entrySize, entrySize), -1000, -1000, 0);
            }
        }
    }
    
    @Override
    public void method_32665(class_332 graphics, class_327 font, int x, int y) {
        graphics.method_27535(font, class_2561.method_43471("text.rei.missing").method_27692(class_124.field_1080), x, y + 2, -1);
    }
}
