/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020, 2021, 2022, 2023 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.impl.client.gui.widget;

import com.google.common.collect.Lists;
import me.shedaniel.rei.api.client.gui.AbstractContainerEventHandler;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_289;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_6379;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Environment(EnvType.CLIENT)
public abstract class DynamicErrorFreeEntryListWidget<E extends DynamicErrorFreeEntryListWidget.Entry<E>> extends AbstractContainerEventHandler implements class_4068, class_6379 {
    protected static final int DRAG_OUTSIDE = -2;
    protected final class_310 client;
    private final List<E> entries = new Entries();
    public int width;
    public int height;
    public int top;
    public int bottom;
    public int right;
    public int left;
    protected boolean verticallyCenter = true;
    protected int yDrag = -2;
    protected boolean selectionVisible = true;
    protected boolean renderSelection;
    protected int headerHeight;
    protected double scroll;
    protected boolean scrolling;
    @Nullable
    protected E hoveredItem;
    protected E selectedItem;
    protected class_2960 backgroundLocation;
    
    public DynamicErrorFreeEntryListWidget(class_310 client, int width, int height, int top, int bottom, class_2960 backgroundLocation) {
        this.client = client;
        this.width = width;
        this.height = height;
        this.top = top;
        this.bottom = bottom;
        this.left = 0;
        this.right = width;
        this.backgroundLocation = backgroundLocation;
    }
    
    public void setRenderSelection(boolean boolean_1) {
        this.selectionVisible = boolean_1;
    }
    
    protected void setRenderHeader(boolean boolean_1, int headerHeight) {
        this.renderSelection = boolean_1;
        this.headerHeight = headerHeight;
        if (!boolean_1)
            this.headerHeight = 0;
    }
    
    public class_6380 method_37018() {
        if (this.method_25370()) {
            return class_6380.field_33786;
        } else {
            return this.hoveredItem != null ? class_6380.field_33785 : class_6380.field_33784;
        }
    }
    
    public void method_37020(class_6382 narrationElementOutput) {
        E entry = this.hoveredItem;
        if (entry != null) {
            entry.updateNarration(narrationElementOutput.method_37031());
            this.narrateListElementPosition(narrationElementOutput, entry);
        } else {
            E entry2 = this.method_25399();
            if (entry2 != null) {
                entry2.updateNarration(narrationElementOutput.method_37031());
                this.narrateListElementPosition(narrationElementOutput, entry2);
            }
        }
        
        narrationElementOutput.method_37034(class_6381.field_33791, class_2561.method_43471("narration.component_list.usage"));
    }
    
    protected void narrateListElementPosition(class_6382 narrationElementOutput, E entry) {
        List<E> list = this.method_25396();
        if (list.size() > 1) {
            int i = list.indexOf(entry);
            if (i != -1) {
                narrationElementOutput.method_37034(class_6381.field_33789, class_2561.method_43469("narrator.position.list", i + 1, list.size()));
            }
        }
        
    }
    
    public int getItemWidth() {
        return 220;
    }
    
    public E getSelectedItem() {
        return this.selectedItem;
    }
    
    public void selectItem(E item) {
        this.selectedItem = item;
    }
    
    public E method_25399() {
        return (E) super.method_25399();
    }
    
    public final List<E> method_25396() {
        return this.entries;
    }
    
    protected final void clearItems() {
        this.entries.clear();
    }
    
    protected E getItem(int index) {
        return this.method_25396().get(index);
    }
    
    protected int addItem(E item) {
        this.entries.add(item);
        return this.entries.size() - 1;
    }
    
    protected int getItemCount() {
        return this.method_25396().size();
    }
    
    protected boolean isSelected(int index) {
        return Objects.equals(this.getSelectedItem(), this.method_25396().get(index));
    }
    
    protected final E getItemAtPosition(double mouseX, double mouseY) {
        int listMiddleX = this.left + this.width / 2;
        int minX = listMiddleX - this.getItemWidth() / 2;
        int maxX = listMiddleX + this.getItemWidth() / 2;
        int currentY = class_3532.method_15357(mouseY - (double) this.top) - this.headerHeight + (int) this.getScroll() - 4;
        int itemY = 0;
        int itemIndex = -1;
        for (int i = 0; i < entries.size(); i++) {
            E item = getItem(i);
            itemY += item.getItemHeight();
            if (itemY > currentY) {
                itemIndex = i;
                break;
            }
        }
        return mouseX < (double) this.getScrollbarPosition() && mouseX >= minX && mouseX <= maxX && itemIndex >= 0 && currentY >= 0 && itemIndex < this.getItemCount() ? this.method_25396().get(itemIndex) : null;
    }
    
    public void updateSize(int width, int height, int top, int bottom) {
        this.width = width;
        this.height = height;
        this.top = top;
        this.bottom = bottom;
        this.left = 0;
        this.right = width;
    }
    
    public void setLeftPos(int left) {
        this.left = left;
        this.right = left + this.width;
    }
    
    protected int getMaxScrollPosition() {
        List<Integer> list = new ArrayList<>();
        int i = headerHeight;
        for (E entry : entries) {
            i += entry.getItemHeight();
            if (entry.getMorePossibleHeight() >= 0) {
                list.add(i + entry.getMorePossibleHeight());
            }
        }
        list.add(i);
        return list.stream().max(Integer::compare).orElse(0);
    }
    
    protected void clickedHeader(int int_1, int int_2) {
    }
    
    public static void renderBackBackground(class_332 graphics, class_2960 backgroundLocation,
                                            int left, int top, int right, int bottom, int yOffset, int color) {
        /*graphics.drawSpecial(source -> {
            VertexConsumer buffer = source.getBuffer(RenderType.guiTextured(backgroundLocation));
            Matrix4f matrix = graphics.pose().last().pose();
            buffer.addVertex(matrix, left, bottom, 0.0F).setUv(left / 32.0F, ((bottom + yOffset) / 32.0F)).setColor(color, color, color, 255);
            buffer.addVertex(matrix, right, bottom, 0.0F).setUv(right / 32.0F, ((bottom + yOffset) / 32.0F)).setColor(color, color, color, 255);
            buffer.addVertex(matrix, right, top, 0.0F).setUv(right / 32.0F, ((top + yOffset) / 32.0F)).setColor(color, color, color, 255);
            buffer.addVertex(matrix, left, top, 0.0F).setUv(left / 32.0F, ((top + yOffset) / 32.0F)).setColor(color, color, color, 255);
        });*/
    }
    
    protected void drawBackground() {
    }
    
    protected void renderDecorations(class_332 graphics, int mouseX, int mouseY) {
    }
    
    protected void renderHeader(class_332 graphics, int rowLeft, int startY) {
    }
    
    @Deprecated
    protected void renderBackBackground(class_332 graphics) {
        DynamicErrorFreeEntryListWidget.renderBackBackground(graphics, backgroundLocation,
                left, top, right, bottom, (int) getScroll(), 32);
    }
    
    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        this.drawBackground();
        int scrollbarPosition = this.getScrollbarPosition();
        int int_4 = scrollbarPosition + 6;
        renderBackBackground(graphics);
        int rowLeft = this.getRowLeft();
        int startY = this.top + 4 - (int) this.getScroll();
        if (this.renderSelection)
            this.renderHeader(graphics, rowLeft, startY);
        this.renderList(graphics, rowLeft, startY, mouseX, mouseY, delta);
        this.renderHoleBackground(graphics, 0, this.top, 255, 255);
        this.renderHoleBackground(graphics, this.bottom, this.height, 255, 255);
        graphics.method_25290(class_10799.field_56883, class_437.field_49895, this.left, this.top - 2, 0.0F, 0.0F, this.width, 2, 32, 2);
        graphics.method_25290(class_10799.field_56883, class_437.field_49896, this.left, this.bottom, 0.0F, 0.0F, this.width, 2, 32, 2);
        int maxScroll = this.getMaxScroll();
        this.renderScrollBar(graphics, maxScroll, scrollbarPosition, int_4);
        this.renderDecorations(graphics, mouseX, mouseY);
    }
    
    protected void renderScrollBar(class_332 graphics, int maxScroll, int scrollbarPositionMinX, int scrollbarPositionMaxX) {
        if (maxScroll > 0) {
            int height = ((this.bottom - this.top) * (this.bottom - this.top)) / this.getMaxScrollPosition();
            height = class_3532.method_15340(height, 32, this.bottom - this.top - 8);
            int y = (int) this.getScroll() * (this.bottom - this.top - height) / maxScroll + this.top;
            if (y < this.top) {
                y = this.top;
            }
            
            int finalY = y;
            int finalHeight = height;
            /*graphics.drawSpecial(source -> {
                VertexConsumer buffer = source.getBuffer(RenderType.gui());
                Matrix4f matrix = graphics.pose().last().pose();
                buffer.addVertex(matrix, scrollbarPositionMinX, this.bottom, 0.0F).setColor(0, 0, 0, 255);
                buffer.addVertex(matrix, scrollbarPositionMaxX, this.bottom, 0.0F).setColor(0, 0, 0, 255);
                buffer.addVertex(matrix, scrollbarPositionMaxX, this.top, 0.0F).setColor(0, 0, 0, 255);
                buffer.addVertex(matrix, scrollbarPositionMinX, this.top, 0.0F).setColor(0, 0, 0, 255);
                buffer.addVertex(matrix, scrollbarPositionMinX, finalY + finalHeight, 0.0F).setColor(128, 128, 128, 255);
                buffer.addVertex(matrix, scrollbarPositionMaxX, finalY + finalHeight, 0.0F).setColor(128, 128, 128, 255);
                buffer.addVertex(matrix, scrollbarPositionMaxX, finalY, 0.0F).setColor(128, 128, 128, 255);
                buffer.addVertex(matrix, scrollbarPositionMinX, finalY, 0.0F).setColor(128, 128, 128, 255);
                buffer.addVertex(scrollbarPositionMinX, (finalY + finalHeight - 1), 0.0F).setColor(192, 192, 192, 255);
                buffer.addVertex((scrollbarPositionMaxX - 1), (finalY + finalHeight - 1), 0.0F).setColor(192, 192, 192, 255);
                buffer.addVertex((scrollbarPositionMaxX - 1), finalY, 0.0F).setColor(192, 192, 192, 255);
                buffer.addVertex(scrollbarPositionMinX, finalY, 0.0F).setColor(192, 192, 192, 255);
            });*/
        }
    }
    
    protected void centerScrollOn(E item) {
        double d = (this.bottom - this.top) / -2d;
        for (int i = 0; i < this.method_25396().indexOf(item) && i < this.getItemCount(); i++)
            d += getItem(i).getItemHeight();
        this.capYPosition(d);
    }
    
    protected void ensureVisible(E item) {
        int rowTop = this.getRowTop(this.method_25396().indexOf(item));
        int int_2 = rowTop - this.top - 4 - item.getItemHeight();
        if (int_2 < 0)
            this.scroll(int_2);
        int int_3 = this.bottom - rowTop - item.getItemHeight() * 2;
        if (int_3 < 0)
            this.scroll(-int_3);
    }
    
    protected void scroll(int int_1) {
        this.capYPosition(this.getScroll() + (double) int_1);
        this.yDrag = -2;
    }
    
    public double getScroll() {
        return this.scroll;
    }
    
    public void capYPosition(double double_1) {
        this.scroll = class_3532.method_15350(double_1, 0.0F, this.getMaxScroll());
    }
    
    protected int getMaxScroll() {
        return Math.max(0, this.getMaxScrollPosition() - (this.bottom - this.top - 4));
    }
    
    public int getScrollBottom() {
        return (int) this.getScroll() - this.height - this.headerHeight;
    }
    
    protected void updateScrollingState(double double_1, double double_2, int int_1) {
        this.scrolling = int_1 == 0 && double_1 >= (double) this.getScrollbarPosition() && double_1 < (double) (this.getScrollbarPosition() + 6);
    }
    
    protected int getScrollbarPosition() {
        return this.width / 2 + 124;
    }
    
    @Override
    public boolean method_25402(class_11909 event, boolean doubleClick) {
        this.updateScrollingState(event.comp_4798(), event.comp_4799(), event.method_74245());
        if (!this.method_25405(event.comp_4798(), event.comp_4799())) {
            return false;
        } else {
            E item = this.getItemAtPosition(event.comp_4798(), event.comp_4799());
            if (item != null) {
                if (item.method_25402(event, doubleClick)) {
                    this.method_25395(item);
                    this.method_25398(true);
                    return true;
                }
            } else if (event.method_74245() == 0) {
                this.clickedHeader((int) (event.comp_4798() - (double) (this.left + this.width / 2 - this.getItemWidth() / 2)), (int) (event.comp_4799() - (double) this.top) + (int) this.getScroll() - 4);
                return true;
            }
            
            return this.scrolling;
        }
    }
    
    @Override
    public boolean method_25406(class_11909 event) {
        if (this.method_25399() != null) {
            this.method_25399().method_25406(event);
        }
        
        return false;
    }
    
    @Override
    public boolean method_25403(class_11909 event, double deltaX, double deltaY) {
        if (super.method_25403(event, deltaX, deltaY)) {
            return true;
        } else if (event.method_74245() == 0 && this.scrolling) {
            if (event.comp_4799() < (double) this.top) {
                this.capYPosition(0.0F);
            } else if (event.comp_4799() > (double) this.bottom) {
                this.capYPosition(this.getMaxScroll());
            } else {
                double double_5 = Math.max(1, this.getMaxScroll());
                int int_2 = this.bottom - this.top;
                int int_3 = class_3532.method_15340((int) ((float) (int_2 * int_2) / (float) this.getMaxScrollPosition()), 32, int_2 - 8);
                double double_6 = Math.max(1.0D, double_5 / (double) (int_2 - int_3));
                this.capYPosition(this.getScroll() + deltaY * double_6);
            }
            
            return true;
        } else {
            return false;
        }
    }
    
    @Override
    public boolean method_25401(double double_1, double double_2, double amountX, double amountY) {
        for (E entry : entries) {
            if (entry.method_25401(double_1, double_2, amountX, amountY)) {
                return true;
            }
        }
        if (amountY == 0) return false;
        this.capYPosition(this.getScroll() - amountY * (double) (getMaxScroll() / getItemCount()) / 2.0D);
        return true;
    }
    
    @Override
    public boolean method_25404(class_11908 event) {
        if (super.method_25404(event)) {
            return true;
        } else if (event.comp_4795() == 264) {
            this.moveSelection(1);
            return true;
        } else if (event.comp_4795() == 265) {
            this.moveSelection(-1);
            return true;
        } else {
            return false;
        }
    }
    
    protected void moveSelection(int int_1) {
        if (!this.method_25396().isEmpty()) {
            int int_2 = this.method_25396().indexOf(this.getSelectedItem());
            int int_3 = class_3532.method_15340(int_2 + int_1, 0, this.getItemCount() - 1);
            E itemListWidget$Item_1 = this.method_25396().get(int_3);
            this.selectItem(itemListWidget$Item_1);
            this.ensureVisible(itemListWidget$Item_1);
        }
        
    }
    
    @Override
    public boolean method_25405(double double_1, double double_2) {
        return double_2 >= (double) this.top && double_2 <= (double) this.bottom && double_1 >= (double) this.left && double_1 <= (double) this.right;
    }
    
    protected void renderList(class_332 graphics, int startX, int startY, int int_3, int int_4, float float_1) {
        this.hoveredItem = this.method_25405(int_3, int_4) ? this.getItemAtPosition(int_3, int_4) : null;
        int itemCount = this.getItemCount();
        class_289 tessellator = class_289.method_1348();
        
        for (int renderIndex = 0; renderIndex < itemCount; ++renderIndex) {
            E item = this.getItem(renderIndex);
            int itemY = startY + headerHeight;
            for (int i = 0; i < entries.size() && i < renderIndex; i++)
                itemY += entries.get(i).getItemHeight();
            int itemHeight = item.getItemHeight() - 4;
            int itemWidth = this.getItemWidth();
            int itemMinX, itemMaxX;
            if (this.selectionVisible && this.isSelected(renderIndex)) {
                itemMinX = this.left + this.width / 2 - itemWidth / 2;
                itemMaxX = itemMinX + itemWidth;
                float float_2 = this.method_25370() ? 1.0F : 0.5F;
                /*Matrix4f matrix = graphics.pose().last().pose();
                
                int finalItemY = itemY;
                graphics.drawSpecial(source -> {
                    VertexConsumer buffer = source.getBuffer(RenderType.gui());
                    buffer.addVertex(matrix, itemMinX, finalItemY + itemHeight + 2, 0.0F).setColor(float_2, float_2, float_2, 1.0F);
                    buffer.addVertex(matrix, itemMaxX, finalItemY + itemHeight + 2, 0.0F).setColor(float_2, float_2, float_2, 1.0F);
                    buffer.addVertex(matrix, itemMaxX, finalItemY - 2, 0.0F).setColor(float_2, float_2, float_2, 1.0F);
                    buffer.addVertex(matrix, itemMinX, finalItemY - 2, 0.0F).setColor(float_2, float_2, float_2, 1.0F);
                    buffer.addVertex(matrix, itemMinX + 1, finalItemY + itemHeight + 1, 0.0F).setColor(0.0F, 0.0F, 0.0F, 1.0F);
                    buffer.addVertex(matrix, itemMaxX - 1, finalItemY + itemHeight + 1, 0.0F).setColor(0.0F, 0.0F, 0.0F, 1.0F);
                    buffer.addVertex(matrix, itemMaxX - 1, finalItemY - 1, 0.0F).setColor(0.0F, 0.0F, 0.0F, 1.0F);
                    buffer.addVertex(matrix, itemMinX + 1, finalItemY - 1, 0.0F).setColor(0.0F, 0.0F, 0.0F, 1.0F);
                });*/
            }
            
            int y = this.getRowTop(renderIndex);
            int x = this.getRowLeft();
            renderItem(graphics, item, renderIndex, y, x, itemWidth, itemHeight, int_3, int_4, Objects.equals(hoveredItem, item), float_1);
        }
        
    }
    
    protected void renderItem(class_332 graphics, E item, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
        item.render(graphics, index, y, x, entryWidth, entryHeight, mouseX, mouseY, isSelected, delta);
    }
    
    protected int getRowLeft() {
        return this.left + this.width / 2 - this.getItemWidth() / 2 + 2;
    }
    
    protected int getRowTop(int index) {
        int integer = top + 4 - (int) this.getScroll() + headerHeight;
        for (int i = 0; i < entries.size() && i < index; i++)
            integer += entries.get(i).getItemHeight();
        return integer;
    }
    
    public boolean method_25370() {
        return false;
    }
    
    protected void renderHoleBackground(class_332 graphics, int y1, int y2, int alpha1, int alpha2) {
        /*Matrix4f matrix = graphics.pose().last().pose();
        RenderSystem.setShaderColor(1.0F, 1.0F, 1.0F, 1.0F);
        graphics.drawSpecial(source -> {
            VertexConsumer buffer = source.getBuffer(RenderType.guiTextured(backgroundLocation));
            buffer.addVertex(matrix, this.left, y2, 0.0F).setUv(0, ((float) y2 / 32.0F)).setColor(64, 64, 64, alpha2);
            buffer.addVertex(matrix, this.left + this.width, y2, 0.0F).setUv(((float) this.width / 32.0F), ((float) y2 / 32.0F)).setColor(64, 64, 64, alpha2);
            buffer.addVertex(matrix, this.left + this.width, y1, 0.0F).setUv(((float) this.width / 32.0F), ((float) y1 / 32.0F)).setColor(64, 64, 64, alpha1);
            buffer.addVertex(matrix, this.left, y1, 0.0F).setUv(0, ((float) y1 / 32.0F)).setColor(64, 64, 64, alpha1);
        });*/
    }
    
    protected E remove(int int_1) {
        E itemListWidget$Item_1 = this.entries.get(int_1);
        return this.removeEntry(this.entries.get(int_1)) ? itemListWidget$Item_1 : null;
    }
    
    protected boolean removeEntry(E itemListWidget$Item_1) {
        boolean boolean_1 = this.entries.remove(itemListWidget$Item_1);
        if (boolean_1 && itemListWidget$Item_1 == this.getSelectedItem()) {
            this.selectItem(null);
        }
        
        return boolean_1;
    }
    
    public static final class SmoothScrollingSettings {
        public static final double CLAMP_EXTENSION = 200;
        
        private SmoothScrollingSettings() {
        }
    }
    
    @Environment(EnvType.CLIENT)
    public abstract static class Entry<E extends Entry<E>> implements class_364 {
        @Deprecated
        DynamicErrorFreeEntryListWidget<E> parent;
        @Nullable
        private class_6379 lastNarratable;
        
        public Entry() {
        }
        
        public abstract void render(class_332 graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta);
        
        public boolean method_25405(double double_1, double double_2) {
            return Objects.equals(this.parent.getItemAtPosition(double_1, double_2), this);
        }
        
        public DynamicErrorFreeEntryListWidget<E> getParent() {
            return parent;
        }
        
        public void setParent(DynamicErrorFreeEntryListWidget<E> parent) {
            this.parent = parent;
        }
        
        public abstract int getItemHeight();
        
        @Deprecated
        public int getMorePossibleHeight() {
            return -1;
        }
        
        public abstract List<? extends class_6379> narratables();
        
        void updateNarration(class_6382 narrationElementOutput) {
            List<? extends class_6379> list = this.narratables();
            class_437.class_6390 narratableSearchResult = class_437.method_37061(list, this.lastNarratable);
            if (narratableSearchResult != null) {
                if (narratableSearchResult.comp_4465().method_37028()) {
                    this.lastNarratable = narratableSearchResult.comp_4463();
                }
                
                if (list.size() > 1) {
                    narrationElementOutput.method_37034(class_6381.field_33789, class_2561.method_43469("narrator.position.object_list", narratableSearchResult.comp_4464() + 1, list.size()));
                    if (narratableSearchResult.comp_4465() == class_6380.field_33786) {
                        narrationElementOutput.method_37034(class_6381.field_33791, class_2561.method_43471("narration.component_list.usage"));
                    }
                }
                
                narratableSearchResult.comp_4463().method_37020(narrationElementOutput.method_37031());
            }
            
        }
    }
    
    @Environment(EnvType.CLIENT)
    class Entries extends AbstractList<E> {
        private final ArrayList<E> items;
        
        private Entries() {
            this.items = Lists.newArrayList();
        }
        
        @Override
        public void clear() {
            items.clear();
        }
        
        @Override
        public E get(int int_1) {
            return this.items.get(int_1);
        }
        
        @Override
        public int size() {
            return this.items.size();
        }
        
        @Override
        public E set(int int_1, E itemListWidget$Item_1) {
            E itemListWidget$Item_2 = this.items.set(int_1, itemListWidget$Item_1);
            itemListWidget$Item_1.parent = DynamicErrorFreeEntryListWidget.this;
            return itemListWidget$Item_2;
        }
        
        @Override
        public void add(int int_1, E itemListWidget$Item_1) {
            this.items.add(int_1, itemListWidget$Item_1);
            itemListWidget$Item_1.parent = DynamicErrorFreeEntryListWidget.this;
        }
        
        @Override
        public E remove(int int_1) {
            return this.items.remove(int_1);
        }
    }
}

