/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020, 2021, 2022, 2023 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.impl.client.gui.screen;

import com.google.common.collect.ImmutableList;
import me.shedaniel.rei.RoughlyEnoughItemsState;
import me.shedaniel.rei.impl.client.gui.InternalTextures;
import me.shedaniel.rei.impl.client.gui.widget.DynamicErrorFreeEntryListWidget;
import net.minecraft.class_1109;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3417;
import net.minecraft.class_3545;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5481;
import net.minecraft.class_6379;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import org.jetbrains.annotations.ApiStatus;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;

@ApiStatus.Internal
public class WarningAndErrorScreen extends class_437 {
    private class_339 buttonExit;
    private StringEntryListWidget listWidget;
    private String action;
    private class_437 parent;
    private List<class_3545<String, String>> warnings;
    private List<class_3545<String, String>> errors;
    private Consumer<class_437> onContinue;
    
    public WarningAndErrorScreen(String action, List<class_3545<String, String>> warnings, List<class_3545<String, String>> errors, Consumer<class_437> onContinue) {
        super(class_2561.method_43473());
        this.action = action;
        this.warnings = warnings;
        this.errors = errors;
        this.onContinue = onContinue;
    }
    
    @Override
    public boolean method_25422() {
        return false;
    }
    
    public void setParent(class_437 parent) {
        this.parent = parent;
    }
    
    private void addText(class_2561 string) {
        for (class_5481 s : field_22793.method_1728(string, field_22789 - 80)) {
            listWidget.creditsAddEntry(new TextItem(s));
        }
    }
    
    private void addLink(class_2561 string, String link) {
        for (class_5481 s : field_22793.method_1728(string, field_22789 - 80)) {
            listWidget.creditsAddEntry(new LinkItem(s, link));
        }
    }
    
    @Override
    public void method_25426() {
        method_25429(listWidget = new StringEntryListWidget(field_22787, field_22789, field_22790, 32, field_22790 - 32));
        listWidget.max = 80;
        listWidget.creditsClearEntries();
        listWidget.creditsAddEntry(new EmptyItem());
        if (!warnings.isEmpty())
            listWidget.creditsAddEntry(new TextItem(class_2561.method_43470("Warnings:").method_27692(class_124.field_1065).method_30937()));
        for (class_3545<String, String> pair : warnings) {
            addText(class_2561.method_43470(pair.method_15442()));
            if (pair.method_15441() != null)
                addLink(class_2561.method_43470(pair.method_15441()), pair.method_15441());
            for (int i = 0; i < 2; i++) {
                listWidget.creditsAddEntry(new EmptyItem());
            }
        }
        if (!warnings.isEmpty() && !errors.isEmpty()) {
            listWidget.creditsAddEntry(new EmptyItem());
        }
        if (!errors.isEmpty())
            listWidget.creditsAddEntry(new TextItem(class_2561.method_43470("Errors:").method_27692(class_124.field_1061).method_30937()));
        for (class_3545<String, String> pair : errors) {
            addText(class_2561.method_43470(pair.method_15442()));
            if (pair.method_15441() != null)
                addLink(class_2561.method_43470(pair.method_15441()), pair.method_15441());
            for (int i = 0; i < 2; i++) {
                listWidget.creditsAddEntry(new EmptyItem());
            }
        }
        for (StringItem child : listWidget.method_25396()) {
            listWidget.max = Math.max(listWidget.max, child.getWidth());
        }
        method_37063(buttonExit = new class_4185(field_22789 / 2 - 100, field_22790 - 26, 200, 20,
                class_2561.method_43470(errors.isEmpty() ? "Continue" : "Exit"),
                button -> onContinue.accept(parent), Supplier::get) {});
    }
    
    @Override
    public boolean method_25401(double double_1, double double_2, double amountX, double amountY) {
        return listWidget.method_25401(double_1, double_2, amountX, amountY) || super.method_25401(double_1, double_2, amountX, amountY);
    }
    
    @Override
    public void method_25394(class_332 graphics, int int_1, int int_2, float float_1) {
        super.method_25394(graphics, int_1, int_2, float_1);
        this.listWidget.method_25394(graphics, int_1, int_2, float_1);
        if (RoughlyEnoughItemsState.getErrors().isEmpty()) {
            graphics.method_25300(this.field_22793, "Warnings during Roughly Enough Items' " + action, this.field_22789 / 2, 16, 16777215);
        } else {
            graphics.method_25300(this.field_22793, "Errors during Roughly Enough Items' " + action, this.field_22789 / 2, 16, 16777215);
        }
        this.buttonExit.method_25394(graphics, int_1, int_2, float_1);
    }
    
    private static class StringEntryListWidget extends DynamicErrorFreeEntryListWidget<StringItem> {
        private boolean inFocus;
        private int max = 80;
        
        public StringEntryListWidget(class_310 client, int width, int height, int startY, int endY) {
            super(client, width, height, startY, endY, InternalTextures.LEGACY_DIRT);
        }
        
        public void creditsClearEntries() {
            clearItems();
        }
        
        private StringItem rei_getEntry(int int_1) {
            return this.method_25396().get(int_1);
        }
        
        public void creditsAddEntry(StringItem entry) {
            addItem(entry);
        }
        
        @Override
        public int getItemWidth() {
            return max;
        }
        
        @Override
        protected int getScrollbarPosition() {
            return width - 40;
        }
    }
    
    private abstract static class StringItem extends DynamicErrorFreeEntryListWidget.Entry<StringItem> {
        public abstract int getWidth();
        
        @Override
        public void method_25365(boolean bl) {
        }
        
        @Override
        public boolean method_25370() {
            return false;
        }
    }
    
    private static class EmptyItem extends StringItem {
        @Override
        public void render(class_332 graphics, int i, int i1, int i2, int i3, int i4, int i5, int i6, boolean b, float v) {
        
        }
        
        @Override
        public int getItemHeight() {
            return 5;
        }
        
        @Override
        public int getWidth() {
            return 0;
        }
        
        @Override
        public List<? extends class_6379> narratables() {
            return Collections.emptyList();
        }
    }
    
    private static class TextItem extends StringItem {
        private class_5481 text;
        
        public TextItem(class_5481 text) {
            this.text = text;
        }
        
        @Override
        public void render(class_332 graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            graphics.method_35720(class_310.method_1551().field_1772, text, x + 5, y, -1);
        }
        
        @Override
        public int getItemHeight() {
            return 12;
        }
        
        @Override
        public int getWidth() {
            return class_310.method_1551().field_1772.method_30880(text) + 10;
        }
        
        @Override
        public List<? extends class_6379> narratables() {
            return ImmutableList.of(new class_6379() {
                public class_6380 method_37018() {
                    return class_6380.field_33785;
                }
                
                public void method_37020(class_6382 narrationElementOutput) {
                    StringBuilder builder = new StringBuilder();
                    text.accept((i, style, j) -> {
                        builder.append(Character.toChars(j));
                        return false;
                    });
                    narrationElementOutput.method_37033(class_6381.field_33788, builder.toString());
                }
            });
        }
    }
    
    private class LinkItem extends StringItem {
        private class_5481 text;
        private String link;
        private boolean contains;
        
        public LinkItem(class_5481 text, String link) {
            this.text = text;
            this.link = link;
        }
        
        @Override
        public void render(class_332 graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            contains = mouseX >= x && mouseX <= x + entryWidth && mouseY >= y && mouseY <= y + entryHeight;
            if (contains) {
                graphics.method_51438(field_22793, class_2561.method_43470("Click to open link."), mouseX, mouseY);
                graphics.method_35720(class_310.method_1551().field_1772, characterVisitor -> {
                    return text.accept((charIndex, style, codePoint) -> characterVisitor.accept(charIndex, style.method_27706(class_124.field_1073), codePoint));
                }, x + 5, y, 0xff1fc3ff);
            } else {
                graphics.method_35720(class_310.method_1551().field_1772, text, x + 5, y, 0xff1fc3ff);
            }
        }
        
        @Override
        public int getItemHeight() {
            return 12;
        }
        
        @Override
        public int getWidth() {
            return class_310.method_1551().field_1772.method_30880(text) + 10;
        }
        
        @Override
        public boolean method_25402(class_11909 event, boolean doubleClick) {
            if (contains && event.method_74245() == 0) {
                class_310.method_1551().method_1483().method_4873(class_1109.method_47978(class_3417.field_15015, 1.0F));
                try {
                    class_156.method_668().method_673(new URI(link));
                    return true;
                } catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
            return false;
        }
        
        @Override
        public List<? extends class_6379> narratables() {
            return ImmutableList.of(new class_6379() {
                public class_6380 method_37018() {
                    return class_6380.field_33785;
                }
                
                public void method_37020(class_6382 narrationElementOutput) {
                    StringBuilder builder = new StringBuilder();
                    text.accept((i, style, j) -> {
                        builder.append(Character.toChars(j));
                        return false;
                    });
                    narrationElementOutput.method_37033(class_6381.field_33788, builder.toString());
                }
            });
        }
    }
}
