/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020, 2021, 2022, 2023 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.impl.client.gui.config.options.configure;

import me.shedaniel.clothconfig2.api.animator.NumberAnimator;
import me.shedaniel.clothconfig2.api.animator.ValueAnimator;
import me.shedaniel.math.FloatingRectangle;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.config.DisplayPanelLocation;
import me.shedaniel.rei.api.client.gui.config.PanelBoundary;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.impl.client.gui.config.ConfigAccess;
import me.shedaniel.rei.impl.client.gui.config.options.AllREIConfigOptions;
import me.shedaniel.rei.impl.client.gui.config.options.CompositeOption;
import me.shedaniel.rei.impl.client.gui.config.options.OptionValueEntry;
import net.minecraft.class_11908;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_357;
import net.minecraft.class_4286;
import net.minecraft.class_437;

import static me.shedaniel.rei.impl.client.gui.config.options.ConfigUtils.*;

public enum PanelBoundariesConfiguration implements OptionValueEntry.Configurator<PanelBoundary> {
    INSTANCE;
    
    @Override
    public void configure(ConfigAccess access, CompositeOption<PanelBoundary> option, Runnable onClose) {
        class_310.method_1551().method_1507(new BoundariesScreen(access, option, onClose));
    }
    
    private static class BoundariesScreen extends class_437 {
        private final ConfigAccess access;
        private final CompositeOption<PanelBoundary> option;
        private final Runnable onClose;
        private class_4286 horizontalLimit, verticalLimit;
        private class_357 horizontalSlider, verticalSlider;
        private class_357 horizontalAlignmentSlider, verticalAlignmentSlider;
        private boolean horizontalUsePercentage, verticalUsePercentage;
        private ValueAnimator<FloatingRectangle> boundsAnimator = ValueAnimator.ofFloatingRectangle();
        private NumberAnimator<Float> innerAlphaAnimator = ValueAnimator.ofFloat(1.0F);
        
        public BoundariesScreen(ConfigAccess access, CompositeOption<PanelBoundary> option, Runnable onClose) {
            super(literal(""));
            this.access = access;
            this.option = option;
            this.onClose = onClose;
            
            this.horizontalUsePercentage = access.get(option).horizontalPercentage() != 1.0;
            this.verticalUsePercentage = access.get(option).verticalPercentage() != 1.0;
        }
        
        @Override
        public void method_25426() {
            super.method_25426();
            PanelBoundary boundary = access.get(option);
            method_37063(horizontalLimit = class_4286.method_54787(class_2561.method_43473(), field_22793).method_54789(0, 0).method_54794(this.horizontalUsePercentage).method_54791((checkbox, opt) -> {
                horizontalUsePercentage = opt;
                PanelBoundary newBoundary = access.get(option);
                access.set(option, new PanelBoundary(1.0, newBoundary.verticalPercentage(), 50, newBoundary.verticalLimit(), 1.0, newBoundary.verticalAlign()));
                if (!isReducedMotion()) innerAlphaAnimator.setTo(-1.0F, 200);
                method_25423(field_22787, BoundariesScreen.this.field_22789, BoundariesScreen.this.field_22790);
            }).method_54788());
            double v = horizontalUsePercentage ? boundary.horizontalPercentage() : boundary.horizontalLimit() / 50.0;
            method_37063(horizontalSlider = new class_357(0, 0, 20, 20, getSliderMessage("config.rei.options.layout.boundaries.desc.limit", horizontalUsePercentage, v, 50), v) {
                @Override
                protected void method_25346() {
                    method_25355(getSliderMessage("config.rei.options.layout.boundaries.desc.limit", horizontalUsePercentage, field_22753, 50));
                }
                
                @Override
                protected void method_25344() {
                    PanelBoundary boundary = access.get(option);
                    if (horizontalUsePercentage) {
                        access.set(option, new PanelBoundary(field_22753, boundary.verticalPercentage(), 50, boundary.verticalLimit(), boundary.horizontalAlign(), boundary.verticalAlign()));
                    } else {
                        access.set(option, new PanelBoundary(1.0, boundary.verticalPercentage(), valueToLimit(field_22753, 50), boundary.verticalLimit(), boundary.horizontalAlign(), boundary.verticalAlign()));
                    }
                    if (!isReducedMotion()) innerAlphaAnimator.setTo(-1.0F, 200);
                }
                
                @Override
                public boolean method_25404(class_11908 event) {
                    if (horizontalUsePercentage) return super.method_25404(event);
                    boolean leftArrow = event.comp_4795() == 263;
                    double newValue;
                    if (leftArrow) {
                        newValue = class_3532.method_15350((valueToLimit(field_22753, 50) - 1) / 50.0, 0, 1);
                    } else if (event.comp_4795() == 262) {
                        newValue = class_3532.method_15350((valueToLimit(field_22753, 50) + 1) / 50.0, 0, 1);
                    } else {
                        return super.method_25404(event);
                    }
                    
                    if (newValue != field_22753) {
                        field_22753 = newValue;
                        method_25344();
                        method_25346();
                        return true;
                    }
                    
                    return false;
                }
            });
            DisplayPanelLocation location = access.get(AllREIConfigOptions.LOCATION);
            method_37063(horizontalAlignmentSlider = new class_357(0, 0, 20, 20, getHAlignmentSliderMessage(location == DisplayPanelLocation.LEFT ? 1 - boundary.horizontalAlign() : boundary.horizontalAlign()), location == DisplayPanelLocation.LEFT ? 1 - boundary.horizontalAlign() : boundary.horizontalAlign()) {
                @Override
                protected void method_25346() {
                    method_25355(getHAlignmentSliderMessage(field_22753));
                }
                
                @Override
                protected void method_25344() {
                    PanelBoundary boundary = access.get(option);
                    access.set(option, new PanelBoundary(boundary.horizontalPercentage(), boundary.verticalPercentage(), boundary.horizontalLimit(), boundary.verticalLimit(), location == DisplayPanelLocation.LEFT ? 1 - snapPercentage(field_22753) : snapPercentage(field_22753), boundary.verticalAlign()));
                    if (!isReducedMotion()) innerAlphaAnimator.setTo(-1.0F, 200);
                }
            });
            method_37063(verticalLimit = class_4286.method_54787(class_2561.method_43473(), field_22793).method_54789(0, 0).method_54794(this.verticalUsePercentage).method_54791((checkbox, opt) -> {
                verticalUsePercentage = opt;
                PanelBoundary newBoundary = access.get(option);
                access.set(option, new PanelBoundary(newBoundary.horizontalPercentage(), 1.0, newBoundary.horizontalLimit(), 1000, newBoundary.horizontalAlign(), 0.5));
                if (!isReducedMotion()) innerAlphaAnimator.setTo(-1.0F, 200);
                method_25423(field_22787, BoundariesScreen.this.field_22789, BoundariesScreen.this.field_22790);
            }).method_54788());
            v = verticalUsePercentage ? boundary.verticalPercentage() : boundary.verticalLimit() / 1000.0;
            method_37063(verticalSlider = new class_357(0, 0, 20, 20, getSliderMessage("config.rei.options.layout.boundaries.desc.limit", verticalUsePercentage, v, 1000), v) {
                @Override
                protected void method_25346() {
                    method_25355(getSliderMessage("config.rei.options.layout.boundaries.desc.limit", verticalUsePercentage, field_22753, 1000));
                }
                
                @Override
                protected void method_25344() {
                    PanelBoundary boundary = access.get(option);
                    if (verticalUsePercentage) {
                        access.set(option, new PanelBoundary(boundary.horizontalPercentage(), field_22753, boundary.horizontalLimit(), 1000, boundary.horizontalAlign(), boundary.verticalAlign()));
                    } else {
                        access.set(option, new PanelBoundary(boundary.horizontalPercentage(), 1.0, boundary.horizontalLimit(), valueToLimit(field_22753, 1000), boundary.horizontalAlign(), boundary.verticalAlign()));
                    }
                    if (!isReducedMotion()) innerAlphaAnimator.setTo(-1.0F, 200);
                }
                
                @Override
                public boolean method_25404(class_11908 event) {
                    if (verticalUsePercentage) return super.method_25404(event);
                    boolean leftArrow = event.comp_4795() == 263;
                    double newValue;
                    if (leftArrow) {
                        newValue = class_3532.method_15350((valueToLimit(field_22753, 1000) - 1) / 1000.0, 0, 1);
                    } else if (event.comp_4795() == 262) {
                        newValue = class_3532.method_15350((valueToLimit(field_22753, 1000) + 1) / 1000.0, 0, 1);
                    } else {
                        return super.method_25404(event);
                    }
                    
                    if (newValue != field_22753) {
                        field_22753 = newValue;
                        method_25344();
                        method_25346();
                        return true;
                    }
                    
                    return false;
                }
            });
            method_37063(verticalAlignmentSlider = new class_357(0, 0, 20, 20, getVAlignmentSliderMessage(boundary.verticalAlign()), boundary.verticalAlign()) {
                @Override
                protected void method_25346() {
                    method_25355(getVAlignmentSliderMessage(field_22753));
                }
                
                @Override
                protected void method_25344() {
                    PanelBoundary boundary = access.get(option);
                    access.set(option, new PanelBoundary(boundary.horizontalPercentage(), boundary.verticalPercentage(), boundary.horizontalLimit(), boundary.verticalLimit(), boundary.horizontalAlign(), snapPercentage(field_22753)));
                    if (!isReducedMotion()) innerAlphaAnimator.setTo(-1.0F, 200);
                }
            });
        }
        
        private class_2561 getSliderMessage(String translationKey, boolean usePercentage, double percentage, int max) {
            if (usePercentage) {
                return translatable(translationKey, String.format("%.1f%%", percentage * 100));
            } else if (valueToLimit(percentage, max) == max) {
                return translatable(translationKey, translatable("config.rei.value.default", valueToLimit(percentage, max) + ""));
            } else {
                return translatable(translationKey, valueToLimit(percentage, max) + "");
            }
        }
        
        private int valueToLimit(double v, int max) {
            return class_3532.method_15340((int) Math.round(v * max), 1, max);
        }
        
        private class_2561 getHAlignmentSliderMessage(double percentage) {
            String translationKey = "config.rei.options.layout.boundaries.desc.alignment";
            DisplayPanelLocation location = access.get(AllREIConfigOptions.LOCATION);
            if (percentage <= 0.02) {
                class_2561 component = translatable(translationKey, translatable("config.rei.options.layout.boundaries.desc.horizontal_alignment.left"));
                if (location == DisplayPanelLocation.LEFT) return translatable("config.rei.value.default", component);
                return component;
            } else if (percentage >= 0.98) {
                class_2561 component = translatable(translationKey, translatable("config.rei.options.layout.boundaries.desc.horizontal_alignment.right"));
                if (location == DisplayPanelLocation.RIGHT) return translatable("config.rei.value.default", component);
                return component;
            } else if (percentage >= 0.45 && percentage <= 0.55) {
                return translatable(translationKey, translatable("config.rei.options.layout.boundaries.desc.horizontal_alignment.center"));
            } else {
                return translatable(translationKey, String.format("%.1f%%", percentage * 100));
            }
        }
        
        private class_2561 getVAlignmentSliderMessage(double percentage) {
            String translationKey = "config.rei.options.layout.boundaries.desc.alignment";
            if (percentage <= 0.02) {
                return translatable(translationKey, translatable("config.rei.options.layout.boundaries.desc.vertical_alignment.top"));
            } else if (percentage >= 0.98) {
                return translatable(translationKey, translatable("config.rei.options.layout.boundaries.desc.vertical_alignment.bottom"));
            } else if (percentage >= 0.45 && percentage <= 0.55) {
                return translatable(translationKey, translatable("config.rei.value.default", translatable("config.rei.options.layout.boundaries.desc.vertical_alignment.center")));
            } else {
                return translatable(translationKey, String.format("%.1f%%", percentage * 100));
            }
        }
        
        private double snapPercentage(double percentage) {
            if (percentage <= 0.02) {
                return 0;
            } else if (percentage >= 0.98) {
                return 1;
            } else if (percentage >= 0.45 && percentage <= 0.55) {
                return 0.5;
            } else {
                return percentage;
            }
        }
        
        @Override
        public void method_25420(class_332 graphics, int mouseX, int mouseY, float delta) {
            super.method_25420(graphics, mouseX, mouseY, delta);
            Rectangle panelBounds = new Rectangle(this.field_22789 * 3 / 10, this.field_22790 * 4 / 40, this.field_22789 * 4 / 10, this.field_22790 * 32 / 40);
            Widgets.createCategoryBase(panelBounds).method_25394(graphics, mouseX, mouseY, delta);
        }
        
        @Override
        public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
            this.innerAlphaAnimator.setTarget(this.innerAlphaAnimator.target() + (1.0F - this.innerAlphaAnimator.target()) * 0.06F);
            this.innerAlphaAnimator.update(delta);
            super.method_25394(graphics, mouseX, mouseY, delta);
            Rectangle panelBounds = new Rectangle(this.field_22789 * 3 / 10, this.field_22790 * 4 / 40, this.field_22789 * 4 / 10, this.field_22790 * 32 / 40);
            int y = panelBounds.y + 6;
            graphics.method_51439(this.field_22793, translatable("config.rei.options.layout.boundaries.desc.configure").method_27692(class_124.field_1073), panelBounds.x + 6, y, 0xff404040, false);
            y += 14;
            graphics.method_51439(this.field_22793, translatable("config.rei.options.layout.boundaries.desc.horizontal"), panelBounds.x + 6, y, 0xff404040, false);
            this.horizontalLimit.method_46421(panelBounds.x + 6);
            this.horizontalLimit.method_46419(y + 10);
            graphics.method_51439(this.field_22793, translatable("config.rei.options.layout.boundaries.desc.limit_by_percentage"), horizontalLimit.method_46426() + 24, horizontalLimit.method_46427() + 6, 0xff404040, false);
            y += 32;
            this.horizontalSlider.method_46421(panelBounds.x + 6);
            this.horizontalSlider.method_46419(y);
            this.horizontalSlider.method_25358(panelBounds.width - 12);
            y += 22;
            this.horizontalAlignmentSlider.method_46421(panelBounds.x + 6);
            this.horizontalAlignmentSlider.method_46419(y);
            this.horizontalAlignmentSlider.method_25358(panelBounds.width - 12);
            y += 28;
            
            graphics.method_51439(this.field_22793, translatable("config.rei.options.layout.boundaries.desc.vertical"), panelBounds.x + 6, y, 0xff404040, false);
            this.verticalLimit.method_46421(panelBounds.x + 6);
            this.verticalLimit.method_46419(y + 10);
            graphics.method_51439(this.field_22793, translatable("config.rei.options.layout.boundaries.desc.limit_by_percentage"), verticalLimit.method_46426() + 24, verticalLimit.method_46427() + 6, 0xff404040, false);
            y += 32;
            this.verticalSlider.method_46421(panelBounds.x + 6);
            this.verticalSlider.method_46419(y);
            this.verticalSlider.method_25358(panelBounds.width - 12);
            y += 22;
            this.verticalAlignmentSlider.method_46421(panelBounds.x + 6);
            this.verticalAlignmentSlider.method_46419(y);
            this.verticalAlignmentSlider.method_25358(panelBounds.width - 12);
            
            renderPreview(graphics, panelBounds, delta);
        }
        
        private void renderPreview(class_332 graphics, Rectangle panelBounds, float delta) {
            int entrySize = class_3532.method_15384(18 * access.get(AllREIConfigOptions.ZOOM).value());
            Rectangle overlayBounds;
            DisplayPanelLocation location = access.get(AllREIConfigOptions.LOCATION);
            PanelBoundary boundary = access.get(option);
            if (location == DisplayPanelLocation.LEFT) {
                overlayBounds = new Rectangle(2, 0, panelBounds.x - 2, field_22790);
            } else {
                overlayBounds = new Rectangle(panelBounds.getMaxX() + 2, 0, field_22789 - panelBounds.getMaxX() - 4, field_22790);
            }
            
            double hAlign = location == DisplayPanelLocation.LEFT ? 1 - boundary.horizontalAlign() : boundary.horizontalAlign();
            int widthReduction = (int) Math.round(overlayBounds.width * (1 - boundary.horizontalPercentage()));
            overlayBounds.x += (int) Math.round(widthReduction * hAlign);
            overlayBounds.width -= widthReduction;
            int maxWidth = (int) Math.ceil(entrySize * boundary.horizontalLimit() + entrySize * 0.75);
            if (overlayBounds.width > maxWidth) {
                overlayBounds.x += (int) Math.round((overlayBounds.width - maxWidth) * hAlign);
                overlayBounds.width = maxWidth;
            }
            int heightReduction = (int) Math.round(overlayBounds.height * (1 - boundary.verticalPercentage()));
            overlayBounds.height -= heightReduction;
            overlayBounds.y += (int) Math.round(heightReduction * boundary.verticalAlign());
            int maxHeight = (int) Math.ceil(entrySize * boundary.verticalLimit() + entrySize * 0.75);
            if (overlayBounds.height > maxHeight) {
                overlayBounds.y += (int) Math.round((overlayBounds.height - maxHeight) * boundary.verticalAlign());
                overlayBounds.height = maxHeight;
            }
            this.boundsAnimator.update(delta);
            this.boundsAnimator.setTo(overlayBounds.getFloatingBounds(), class_156.method_656(() -> {
                FloatingRectangle target = boundsAnimator.target();
                return target.x == 0 && target.y == 0 && target.width == 0 && target.height == 0;
            }) || isReducedMotion() ? 0 : 200);
            overlayBounds = this.boundsAnimator.value().getBounds();
            
            graphics.method_25296(overlayBounds.x, overlayBounds.y, overlayBounds.getMaxX(), overlayBounds.getMaxY(), 0x80fff0ad, 0x80fff0ad);
            
            int width = Math.max(class_3532.method_15375((overlayBounds.width - 2) / (float) entrySize), 1);
            int height = Math.max(class_3532.method_15375((overlayBounds.height - 2) / (float) entrySize), 1);
            Rectangle innerBounds = new Rectangle((int) (overlayBounds.getCenterX() - width * (entrySize / 2f)), (int) (overlayBounds.getCenterY() - height * (entrySize / 2f)), width * entrySize, height * entrySize);
            int color = 0x823c0a | ((int) (Math.ceil(class_3532.method_15363(innerAlphaAnimator.floatValue(), 0, 1) * 0x80))) << 24;
            for (int i = 0; i < width; i++) {
                for (int j = 0; j < height; j++) {
                    int slotX = innerBounds.x + i * entrySize + 1;
                    int slotY = innerBounds.y + j * entrySize + 1;
                    graphics.method_25296(slotX, slotY, slotX + entrySize - 2, slotY + entrySize - 2, color, color);
                }
            }
        }
        
        @Override
        public void method_25419() {
            this.onClose.run();
        }
    }
}
