/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020, 2021, 2022, 2023 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.impl.client.gui.screen;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import me.shedaniel.clothconfig2.gui.widget.DynamicNewSmoothScrollingEntryListWidget;
import me.shedaniel.clothconfig2.impl.EasingMethod;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.gui.config.DisplayScreenType;
import me.shedaniel.rei.api.client.gui.widgets.Button;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import net.minecraft.class_10799;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_5481;
import org.jetbrains.annotations.ApiStatus;

import java.util.Collections;
import java.util.List;

@ApiStatus.Internal
public class UncertainDisplayViewingScreen extends class_437 {
    private static final class_2960 DEFAULT = class_2960.method_60655("roughlyenoughitems", "textures/gui/screenshot_default.png");
    private static final class_2960 COMPOSITE = class_2960.method_60655("roughlyenoughitems", "textures/gui/screenshot_composite.png");
    private final List<Widget> widgets;
    protected long start;
    protected long duration;
    private boolean isSet;
    private boolean original;
    private double frame = 0;
    private double target = 0;
    private BooleanConsumer callback;
    private Button button;
    private class_437 parent;
    private boolean showTips;
    
    public UncertainDisplayViewingScreen(class_437 parent, DisplayScreenType type, boolean showTips, BooleanConsumer callback) {
        super(class_2561.method_43473());
        this.widgets = Lists.newArrayList();
        if (type == DisplayScreenType.UNSET) {
            this.isSet = false;
            this.original = true;
        } else {
            this.isSet = true;
            this.original = type == DisplayScreenType.ORIGINAL;
            moveFrameTo(original ? 0 : 1, false, 0);
        }
        this.callback = callback;
        this.parent = parent;
        this.showTips = showTips;
    }
    
    public final double clamp(double v) {
        return clamp(v, 30);
    }
    
    public final double clamp(double v, double clampExtension) {
        return class_3532.method_15350(v, -clampExtension, 1 + clampExtension);
    }
    
    private void moveFrameTo(double value, boolean animated, long duration) {
        target = clamp(value);
        
        if (animated) {
            start = System.currentTimeMillis();
            this.duration = duration;
        } else {
            frame = target;
        }
    }
    
    @Override
    public void method_25426() {
        this.method_25396().clear();
        this.widgets.clear();
        this._children().add(button = Widgets.createButton(new Rectangle(field_22789 / 2 - 100, field_22790 - 40, 200, 20), class_2561.method_43473())
                .onRender((matrices, button) -> {
                    button.setEnabled(isSet);
                    button.setText(class_2561.method_43471("gui.done"));
                })
                .onClick(button -> {
                    callback.accept(original);
                }));
        this.widgets.add(new ScreenTypeSelection(field_22789 / 2 - 200 - 5, field_22790 / 2 - 112 / 2 - 10, DisplayScreenType.ORIGINAL));
        this.widgets.add(Widgets.createLabel(new Point(field_22789 / 2 - 200 - 5 + 104, field_22790 / 2 - 112 / 2 + 115), class_2561.method_43471("config.roughlyenoughitems.recipeScreenType.original")).noShadow().color(-1124073473));
        this.widgets.add(new ScreenTypeSelection(field_22789 / 2 + 5, field_22790 / 2 - 112 / 2 - 10, DisplayScreenType.COMPOSITE));
        this.widgets.add(Widgets.createLabel(new Point(field_22789 / 2 + 5 + 104, field_22790 / 2 - 112 / 2 + 115), class_2561.method_43471("config.roughlyenoughitems.recipeScreenType.composite")).noShadow().color(-1124073473));
        this._children().addAll(widgets);
    }
    
    public List<class_364> _children() {
        return (List<class_364>) method_25396();
    }
    
    @Override
    public void method_25394(class_332 graphics, int int_1, int int_2, float float_1) {
        super.method_25394(graphics, int_1, int_2, float_1);
        graphics.method_27534(this.field_22793, class_2561.method_43471("text.rei.recipe_screen_type.selection"), this.field_22789 / 2, 20, 0xFFFFFFFF);
        graphics.method_44379(0, 20 + field_22793.field_2000 + 2, field_22789, 20 + field_22793.field_2000 + 2 + field_22790 - 42);
        if (showTips) {
            int i = 32;
            for (class_5481 s : this.field_22793.method_1728(class_2561.method_43471("text.rei.recipe_screen_type.selection.sub").method_27692(class_124.field_1080), field_22789 - 30)) {
                graphics.method_35720(field_22793, s, field_22789 / 2 - field_22793.method_30880(s) / 2, i, -1);
                i += 10;
            }
        }
        int k = 10, l = 44, m = field_22789 - 20, n = field_22790 - l - 10 - 5;
        graphics.method_25294( k + 1, l, k + m, l + n, -16777216);
        graphics.method_25294(k, l, m, n, -1);
        for (Widget widget : widgets) {
            widget.method_25394(graphics, int_1, int_2, float_1);
        }
        if (isSet) {
            graphics.method_51448().pushMatrix();
            updateFramePosition(float_1);
            int x = (int) (field_22789 / 2 - 205 + (200 * frame)) + 10;
            int y = field_22790 / 2 - 112 / 2 - 10;
            graphics.method_25296(x - 2, y - 4, x - 6 + 208- 10, y - 4 + 2, -1778384897, -1778384897);
            graphics.method_25296(x - 2, y - 4 + 126 - 2, x - 6 + 208- 10, y - 4 + 126, -1778384897, -1778384897);
            graphics.method_25296(x - 4, y - 4, x - 4 + 2, y - 4 + 126, -1778384897, -1778384897);
            graphics.method_25296(x - 4 + 208 - 2 - 10, y - 4, x - 4 + 208 - 10, y - 4 + 126, -1778384897, -1778384897);
            graphics.method_51448().popMatrix();
        }
        graphics.method_44380();
        button.method_25394(graphics, int_1, int_2, float_1);
    }
    
    @Override
    public void method_25420(class_332 graphics, int i, int j, float f) {
        super.method_25420(graphics, i, j, f);
    }
    
    private void updateFramePosition(float delta) {
        target = clamp(target);
        if (!DynamicNewSmoothScrollingEntryListWidget.Precision.almostEquals(frame, target, DynamicNewSmoothScrollingEntryListWidget.Precision.FLOAT_EPSILON))
            frame = ease(frame, target, Math.min((System.currentTimeMillis() - start) / (double) duration * delta * 3.0D, 1));
        else
            frame = target;
    }
    
    private double ease(double start, double end, double amount) {
        return start + (end - start) * EasingMethod.EasingMethodImpl.LINEAR.apply(amount);
    }
    
    @Override
    public boolean method_25404(class_11908 event) {
        if (event.comp_4795() == 256 || this.field_22787.field_1690.field_1822.method_1417(event)) {
            class_310.method_1551().method_1507(parent);
            if (parent instanceof class_465) {
                REIRuntime.getInstance().getOverlay().get().queueReloadOverlay();
            }
            return true;
        }
        return super.method_25404(event);
    }
    
    public class ScreenTypeSelection extends WidgetWithBounds {
        private final DisplayScreenType type;
        private Rectangle bounds;
        
        public ScreenTypeSelection(int x, int y, DisplayScreenType type) {
            this.type = type;
            this.bounds = new Rectangle(x - 4 + 16, y - 4, 176 + 8, 120 + 8);
        }
        
        @Override
        public Rectangle getBounds() {
            return bounds;
        }
        
        @Override
        public void method_25394(class_332 graphics, int i, int i1, float delta) {
            graphics.method_25302(class_10799.field_56883, type == DisplayScreenType.ORIGINAL ? DEFAULT : COMPOSITE, bounds.x + (type == DisplayScreenType.ORIGINAL ? 8 : 4), bounds.y + 4, bounds.width - 8, bounds.height - 8, 113, type == DisplayScreenType.ORIGINAL ? 16 : 27, 854 - 113 * 2, 480 - 27 * 2, 854, 480);
        }
        
        @Override
        public boolean method_25402(class_11909 event, boolean doubleClick) {
            if (containsMouse(event.comp_4798(), event.comp_4799())) {
                original = (type == DisplayScreenType.ORIGINAL);
                if (!isSet) {
                    moveFrameTo(original ? 0 : 1, false, 0);
                }
                isSet = true;
                moveFrameTo(original ? 0 : 1, true, 500);
                return true;
            }
            return false;
        }
        
        @Override
        public List<? extends class_364> method_25396() {
            return Collections.emptyList();
        }
    }
}
