/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020, 2021, 2022, 2023 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.impl.client.gui.credits;

import me.shedaniel.rei.impl.client.gui.text.TextTransformations;
import me.shedaniel.rei.impl.client.gui.widget.UpdatedListWidget;
import net.minecraft.class_1109;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_5481;
import net.minecraft.class_6379;
import net.minecraft.util.*;
import org.jetbrains.annotations.ApiStatus;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;

@ApiStatus.Internal
public class CreditsEntryListWidget extends UpdatedListWidget<CreditsEntryListWidget.CreditsItem> {
    private boolean inFocus;
    
    public CreditsEntryListWidget(class_310 client, int width, int height, int startY, int endY) {
        super(client, width, height, startY, endY);
    }
    
    public void creditsClearEntries() {
        clearItems();
    }
    
    private CreditsItem rei_getEntry(int index) {
        return this.method_25396().get(index);
    }
    
    public void creditsAddEntry(CreditsItem entry) {
        addItem(entry);
    }
    
    @Override
    public int getItemWidth() {
        return width - 80;
    }
    
    @Override
    protected int getScrollbarPosition() {
        return width - 40;
    }
    
    public static abstract class CreditsItem extends UpdatedListWidget.Entry<CreditsItem> {
        @Override
        public List<? extends class_6379> narratables() {
            return Collections.emptyList();
        }
        
        @Override
        public void method_25365(boolean bl) {
        }
        
        @Override
        public boolean method_25370() {
            return false;
        }
    }
    
    public static class TextCreditsItem extends CreditsItem {
        private class_2561 text;
        
        public TextCreditsItem(class_2561 text) {
            this.text = text;
        }
        
        @Override
        public void render(class_332 graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            graphics.method_35720(class_310.method_1551().field_1772, text.method_30937(), x + 5, y + 5, -1);
        }
        
        @Override
        public int getItemHeight() {
            return 12;
        }
    }
    
    public static class TranslationCreditsItem extends CreditsItem {
        private class_2561 language;
        private List<class_5481> translators;
        private int maxWidth;
        
        public TranslationCreditsItem(class_2561 language, class_2561 translators, int width, int maxWidth) {
            this.language = language;
            this.translators = class_310.method_1551().field_1772.method_1728(translators, width);
            this.maxWidth = maxWidth;
        }
        
        @Override
        public void render(class_332 graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            graphics.method_35720(class_310.method_1551().field_1772, language.method_30937(), x + 5, y + 5, -1);
            int yy = y + 5;
            for (class_5481 translator : translators) {
                graphics.method_35720(class_310.method_1551().field_1772, translator, x + 5 + maxWidth, yy, -1);
                yy += 12;
            }
        }
        
        @Override
        public int getItemHeight() {
            return 12 * translators.size();
        }
    }
    
    public static class LinkItem extends CreditsItem {
        private class_2561 text;
        private List<class_5481> textSplit;
        private String link;
        private boolean contains;
        private boolean rainbow;
        
        public LinkItem(class_2561 text, String link, int width, boolean rainbow) {
            this.text = text;
            this.textSplit = class_310.method_1551().field_1772.method_1728(text, width);
            this.link = link;
            this.rainbow = rainbow;
        }
        
        @Override
        public void render(class_332 graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            contains = mouseX >= x && mouseX <= x + entryWidth && mouseY >= y && mouseY <= y + entryHeight;
            if (contains) {
                graphics.method_51438(class_310.method_1551().field_1772, class_2561.method_43470("Click to open link."), mouseX, mouseY);
                int yy = y;
                for (class_5481 textSp : textSplit) {
                    class_5481 underlined = characterVisitor -> {
                        return textSp.accept((charIndex, style, codePoint) -> characterVisitor.accept(charIndex, style.method_27706(class_124.field_1073), codePoint));
                    };
                    if (rainbow) underlined = TextTransformations.applyRainbow(underlined, x + 5, yy);
                    graphics.method_35720(class_310.method_1551().field_1772, underlined, x + 5, yy, 0xff1fc3ff);
                    yy += 12;
                }
            } else {
                int yy = y;
                for (class_5481 textSp : textSplit) {
                    if (rainbow) textSp = TextTransformations.applyRainbow(textSp, x + 5, yy);
                    graphics.method_35720(class_310.method_1551().field_1772, textSp, x + 5, yy, 0xff1fc3ff);
                    yy += 12;
                }
            }
        }
        
        @Override
        public int getItemHeight() {
            return 12 * textSplit.size();
        }
        
        @Override
        public boolean method_25402(class_11909 event, boolean doubleClick) {
            if (contains && event.method_74245() == 0) {
                class_310.method_1551().method_1483().method_4873(class_1109.method_47978(class_3417.field_15015, 1.0F));
                try {
                    class_156.method_668().method_673(new URI(link));
                    return true;
                } catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
            return false;
        }
    }
}
