/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020, 2021, 2022, 2023 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.plugin.common.displays.cooking;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.class_1874;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_8786;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import java.util.List;
import java.util.Optional;
import java.util.OptionalDouble;

public abstract class DefaultCookingDisplay extends BasicDisplay implements CookingDisplay {
    protected float xp;
    protected double cookTime;
    
    public DefaultCookingDisplay(class_8786<? extends class_1874> recipe) {
        this(List.of(EntryIngredients.ofIngredient(recipe.comp_1933().method_64720())),
                List.of(EntryIngredients.of(recipe.comp_1933().method_64721())),
                Optional.of(recipe.comp_1932().method_29177()), recipe.comp_1933().method_8171(), recipe.comp_1933().method_8167());
    }
    
    public DefaultCookingDisplay(List<EntryIngredient> input, List<EntryIngredient> output, Optional<class_2960> id, class_2487 tag) {
        this(input, output, id, tag.method_10583("xp").orElseThrow(), tag.method_10574("cookTime").orElseThrow());
    }
    
    public DefaultCookingDisplay(List<EntryIngredient> input, List<EntryIngredient> output, Optional<class_2960> id, float xp, double cookTime) {
        super(input, output, id);
        this.xp = xp;
        this.cookTime = cookTime;
    }
    
    @Override
    public OptionalDouble xp() {
        return OptionalDouble.of(xp);
    }
    
    @Override
    public OptionalDouble cookTime() {
        return OptionalDouble.of(cookTime);
    }
    
    protected static <D extends DefaultCookingDisplay> DisplaySerializer<D> serializer(Constructor<D> constructor) {
        return DisplaySerializer.of(
                RecordCodecBuilder.mapCodec(instance -> instance.group(
                        EntryIngredient.codec().listOf().fieldOf("inputs").forGetter(D::getInputEntries),
                        EntryIngredient.codec().listOf().fieldOf("outputs").forGetter(D::getOutputEntries),
                        class_2960.field_25139.optionalFieldOf("location").forGetter(D::getDisplayLocation),
                        Codec.FLOAT.fieldOf("xp").forGetter(display -> display.xp),
                        Codec.DOUBLE.fieldOf("cookTime").forGetter(display -> display.cookTime)
                ).apply(instance, constructor::create)),
                class_9139.method_56906(
                        EntryIngredient.streamCodec().method_56433(class_9135.method_56363()),
                        D::getInputEntries,
                        EntryIngredient.streamCodec().method_56433(class_9135.method_56363()),
                        D::getOutputEntries,
                        class_9135.method_56382(class_2960.field_48267),
                        D::getDisplayLocation,
                        class_9135.field_48552,
                        display -> display.xp,
                        class_9135.field_48553,
                        display -> display.cookTime,
                        constructor::create
                ));
    }
    
    protected interface Constructor<T extends DefaultCookingDisplay> {
        T create(List<EntryIngredient> inputs, List<EntryIngredient> outputs, Optional<class_2960> location, float xp, double cookTime);
    }
}
