/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020, 2021, 2022, 2023 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.plugin.client.favorites;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.Lifecycle;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.favorites.CompoundFavoriteRenderer;
import me.shedaniel.rei.api.client.favorites.FavoriteEntry;
import me.shedaniel.rei.api.client.favorites.FavoriteEntryType;
import me.shedaniel.rei.api.client.favorites.FavoriteMenuEntry;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.TooltipContext;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import net.minecraft.class_1109;
import net.minecraft.class_124;
import net.minecraft.class_1934;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_364;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

import java.util.*;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class GameModeFavoriteEntry extends FavoriteEntry {
    public static final class_2960 ID = class_2960.method_60655("roughlyenoughitems", "gamemode");
    public static final String TRANSLATION_KEY = "favorite.section.gamemode";
    public static final String KEY = "mode";
    @Nullable
    private final class_1934 gameMode;
    
    public GameModeFavoriteEntry(@Nullable class_1934 gameMode) {
        this.gameMode = gameMode;
    }
    
    @Override
    public boolean isInvalid() {
        return false;
    }
    
    @Override
    public Renderer getRenderer(boolean showcase) {
        if (gameMode == null) {
            List<Renderer> renderers = IntStream.range(0, 4).mapToObj(GameModeFavoriteEntry::getRenderer).collect(Collectors.toList());
            return new CompoundFavoriteRenderer(showcase, renderers, () -> class_310.method_1551().field_1761.method_2920().method_8379()) {
                @Override
                @Nullable
                public Tooltip getTooltip(TooltipContext context) {
                    return Tooltip.create(context.getPoint(), class_2561.method_43471("text.rei.gamemode_button.tooltip.dropdown"));
                }
                
                @Override
                public boolean equals(Object o) {
                    if (this == o) return true;
                    if (o == null || getClass() != o.getClass()) return false;
                    return hashCode() == o.hashCode();
                }
                
                @Override
                public int hashCode() {
                    return Objects.hash(getClass(), showcase);
                }
            };
        }
        return getRenderer(gameMode.method_8379());
    }
    
    private static Renderer getRenderer(int id) {
        class_1934 type = class_1934.method_8384(id);
        return new Renderer() {
            @Override
            public void render(class_332 graphics, Rectangle bounds, int mouseX, int mouseY, float delta) {
                int color = bounds.contains(mouseX, mouseY) ? 0xFFEEEEEE : 0xFFAAAAAA;
                if (bounds.width > 4 && bounds.height > 4) {
                    graphics.method_51448().method_22903();
                    graphics.method_51448().method_46416(bounds.getCenterX(), bounds.getCenterY(), 0);
                    graphics.method_51448().method_22905(bounds.getWidth() / 18f, bounds.getHeight() / 18f, 1);
                    renderGameModeText(graphics, type, 0, 0, color);
                    graphics.method_51448().method_22909();
                }
            }
            
            private void renderGameModeText(class_332 graphics, class_1934 type, int centerX, int centerY, int color) {
                class_2561 s = class_2561.method_43471("text.rei.short_gamemode." + type.method_8381());
                class_327 font = class_310.method_1551().field_1772;
                graphics.method_51448().method_22903();
                graphics.method_51448().method_46416(centerX - font.method_27525(s) / 2f + 0.5f, centerY - 3.5f, 0);
                graphics.method_51439(font, s, 0, 0, color, false);
                graphics.method_51448().method_22909();
            }
            
            @Override
            @Nullable
            public Tooltip getTooltip(TooltipContext context) {
                return Tooltip.create(context.getPoint(), class_2561.method_43469("text.rei.gamemode_button.tooltip.entry", type.method_8383().getString()));
            }
            
            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;
                return hashCode() == o.hashCode();
            }
            
            @Override
            public int hashCode() {
                return Objects.hash(getClass(), false, type);
            }
        };
    }
    
    @Override
    public boolean doAction(int button) {
        if (button == 0) {
            class_1934 mode = gameMode;
            if (mode == null) {
                mode = class_1934.method_8384(class_310.method_1551().field_1761.method_2920().method_8379() + 1 % 4);
            }
            class_310.method_1551().field_1724.field_3944.method_45730(StringUtils.removeStart(ConfigObject.getInstance().getGamemodeCommand().replaceAll("\\{gamemode}", mode.name().toLowerCase(Locale.ROOT)), "/"));
            class_310.method_1551().method_1483().method_4873(class_1109.method_47978(class_3417.field_15015, 1.0F));
            return true;
        }
        return false;
    }
    
    @Override
    public Optional<Supplier<Collection<FavoriteMenuEntry>>> getMenuEntries() {
        if (gameMode == null)
            return Optional.of(this::_getMenuEntries);
        return Optional.empty();
    }
    
    private Collection<FavoriteMenuEntry> _getMenuEntries() {
        return CollectionUtils.filterAndMap(Arrays.asList(class_1934.values()), type -> type.method_8379() >= 0, GameModeMenuEntry::new);
    }
    
    @Override
    public long hashIgnoreAmount() {
        return gameMode == null ? 31290831290L : gameMode.ordinal();
    }
    
    @Override
    public FavoriteEntry copy() {
        return this;
    }
    
    @Override
    public class_2960 getType() {
        return ID;
    }
    
    @Override
    public boolean isSame(FavoriteEntry other) {
        if (!(other instanceof GameModeFavoriteEntry that)) return false;
        return Objects.equals(gameMode, that.gameMode);
    }
    
    public enum Type implements FavoriteEntryType<GameModeFavoriteEntry> {
        INSTANCE;
        
        @Override
        public DataResult<GameModeFavoriteEntry> read(class_2487 object) {
            String stringValue = object.method_68564(KEY, "NOT_SET");
            class_1934 type = stringValue.equals("NOT_SET") ? null : class_1934.valueOf(stringValue);
            return DataResult.success(new GameModeFavoriteEntry(type), Lifecycle.stable());
        }
        
        @Override
        public DataResult<GameModeFavoriteEntry> fromArgs(Object... args) {
            if (args.length == 0) return DataResult.error(() -> "Cannot create GameModeFavoriteEntry from empty args!");
            if (!(args[0] instanceof class_1934 type))
                return DataResult.error(() -> "Creation of GameModeFavoriteEntry from args expected GameType as the first argument!");
            return DataResult.success(new GameModeFavoriteEntry(type), Lifecycle.stable());
        }
        
        @Override
        public class_2487 save(GameModeFavoriteEntry entry, class_2487 tag) {
            tag.method_10582(KEY, entry.gameMode == null ? "NOT_SET" : entry.gameMode.name());
            return tag;
        }
    }
    
    public static class GameModeMenuEntry extends FavoriteMenuEntry {
        public final String text;
        public final class_1934 gameMode;
        private int x, y, width;
        private boolean selected, containsMouse, rendering;
        private int textWidth = -69;
        
        public GameModeMenuEntry(class_1934 gameMode) {
            this.text = gameMode.method_8383().getString();
            this.gameMode = gameMode;
        }
        
        private int getTextWidth() {
            if (textWidth == -69) {
                this.textWidth = Math.max(0, font.method_1727(text));
            }
            return this.textWidth;
        }
        
        @Override
        public int getEntryWidth() {
            return getTextWidth() + 4;
        }
        
        @Override
        public int getEntryHeight() {
            return 12;
        }
        
        @Override
        public List<? extends class_364> method_25396() {
            return Collections.emptyList();
        }
        
        @Override
        public void updateInformation(int xPos, int yPos, boolean selected, boolean containsMouse, boolean rendering, int width) {
            this.x = xPos;
            this.y = yPos;
            this.selected = selected;
            this.containsMouse = containsMouse;
            this.rendering = rendering;
            this.width = width;
        }
        
        @Override
        public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
            boolean disabled = this.minecraft.field_1761.method_2920() == gameMode;
            if (selected && !disabled) {
                graphics.method_25294(x, y, x + width, y + 12, -12237499);
            }
            if (!disabled && selected && containsMouse) {
                REIRuntime.getInstance().queueTooltip(Tooltip.create(class_2561.method_43469("text.rei.gamemode_button.tooltip.entry", text)));
            }
            String s = text;
            if (disabled) {
                s = class_124.field_1055 + s;
            }
            graphics.method_51433(font, s, x + 2, y + 2, selected && !disabled ? 16777215 : 8947848, false);
        }
        
        @Override
        public boolean method_25402(double mouseX, double mouseY, int button) {
            class_310.method_1551().field_1724.field_3944.method_45730(StringUtils.removeStart(ConfigObject.getInstance().getGamemodeCommand().replaceAll("\\{gamemode}", gameMode.name().toLowerCase(Locale.ROOT)), "/"));
            minecraft.method_1483().method_4873(class_1109.method_47978(class_3417.field_15015, 1.0F));
            closeMenu();
            return true;
        }
        
        @Override
        public boolean containsMouse(double mouseX, double mouseY) {
            boolean disabled = this.minecraft.field_1761.method_2920() == gameMode;
            return rendering && mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + 12 && !disabled;
        }
    }
}
