/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020, 2021, 2022, 2023 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.plugin.client.categories.tag;

import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.util.MatrixUtils;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.plugin.common.displays.tag.TagNode;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_6880;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

public class ReferenceTagNodeWidget<S, T> extends TagNodeWidget<S, T> {
    private final TagNode<S> node;
    private final Rectangle overflowBounds;
    private final Rectangle bounds;
    private final Slot slot;
    private final List<? extends class_364> children;
    
    public ReferenceTagNodeWidget(TagNode<S> node, Function<class_6880<S>, EntryStack<T>> mapper, Rectangle overflowBounds) {
        this.node = node;
        this.overflowBounds = overflowBounds;
        this.bounds = new Rectangle(0, 0, 24, 23);
        this.slot = Widgets.createSlot(new Rectangle(0, 0, 18, 18))
                .disableBackground()
                .disableHighlight()
                .disableTooltips()
                .entries(EntryIngredients.ofTag(BasicDisplay.registryAccess(), node.getReference(), mapper));
        this.children = Collections.singletonList(this.slot);
    }
    
    @Override
    public Rectangle getBounds() {
        return bounds;
    }
    
    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        if (this.overflowBounds.intersects(MatrixUtils.transform(graphics.method_51448().method_23760().method_23761(), getBounds()))) {
            graphics.method_25295(class_1921::method_62277, class_2960.method_60656("textures/gui/sprites/advancements/task_frame_unobtained.png"),
                    bounds.x - 1, bounds.x - 1 + 26, bounds.y - 1, bounds.y - 1 + 26,
                    0, 1, 0, 1, -1);
            this.slot.getBounds().setLocation(bounds.getCenterX() - this.slot.getBounds().getWidth() / 2, bounds.y + (bounds.height - this.slot.getBounds().getHeight()) / 2 + 1);
            this.slot.method_25394(graphics, mouseX, mouseY, delta);
            if (this.containsMouse(mouseX, mouseY)) {
                Tooltip.create(class_2561.method_43470("#" + this.node.getReference().comp_327().toString())).queue();
            }
        }
    }
    
    @Override
    public List<? extends class_364> method_25396() {
        return children;
    }
}
