/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020, 2021, 2022, 2023 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.impl.client.gui.widget.basewidgets;

import me.shedaniel.clothconfig2.api.animator.ValueAnimator;
import me.shedaniel.clothconfig2.api.animator.ValueProvider;
import me.shedaniel.math.Color;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.gui.widgets.Button;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import net.minecraft.class_1109;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_364;
import net.minecraft.class_8016;
import net.minecraft.class_8023;
import net.minecraft.class_8666;
import org.jetbrains.annotations.Nullable;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

public class ButtonWidget extends Button {
    private static final class_8666 SPRITES = new class_8666(class_2960.method_60656("widget/button"), class_2960.method_60656("widget/button_disabled"), class_2960.method_60656("widget/button_highlighted"));
    private static final class_8666 DARK_SPRITES = new class_8666(class_2960.method_60654("roughlyenoughitems:widget/button_dark"), class_2960.method_60654("roughlyenoughitems:widget/button_disabled_dark"), class_2960.method_60654("roughlyenoughitems:widget/button_highlighted_dark"));
    private Rectangle bounds;
    private boolean enabled = true;
    private class_2561 text;
    @Nullable
    private Integer tint;
    @Nullable
    private Consumer<Button> onClick;
    @Nullable
    private BiConsumer<class_332, Button> onRender;
    private boolean focusable = false;
    private boolean focused = false;
    @Nullable
    private Function<Button, @Nullable class_2561[]> tooltipFunction;
    @Nullable
    private BiFunction<Button, Point, Integer> textColorFunction;
    private final ValueAnimator<Color> darkBackground;
    private ValueProvider<Double> alpha;
    
    public ButtonWidget(Rectangle rectangle, class_2561 text) {
        this.bounds = Objects.requireNonNull(rectangle);
        this.text = Objects.requireNonNull(text);
        this.darkBackground = ValueAnimator.ofColor()
                .withConvention(() -> Color.ofTransparent(REIRuntime.getInstance().isDarkThemeEnabled() ? 0xFFFFFFFF : 0x00FFFFFF), ValueAnimator.typicalTransitionTime());
        this.alpha = ValueProvider.constant(1.0);
    }
    
    @Override
    public final boolean method_25370() {
        return focused;
    }
    
    @Override
    public final boolean isEnabled() {
        return enabled;
    }
    
    @Override
    public final void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
    
    @Override
    public final OptionalInt getTint() {
        return OptionalInt.empty();
    }
    
    @Override
    public final void setTint(int tint) {
        this.tint = tint;
    }
    
    @Override
    public final void removeTint() {
        this.tint = null;
    }
    
    @Override
    public final class_2561 getText() {
        return text;
    }
    
    @Override
    public final void setText(class_2561 text) {
        this.text = text;
    }
    
    @Override
    public final @Nullable Consumer<Button> getOnClick() {
        return onClick;
    }
    
    @Override
    public final void setOnClick(@Nullable Consumer<Button> onClick) {
        this.onClick = onClick;
    }
    
    @Nullable
    @Override
    public final BiConsumer<class_332, Button> getOnRender() {
        return onRender;
    }
    
    @Override
    public final void setOnRender(BiConsumer<class_332, Button> onRender) {
        this.onRender = onRender;
    }
    
    @Override
    public final boolean isFocusable() {
        return focusable;
    }
    
    @Override
    public final void setFocusable(boolean focusable) {
        this.focusable = focusable;
    }
    
    public void setAlpha(ValueProvider<Double> alpha) {
        this.alpha = alpha;
    }
    
    @Override
    @Nullable
    public final class_2561[] getTooltip() {
        if (tooltipFunction == null)
            return null;
        return tooltipFunction.apply(this);
    }
    
    @Override
    public final void setTooltip(@Nullable Function<Button, @Nullable class_2561[]> tooltip) {
        this.tooltipFunction = tooltip;
    }
    
    @Override
    public final void setTextColor(@Nullable BiFunction<Button, Point, Integer> textColorFunction) {
        this.textColorFunction = textColorFunction;
    }
    
    @Override
    public final int getTextColor(Point mouse) {
        if (this.textColorFunction != null) {
            Integer apply = this.textColorFunction.apply(this, mouse);
            if (apply != null)
                return apply;
        }
        if (!this.enabled) {
            return 10526880;
        } else if (isFocused(mouse.x, mouse.y)) {
            return 16777120;
        }
        return 14737632;
    }
    
    @Override
    public final Rectangle getBounds() {
        return bounds;
    }
    
    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        darkBackground.update(delta);
        alpha.update(delta);
        if (onRender != null) {
            onRender.accept(graphics, this);
        }
        int x = bounds.x, y = bounds.y, width = bounds.width, height = bounds.height;
        int alphaAsInt = (int) (alpha.value() * 255);
        renderBackground(graphics, x, y, width, height, isFocused(mouseX, mouseY), false, Color.ofTransparent(0xFFFFFF | (alphaAsInt << 24)));
        Color darkBackgroundColor = darkBackground.value();
        darkBackgroundColor = Color.ofRGBA(darkBackgroundColor.getRed(), darkBackgroundColor.getGreen(), darkBackgroundColor.getBlue(), (int) Math.round(darkBackgroundColor.getAlpha() * alpha.value()));
        renderBackground(graphics, x, y, width, height, isFocused(mouseX, mouseY), true, darkBackgroundColor);
        
        int color = 0xe0e0e0;
        if (!this.enabled) {
            color = 0xa0a0a0;
        } else if (isFocused(mouseX, mouseY)) {
            color = 0xffffa0;
        }
        
        if (tint != null) {
            graphics.method_25296(x + 1, y + 1, x + width - 1, y + height - 1, tint, tint);
        }
        
        if (alphaAsInt > 10) {
            graphics.method_27534(font, getText(), x + width / 2, y + (height - 8) / 2, color | (alphaAsInt << 24));
        }
        
        class_2561[] tooltip = getTooltip();
        if (tooltip != null) {
            if (!focused && containsMouse(mouseX, mouseY)) {
                Tooltip.create(tooltip).queue();
            } else if (focused) {
                Tooltip.create(new Point(x + width / 2, y + height / 2), tooltip).queue();
            }
        }
    }
    
    protected boolean isFocused(int mouseX, int mouseY) {
        return containsMouse(mouseX, mouseY) || focused;
    }
    
    @Nullable
    @Override
    public class_8016 method_48205(class_8023 event) {
        return enabled && focusable ? class_8016.method_48193(this) : null;
    }
    
    @Override
    public void onClick() {
        Consumer<Button> onClick = getOnClick();
        if (onClick != null)
            onClick.accept(this);
    }
    
    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (containsMouse(mouseX, mouseY) && isEnabled() && button == 0) {
            minecraft.method_1483().method_4873(class_1109.method_47978(class_3417.field_15015, 1.0F));
            onClick();
            return true;
        }
        return false;
    }
    
    @Override
    public boolean method_25404(int int_1, int int_2, int int_3) {
        if (this.isEnabled() && focused) {
            if (int_1 != 257 && int_1 != 32 && int_1 != 335) {
                return false;
            } else {
                minecraft.method_1483().method_4873(class_1109.method_47978(class_3417.field_15015, 1.0F));
                onClick();
                return true;
            }
        }
        return false;
    }
    
    @Override
    public List<? extends class_364> method_25396() {
        return Collections.emptyList();
    }
    
    protected void renderBackground(class_332 graphics, int x, int y, int width, int height, boolean focused) {
        renderBackground(graphics, x, y, width, height, focused, REIRuntime.getInstance().isDarkThemeEnabled(), Color.ofTransparent(0xFFFFFFFF));
    }
    
    protected void renderBackground(class_332 graphics, int x, int y, int width, int height, boolean focused, boolean dark, Color color) {
        class_8666 sprites = dark ? DARK_SPRITES : SPRITES;
        class_2960 texture = sprites.method_52729(this.isEnabled(), focused);
        graphics.method_52707(class_1921::method_62277, texture, x, y, width, height, color.getColor());
    }
}
