/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020, 2021, 2022, 2023 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.impl.client.gui.widget;

import me.shedaniel.math.Point;
import me.shedaniel.rei.api.client.gui.widgets.TooltipContext;
import net.minecraft.class_1792;
import net.minecraft.class_1836;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;

import java.util.Objects;

public class TooltipContextImpl implements TooltipContext {
    private final Point point;
    @Nullable
    private final class_1836 flag;
    private final boolean isSearch;
    private final class_1792.class_9635 vanillaContext;
    
    public TooltipContextImpl(Point point, @Nullable class_1836 flag, boolean isSearch, class_1792.class_9635 vanillaContext) {
        this.point = Objects.requireNonNull(point);
        this.flag = flag;
        this.isSearch = isSearch;
        this.vanillaContext = Objects.requireNonNull(vanillaContext);
    }
    
    @Override
    public class_1836 getFlag() {
        return flag == null ? (class_310.method_1551().field_1690.field_1827 ? class_1836.class_1837.field_41071 : class_1836.class_1837.field_41070)
                : flag;
    }
    
    @Override
    public Point getPoint() {
        return point;
    }
    
    @Override
    public boolean isSearch() {
        return isSearch;
    }
    
    @Override
    public class_1792.class_9635 vanillaContext() {
        return vanillaContext;
    }
}
