/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020, 2021, 2022, 2023 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.impl.client.gui.widget;

import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.DelegateWidget;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.util.MatrixUtils;
import net.minecraft.class_332;
import net.minecraft.class_4590;
import org.joml.Matrix4f;
import org.joml.Vector4f;

import java.util.function.Supplier;

public class DelegateWidgetWithTranslate extends DelegateWidget {
    private final Supplier<Matrix4f> translate;
    
    public DelegateWidgetWithTranslate(WidgetWithBounds widget, Supplier<Matrix4f> translate) {
        super(widget);
        this.translate = translate;
    }
    
    protected Matrix4f translate() {
        return translate.get();
    }
    
    protected final Matrix4f inverseTranslate() {
        return MatrixUtils.inverse(translate());
    }
    
    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        graphics.method_51448().method_22903();
        graphics.method_51448().method_23760().method_23761().mul(translate());
        Vector4f mouse = transformMouse(mouseX, mouseY);
        super.method_25394(graphics, (int) mouse.x(), (int) mouse.y(), delta);
        graphics.method_51448().method_22909();
    }
    
    private Vector4f transformMouse(double mouseX, double mouseY) {
        Vector4f mouse = new Vector4f((float) mouseX, (float) mouseY, 0, 1);
        inverseTranslate().transform(mouse);
        return mouse;
    }
    
    @Override
    public boolean containsMouse(double mouseX, double mouseY) {
        Vector4f mouse = transformMouse(mouseX, mouseY);
        return super.containsMouse(mouse.x(), mouse.y());
    }
    
    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        Vector4f mouse = transformMouse(mouseX, mouseY);
        return super.method_25402(mouse.x(), mouse.y(), button);
    }
    
    @Override
    public boolean method_25406(double mouseX, double mouseY, int button) {
        Vector4f mouse = transformMouse(mouseX, mouseY);
        return super.method_25406(mouse.x(), mouse.y(), button);
    }
    
    @Override
    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        Vector4f mouse = transformMouse(mouseX, mouseY);
        return super.method_25403(mouse.x(), mouse.y(), button, deltaX, deltaY);
    }
    
    @Override
    public boolean method_25401(double mouseX, double mouseY, double amountX, double amountY) {
        Vector4f mouse = transformMouse(mouseX, mouseY);
        return super.method_25401(mouse.x(), mouse.y(), amountX, amountY);
    }
    
    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        try {
            Widget.translateMouse(inverseTranslate());
            return super.method_25404(keyCode, scanCode, modifiers);
        } finally {
            Widget.popMouse();
        }
    }
    
    @Override
    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        try {
            Widget.translateMouse(inverseTranslate());
            return super.method_16803(keyCode, scanCode, modifiers);
        } finally {
            Widget.popMouse();
        }
    }
    
    @Override
    public boolean method_25400(char character, int modifiers) {
        try {
            Widget.translateMouse(inverseTranslate());
            return super.method_25400(character, modifiers);
        } finally {
            Widget.popMouse();
        }
    }
    
    @Override
    public double getZRenderingPriority() {
        class_4590 transformation = new class_4590(translate());
        return transformation.method_35865().z() + super.getZRenderingPriority();
    }
    
    @Override
    public Rectangle getBounds() {
        return MatrixUtils.transform(translate(), super.getBounds());
    }
}
