/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020, 2021, 2022, 2023 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.impl.client.gui.screen.generic;

import com.mojang.blaze3d.systems.RenderSystem;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.impl.client.gui.widget.UpdatedListWidget;
import net.minecraft.class_1109;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_6379;
import net.minecraft.class_8016;
import net.minecraft.class_8023;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public abstract class OptionEntriesScreen extends class_437 {
    private ListWidget listWidget;
    public class_437 parent;
    
    public OptionEntriesScreen(class_2561 title, class_437 screen) {
        super(title);
        this.parent = screen;
    }
    
    @Override
    public void method_25426() {
        super.method_25426();
        if (listWidget != null) save();
        {
            class_2561 doneText = class_2561.method_43471("gui.done");
            int width = class_310.method_1551().field_1772.method_27525(doneText);
            method_37063(new class_4185(this.field_22789 - 4 - width - 10, 4, width + 10, 20, doneText, button -> {
                save();
                field_22787.method_1507(parent);
            }, Supplier::get) {
            });
        }
        listWidget = method_25429(new ListWidget(field_22787, field_22789, field_22790, 30, field_22790));
        addEntries(ruleEntry -> listWidget.addItem(ruleEntry));
    }
    
    @Override
    public void method_25419() {
        this.field_22787.method_1507(parent);
    }
    
    public abstract void addEntries(Consumer<ListEntry> entryConsumer);
    
    public abstract void save();
    
    public void addText(Consumer<ListEntry> entryConsumer, class_5348 text) {
        for (class_5481 s : field_22793.method_1728(text, field_22789 - 80)) {
            entryConsumer.accept(new TextListEntry(s));
        }
    }
    
    public void addEmpty(Consumer<ListEntry> entryConsumer, int height) {
        entryConsumer.accept(new EmptyListEntry(height));
    }
    
    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        super.method_25394(graphics, mouseX, mouseY, delta);
        this.listWidget.method_25394(graphics, mouseX, mouseY, delta);
        graphics.method_35720(this.field_22793, this.field_22785.method_30937(), (int) (this.field_22789 / 2.0F - this.field_22793.method_27525(this.field_22785) / 2.0F), 12, -1);
    }
    
    public static class ListWidget extends UpdatedListWidget<ListEntry> {
        public ListWidget(class_310 client, int width, int height, int top, int bottom) {
            super(client, width, height, top, bottom);
        }
        
        @Override
        protected int addItem(ListEntry item) {
            return super.addItem(item);
        }
        
        @Override
        public int getItemWidth() {
            return width - 40;
        }
        
        @Override
        protected int getScrollbarPosition() {
            return width - 14;
        }
    }
    
    public static abstract class ListEntry extends UpdatedListWidget.ElementEntry<ListEntry> {
    }
    
    public static class TextListEntry extends ListEntry {
        private final class_5481 text;
        
        public TextListEntry(class_5481 text) {
            this.text = text;
        }
        
        @Override
        public void render(class_332 graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
            graphics.method_35720(class_310.method_1551().field_1772, text, x + 5, y, -1);
        }
        
        @Override
        public int getItemHeight() {
            return 12;
        }
        
        @Override
        public List<? extends class_364> method_25396() {
            return Collections.emptyList();
        }
        
        @Override
        public List<? extends class_6379> narratables() {
            return Collections.emptyList();
        }
    }
    
    public static class EmptyListEntry extends ListEntry {
        private final int height;
        
        public EmptyListEntry(int height) {
            this.height = height;
        }
        
        @Override
        public void render(class_332 graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
        }
        
        @Override
        public int getItemHeight() {
            return height;
        }
        
        @Override
        public List<? extends class_364> method_25396() {
            return Collections.emptyList();
        }
        
        @Override
        public List<? extends class_6379> narratables() {
            return Collections.emptyList();
        }
    }
    
    public static class TextFieldListEntry extends ListEntry {
        private final class_342 widget;
        
        public TextFieldListEntry(int width, Consumer<class_342> widgetConsumer) {
            this.widget = new class_342(class_310.method_1551().field_1772, 0, 0, width, 18, class_2561.method_30163(""));
            widgetConsumer.accept(widget);
        }
        
        @Override
        public void render(class_332 graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
            widget.method_46421(x + 2);
            widget.method_46419(y + 2);
            widget.method_25394(graphics, mouseX, mouseY, delta);
        }
        
        @Override
        public int getItemHeight() {
            return 20;
        }
        
        public class_342 getWidget() {
            return widget;
        }
        
        @Override
        public List<? extends class_364> method_25396() {
            return Collections.singletonList(widget);
        }
        
        @Override
        public List<? extends class_6379> narratables() {
            return Collections.singletonList(widget);
        }
    }
    
    public static class ButtonListEntry extends ListEntry {
        private final class_4185 widget;
        
        public ButtonListEntry(int width, Function<ButtonListEntry, class_2561> textFunction, BiConsumer<ButtonListEntry, class_4185> buttonConsumer) {
            this.widget = new class_4185(0, 0, 100, 20, textFunction.apply(this), button -> {
                buttonConsumer.accept(this, button);
                button.method_25355(textFunction.apply(this));
            }, Supplier::get) {
            };
        }
        
        @Override
        public void render(class_332 graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
            widget.method_46421(x + 2);
            widget.method_46419(y);
            widget.method_25394(graphics, mouseX, mouseY, delta);
        }
        
        @Override
        public int getItemHeight() {
            return 20;
        }
        
        @Override
        public List<? extends class_364> method_25396() {
            return Collections.singletonList(widget);
        }
        
        @Override
        public List<? extends class_6379> narratables() {
            return Collections.singletonList(widget);
        }
    }
    
    public static class BooleanListEntry extends ButtonListEntry {
        private Boolean b;
        
        public BooleanListEntry(int width, boolean b, Function<Boolean, class_2561> textFunction) {
            super(width, self -> {
                if (((BooleanListEntry) self).b == null) ((BooleanListEntry) self).b = b;
                return textFunction.apply(((BooleanListEntry) self).b);
            }, (self, button) -> {
                ((BooleanListEntry) self).b = !((BooleanListEntry) self).b;
            });
        }
        
        public boolean getBoolean() {
            return b;
        }
    }
    
    public static class SubListEntry extends ListEntry {
        private static final class_2960 CONFIG_TEX = class_2960.method_60655("cloth-config2", "textures/gui/cloth_config.png");
        private final CategoryLabelWidget widget;
        private final List<ListEntry> rules;
        private final List<class_364> children;
        private boolean expanded;
        private Supplier<class_2561> name;
        
        public SubListEntry(Supplier<class_2561> name, List<ListEntry> rules) {
            this.rules = rules;
            this.widget = new CategoryLabelWidget();
            this.name = name;
            this.expanded = true;
            this.children = new ArrayList<>(rules);
            this.children.add(widget);
        }
        
        public List<ListEntry> getRules() {
            return rules;
        }
        
        @Override
        public void render(class_332 graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
            RenderSystem.setShaderColor(1.0F, 1.0F, 1.0F, 1.0F);
            this.widget.rectangle.x = x + 3;
            this.widget.rectangle.y = y;
            this.widget.rectangle.width = entryWidth - 6;
            this.widget.rectangle.height = 24;
            graphics.method_25290(class_1921::method_62277, CONFIG_TEX, x + 3, y + 5, 24, (this.widget.rectangle.contains(mouseX, mouseY) ? 18 : 0) + (this.expanded ? 9 : 0), 9, 9, 256, 256);
            graphics.method_35720(class_310.method_1551().field_1772, this.name.get().method_30937(), x + 3 + 15, y + 6, this.widget.rectangle.contains(mouseX, mouseY) ? -1638890 : -1);
            
            for (ListEntry performanceEntry : this.rules) {
                performanceEntry.setParent(this.getParent());
            }
            
            if (this.expanded) {
                int yy = y + 24;
                
                ListEntry entry;
                for (Iterator<ListEntry> iterator = this.rules.iterator(); iterator.hasNext(); yy += entry.getItemHeight()) {
                    entry = iterator.next();
                    entry.render(graphics, -1, yy, x + 3 + 15, entryWidth - 15 - 3, entry.getItemHeight(), mouseX, mouseY, isHovered && this.method_25399() == entry, delta);
                }
            }
        }
        
        @Override
        public int getMorePossibleHeight() {
            if (!this.expanded) {
                return -1;
            } else {
                List<Integer> list = new ArrayList<>();
                int i = 24;
                
                for (ListEntry entry : this.rules) {
                    i += entry.getItemHeight();
                    if (entry.getMorePossibleHeight() >= 0) {
                        list.add(i + entry.getMorePossibleHeight());
                    }
                }
                
                list.add(i);
                return list.stream().max(Integer::compare).orElse(0) - this.getItemHeight();
            }
        }
        
        @Override
        public int getItemHeight() {
            if (!this.expanded) {
                return 24;
            } else {
                int i = 24;
                
                ListEntry entry;
                for (Iterator<ListEntry> iterator = this.rules.iterator(); iterator.hasNext(); i += entry.getItemHeight()) {
                    entry = iterator.next();
                }
                
                return i;
            }
        }
        
        @Override
        public List<? extends class_364> method_25396() {
            return children;
        }
        
        @Override
        public List<? extends class_6379> narratables() {
            return Collections.emptyList();
        }
        
        public class CategoryLabelWidget implements class_364 {
            private final Rectangle rectangle = new Rectangle();
            
            public CategoryLabelWidget() {
            }
            
            @Override
            public boolean method_25402(double mouseX, double mouseY, int button) {
                if (this.rectangle.contains(mouseX, mouseY)) {
                    SubListEntry.this.expanded = !SubListEntry.this.expanded;
                    class_310.method_1551().method_1483().method_4873(class_1109.method_47978(class_3417.field_15015, 1.0F));
                    return true;
                } else {
                    return false;
                }
            }
            
            @Nullable
            @Override
            public class_8016 method_48205(class_8023 event) {
                return null;
            }
            
            @Override
            public void method_25365(boolean bl) {
            }
            
            @Override
            public boolean method_25370() {
                return false;
            }
        }
    }
}
