/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020, 2021, 2022, 2023 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.impl.client.gui.screen.collapsible;

import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.scroll.ScrollingContainer;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.config.entry.EntryStackProvider;
import me.shedaniel.rei.api.client.gui.widgets.CloseableScissors;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.registry.entry.CollapsibleEntryRegistry;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.config.collapsible.CollapsibleConfigManager;
import me.shedaniel.rei.impl.client.gui.ScreenOverlayImpl;
import me.shedaniel.rei.impl.client.gui.screen.collapsible.selection.CustomCollapsibleEntrySelectionScreen;
import me.shedaniel.rei.impl.client.gui.screen.generic.OptionEntriesScreen;
import me.shedaniel.rei.impl.client.gui.widget.UpdatedListWidget;
import me.shedaniel.rei.impl.common.entry.type.EntryRegistryImpl;
import me.shedaniel.rei.impl.common.entry.type.collapsed.CollapsibleEntryRegistryImpl;
import me.shedaniel.rei.impl.common.util.HashedEntryStackWrapper;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.joml.Matrix4f;

import java.util.*;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class CollapsibleEntriesScreen extends class_437 {
    private final Runnable onClose;
    private final CollapsibleConfigManager.CollapsibleConfigObject configObject;
    private final List<CollapsibleEntryWidget> widgets = new ArrayList<>();
    private ListWidget listWidget;
    private boolean dirty = true;
    
    public CollapsibleEntriesScreen(Runnable onClose, CollapsibleConfigManager.CollapsibleConfigObject configObject) {
        super(class_2561.method_43471("text.rei.collapsible.entries.title"));
        this.onClose = onClose;
        this.configObject = configObject;
        this.prepareWidgets(configObject);
    }
    
    public void prepareWidgets(CollapsibleConfigManager.CollapsibleConfigObject configObject) {
        this.widgets.clear();
        
        for (CollapsibleConfigManager.CustomGroup customEntry : configObject.customGroups) {
            this.widgets.add(new CollapsibleEntryWidget(true, customEntry.id, class_2561.method_43470(customEntry.name),
                    CollectionUtils.filterAndMap(customEntry.stacks, EntryStackProvider::isValid, EntryStackProvider::provide), configObject,
                    () -> {
                        this.prepareWidgets(configObject);
                        this.dirty = true;
                    }));
        }
        
        CollapsibleEntryRegistryImpl collapsibleRegistry = (CollapsibleEntryRegistryImpl) CollapsibleEntryRegistry.getInstance();
        Multimap<class_2960, EntryStack<?>> entries = Multimaps.newListMultimap(new HashMap<>(), ArrayList::new);
        for (HashedEntryStackWrapper wrapper : ((EntryRegistryImpl) EntryRegistry.getInstance()).getFilteredList().getList()) {
            for (CollapsibleEntryRegistryImpl.Entry entry : collapsibleRegistry.getEntries()) {
                if (entry.getMatcher().matches(wrapper.unwrap(), wrapper.hashExact())) {
                    entries.put(entry.getId(), wrapper.unwrap());
                }
            }
        }
        
        for (CollapsibleEntryRegistryImpl.Entry entry : collapsibleRegistry.getEntries()) {
            this.widgets.add(new CollapsibleEntryWidget(false, entry.getId(), entry.getName(), entries.get(entry.getId()), configObject,
                    () -> {
                        this.prepareWidgets(configObject);
                        this.dirty = true;
                    }));
        }
    }
    
    @Override
    public void method_25426() {
        super.method_25426();
        {
            class_2561 backText = class_2561.method_43470("↩ ").method_10852(class_2561.method_43471("gui.back"));
            method_37063(new class_4185(4, 4, field_22793.method_27525(backText) + 10, 20, backText,
                    button -> this.method_25419(), Supplier::get) {
            });
        }
        {
            class_2561 addText = class_2561.method_43470(" + ");
            method_37063(new class_4185(field_22789 - 4 - 20, 4, 20, 20, addText, $ -> {
                setupCustom(class_2960.method_60654("custom:" + UUID.randomUUID()), "", new ArrayList<>(), this.configObject, () -> {
                    this.prepareWidgets(configObject);
                    this.dirty = true;
                });
            }, Supplier::get) {
            });
        }
        
        this.listWidget = new ListWidget(field_22789, field_22790, 30);
        ((List<class_364>) this.method_25396()).add(this.listWidget);
        this.dirty = true;
    }
    
    public static void setupCustom(class_2960 id, String name, List<EntryStack<?>> stacks, CollapsibleConfigManager.CollapsibleConfigObject configObject, Runnable markDirty) {
        class_310.method_1551().method_1507(new OptionEntriesScreen(class_2561.method_43471("text.rei.collapsible.entries.custom.title"), class_310.method_1551().field_1755) {
            private TextFieldListEntry entry;
            
            @Override
            public void addEntries(Consumer<ListEntry> entryConsumer) {
                addEmpty(entryConsumer, 10);
                addText(entryConsumer, class_2561.method_43471("text.rei.collapsible.entries.custom.id").method_27692(class_124.field_1080)
                        .method_10852(class_2561.method_43470(" " + id).method_27692(class_124.field_1063)));
                addEmpty(entryConsumer, 10);
                addText(entryConsumer, class_2561.method_43471("text.rei.collapsible.entries.custom.name").method_27692(class_124.field_1080));
                entryConsumer.accept(this.entry = new TextFieldListEntry(field_22789 - 36, widget -> {
                    widget.method_1880(40);
                    if (this.entry != null) widget.method_1852(this.entry.getWidget().method_1882());
                    else widget.method_1852(name);
                }));
                addEmpty(entryConsumer, 10);
                entryConsumer.accept(new ButtonListEntry(field_22789 - 36, $ -> class_2561.method_43471("text.rei.collapsible.entries.custom.select"), ($, button) -> {
                    CustomCollapsibleEntrySelectionScreen screen = new CustomCollapsibleEntrySelectionScreen(stacks);
                    screen.parent = this.field_22787.field_1755;
                    this.field_22787.method_1507(screen);
                }));
            }
            
            @Override
            public void save() {
                configObject.customGroups.removeIf(customGroup -> customGroup.id.equals(id));
                configObject.customGroups.add(new CollapsibleConfigManager.CustomGroup(id, this.entry.getWidget().method_1882(),
                        CollectionUtils.map(stacks, EntryStackProvider::ofStack)));
                markDirty.run();
            }
        });
    }
    
    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        if (this.dirty) {
            this.listWidget.clear();
            
            for (CollapsibleEntryWidget widget : this.widgets) {
                this.listWidget.add(widget);
            }
            
            this.dirty = false;
        }
        
        super.method_25394(graphics, mouseX, mouseY, delta);
        this.listWidget.method_25394(graphics, mouseX, mouseY, delta);
        graphics.method_27535(this.field_22793, this.field_22785, this.field_22789 / 2 - this.field_22793.method_27525(this.field_22785) / 2, 12, -1);
        
        if (ConfigObject.getInstance().doDebugRenderTimeRequired()) {
            class_2561 debugText = class_2561.method_43470(String.format("%s fps", field_22787.field_1770.split(" ")[0]));
            int stringWidth = field_22793.method_27525(debugText);
            graphics.method_25296(field_22787.field_1755.field_22789 - stringWidth - 2, 32, field_22787.field_1755.field_22789, 32 + field_22793.field_2000 + 2, -16777216, -16777216);
            graphics.method_51448().method_22903();
            graphics.method_64039(source -> {
                Matrix4f matrix = graphics.method_51448().method_23760().method_23761();
                field_22793.method_22942(debugText.method_30937(), field_22787.field_1755.field_22789 - stringWidth, 32 + 2, -1, false, matrix, source, class_327.class_6415.field_33993, 0, 15728880);
            });
            graphics.method_51452();
            graphics.method_51448().method_22909();
        }
    }
    
    @Override
    public void method_25420(class_332 graphics, int mouseX, int mouseY, float delta) {
        super.method_25420(graphics, mouseX, mouseY, delta);
        UpdatedListWidget.renderAs(field_22787, this.field_22789, this.field_22790, this.listWidget.top, this.field_22790, graphics, delta);
    }
    
    @Override
    public boolean method_25401(double mouseX, double mouseY, double amountX, double amountY) {
        return this.listWidget.method_25401(mouseX, mouseY, amountX, amountY) || super.method_25401(mouseX, mouseY, amountX, amountY);
    }
    
    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        return this.listWidget.method_25402(mouseX, mouseY, button) || super.method_25402(mouseX, mouseY, button);
    }
    
    @Override
    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return this.listWidget.method_25403(mouseX, mouseY, button, deltaX, deltaY) || super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }
    
    @Override
    public void method_25419() {
        this.onClose.run();
    }
    
    private static class ListWidget extends Widget {
        private static final int PADDING = 6;
        private final int width;
        private final int height;
        private final int top;
        private final ScrollingContainer scroller = new ScrollingContainer() {
            @Override
            public Rectangle getBounds() {
                return new Rectangle(0, top, width, height - top);
            }
            
            @Override
            public int getMaxScrollHeight() {
                return getMaxScrollDist();
            }
        };
        private final List<CollapsibleEntryWidget>[] columns;
        private final List<CollapsibleEntryWidget> children = new ArrayList<>();
        
        public ListWidget(int width, int height, int top) {
            this.width = width;
            this.height = height;
            this.top = top;
            this.columns = new List[Math.max(1, (width - 12 - PADDING) / (130 + PADDING))];
            for (int i = 0; i < columns.length; i++) {
                columns[i] = new ArrayList<>();
            }
        }
        
        @Override
        public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
            this.scroller.updatePosition(delta);
            
            try (CloseableScissors scissors = scissor(graphics, new Rectangle(0, this.top, this.width - 6, this.height - this.top))) {
                int entryWidth = (this.width - 12 - 6 - PADDING) / this.columns.length - PADDING;
                for (int i = 0; i < this.columns.length; i++) {
                    int x = 6 + PADDING + i * (entryWidth + PADDING);
                    int y = this.top + PADDING - scroller.scrollAmountInt();
                    for (CollapsibleEntryWidget widget : this.columns[i]) {
                        widget.setPosition(x, y);
                        widget.setWidth(entryWidth);
                        widget.method_25394(graphics, mouseX, mouseY, delta);
                        y += widget.getHeight() + PADDING;
                    }
                }
            }
            
            this.scroller.renderScrollBar(graphics);
            
            ScreenOverlayImpl.getInstance().lateRender(graphics, mouseX, mouseY, delta);
        }
        
        private int getMaxScrollDist() {
            return Arrays.stream(this.columns).mapToInt(ListWidget::getHeightOf)
                    .max()
                    .orElse(0)
                    + PADDING * 2;
        }
        
        @Override
        public List<? extends class_364> method_25396() {
            return children;
        }
        
        @Override
        public boolean method_25401(double mouseX, double mouseY, double amountX, double amountY) {
            for (CollapsibleEntryWidget widget : children) {
                if (widget.method_25401(mouseX, mouseY, amountX, amountY)) {
                    return true;
                }
            }
            if (mouseY > this.top && amountY != 0) {
                this.scroller.offset(ClothConfigInitializer.getScrollStep() * -amountY, true);
                return true;
            } else {
                return false;
            }
        }
        
        @Override
        public boolean method_25402(double mouseX, double mouseY, int button) {
            return this.scroller.updateDraggingState(mouseX, mouseY, button) || super.method_25402(mouseX, mouseY, button);
        }
        
        @Override
        public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
            return this.scroller.mouseDragged(mouseX, mouseY, button, deltaX, deltaY) || super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
        }
        
        public void clear() {
            this.children.clear();
            for (List<CollapsibleEntryWidget> column : columns) {
                column.clear();
            }
        }
        
        public void add(CollapsibleEntryWidget widget) {
            Arrays.stream(columns)
                    .min(Comparator.comparingInt(ListWidget::getHeightOf))
                    .ifPresent(widgets -> widgets.add(widget));
            this.children.add(widget);
        }
        
        private static int getHeightOf(List<CollapsibleEntryWidget> widgets) {
            int height = 0;
            for (CollapsibleEntryWidget w : widgets) {
                height += w.getHeight() + PADDING;
            }
            return Math.max(0, height - PADDING);
        }
    }
}
