/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020, 2021, 2022, 2023 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.plugin.common.displays;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import net.minecraft.class_2487;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import java.util.List;

public class DefaultFuelDisplay extends BasicDisplay {
    public static final DisplaySerializer<DefaultFuelDisplay> SERIALIZER = DisplaySerializer.of(
            RecordCodecBuilder.mapCodec(instance -> instance.group(
                    EntryIngredient.codec().listOf().fieldOf("inputs").forGetter(DefaultFuelDisplay::getInputEntries),
                    EntryIngredient.codec().listOf().fieldOf("outputs").forGetter(DefaultFuelDisplay::getOutputEntries),
                    Codec.INT.fieldOf("fuelTime").forGetter(DefaultFuelDisplay::getFuelTime)
            ).apply(instance, DefaultFuelDisplay::new)),
            class_9139.method_56436(
                    EntryIngredient.streamCodec().method_56433(class_9135.method_56363()),
                    DefaultFuelDisplay::getInputEntries,
                    EntryIngredient.streamCodec().method_56433(class_9135.method_56363()),
                    DefaultFuelDisplay::getOutputEntries,
                    class_9135.field_49675,
                    DefaultFuelDisplay::getFuelTime,
                    DefaultFuelDisplay::new
            ));
    
    private final int fuelTime;
    
    public DefaultFuelDisplay(List<EntryIngredient> inputs, List<EntryIngredient> outputs, class_2487 tag) {
        this(inputs, outputs, tag.method_10550("fuelTime"));
    }
    
    public DefaultFuelDisplay(List<EntryIngredient> inputs, List<EntryIngredient> outputs, int fuelTime) {
        super(inputs, outputs);
        this.fuelTime = fuelTime;
    }
    
    @Override
    public CategoryIdentifier<?> getCategoryIdentifier() {
        return BuiltinPlugin.FUEL;
    }
    
    @Override
    public DisplaySerializer<? extends Display> getSerializer() {
        return SERIALIZER;
    }
    
    public int getFuelTime() {
        return fuelTime;
    }
}
