/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020, 2021, 2022, 2023 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.plugin.common.displays;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3920;
import net.minecraft.class_8786;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import java.util.List;
import java.util.Optional;
import java.util.OptionalDouble;

public class DefaultCampfireDisplay extends BasicDisplay implements CampfireDisplay {
    public static final DisplaySerializer<DefaultCampfireDisplay> SERIALIZER = DisplaySerializer.of(
            RecordCodecBuilder.mapCodec(instance -> instance.group(
                    EntryIngredient.codec().listOf().fieldOf("inputs").forGetter(DefaultCampfireDisplay::getInputEntries),
                    EntryIngredient.codec().listOf().fieldOf("outputs").forGetter(DefaultCampfireDisplay::getOutputEntries),
                    class_2960.field_25139.optionalFieldOf("location").forGetter(DefaultCampfireDisplay::getDisplayLocation),
                    Codec.DOUBLE.fieldOf("cookTime").forGetter(d -> d.cookTime)
            ).apply(instance, DefaultCampfireDisplay::new)),
            class_9139.method_56905(
                    EntryIngredient.streamCodec().method_56433(class_9135.method_56363()),
                    DefaultCampfireDisplay::getInputEntries,
                    EntryIngredient.streamCodec().method_56433(class_9135.method_56363()),
                    DefaultCampfireDisplay::getOutputEntries,
                    class_9135.method_56382(class_2960.field_48267),
                    DefaultCampfireDisplay::getDisplayLocation,
                    class_9135.field_48553,
                    d -> d.cookTime,
                    DefaultCampfireDisplay::new
            ));
    
    private final double cookTime;
    
    public DefaultCampfireDisplay(class_8786<class_3920> recipe) {
        this(List.of(EntryIngredients.ofIngredient(recipe.comp_1933().method_64720())),
                List.of(EntryIngredients.of(recipe.comp_1933().method_64721())),
                Optional.of(recipe.comp_1932().method_29177()), recipe.comp_1933().method_8167());
    }
    
    public DefaultCampfireDisplay(List<EntryIngredient> inputs, List<EntryIngredient> outputs, Optional<class_2960> location, class_2487 tag) {
        this(inputs, outputs, location, tag.method_10574("cookTime"));
    }
    
    public DefaultCampfireDisplay(List<EntryIngredient> inputs, List<EntryIngredient> outputs, Optional<class_2960> location, double cookTime) {
        super(inputs, outputs, location);
        this.cookTime = cookTime;
    }
    
    @Override
    public OptionalDouble cookTime() {
        return OptionalDouble.of(cookTime);
    }
    
    @Override
    public CategoryIdentifier<?> getCategoryIdentifier() {
        return BuiltinPlugin.CAMPFIRE;
    }
    
    @Override
    public DisplaySerializer<? extends Display> getSerializer() {
        return SERIALIZER;
    }
}
