/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020, 2021, 2022, 2023 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.plugin.client.categories.crafting.filler;

import com.mojang.datafixers.util.Pair;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.plugin.common.displays.crafting.DefaultCustomShapelessDisplay;
import net.minecraft.class_1746;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1872;
import net.minecraft.class_2378;
import net.minecraft.class_2582;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8786;
import net.minecraft.class_9307;
import net.minecraft.class_9334;
import net.minecraft.world.item.*;
import java.util.*;

public class ShieldDecorationRecipeFiller implements CraftingRecipeFiller<class_1872> {
    static List<Pair<class_1767, class_1799>> randomizeBanners() {
        List<Pair<class_1767, class_1799>> out = new ArrayList<>();
        class_1767[] colors = class_1767.values();
        Random random = new Random();
        
        for (class_1767 color : colors) {
            Optional<class_1792> bannerOptional = class_7923.field_41178.method_17966(class_2960.method_60654(color.method_7792() + "_banner"));
            if (bannerOptional.isEmpty()) continue;
            out.add(Pair.of(color, new class_1799(bannerOptional.get())));
            
            for (int i = 0; i < 2; i++) {
                List<class_9307.class_9308> layers = new ArrayList<>();
                Optional<class_2378<class_2582>> registry = BasicDisplay.registryAccess().method_46759(class_7924.field_41252);
                if (registry.isEmpty()) return Collections.emptyList();
                class_6880<class_2582>[] allPatterns = registry.get().method_42017().toArray(class_6880[]::new);
                for (int j = 0; j < 2; j++) {
                    class_6880<class_2582> pattern = allPatterns[random.nextInt(allPatterns.length - 1) + 1];
                    layers.add(new class_9307.class_9308(pattern, colors[random.nextInt(colors.length)]));
                }
                class_1799 banner = new class_1799(bannerOptional.get());
                banner.method_57379(class_9334.field_49619, new class_9307(layers));
                out.add(Pair.of(color, banner));
            }
        }
        
        return out;
    }
    
    @Override
    public Collection<Display> apply(class_8786<class_1872> recipe) {
        List<Display> displays = new ArrayList<>();
        EntryIngredient shield = EntryIngredients.of(class_1802.field_8255);
        EntryIngredient.Builder inputsBuilder = EntryIngredient.builder();
        EntryIngredient.Builder outputsBuilder = EntryIngredient.builder();
        
        for (Pair<class_1767, class_1799> pair : randomizeBanners()) {
            inputsBuilder.add(EntryStacks.of(pair.getSecond()));
            outputsBuilder.add(createOutput(pair.getFirst(), pair.getSecond()));
        }
        
        EntryIngredient inputs = inputsBuilder.build();
        EntryIngredient outputs = outputsBuilder.build();
        
        EntryIngredient.unifyFocuses(inputs, outputs);
        
        displays.add(new DefaultCustomShapelessDisplay(
                List.of(inputs, shield),
                List.of(outputs),
                Optional.of(recipe.comp_1932().method_29177())));
        
        return displays;
    }
    
    private static EntryStack<class_1799> createOutput(class_1767 color, class_1799 banner) {
        class_1799 output = new class_1799(class_1802.field_8255);
        output.method_57379(class_9334.field_49619, banner.method_57824(class_9334.field_49619));
        output.method_57379(class_9334.field_49620, ((class_1746) banner.method_7909()).method_7706());
        return EntryStacks.of(output);
    }
    
    @Override
    public Class<class_1872> getRecipeClass() {
        return class_1872.class;
    }
}
