/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020, 2021, 2022, 2023 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.impl.client.gui.widget.hint;

import com.mojang.blaze3d.systems.RenderSystem;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.animator.NumberAnimator;
import me.shedaniel.clothconfig2.api.animator.ValueAnimator;
import me.shedaniel.clothconfig2.api.scroll.ScrollingContainer;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.CloseableScissors;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.gui.ScreenOverlayImpl;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;

public class HintWidget extends WidgetWithBounds {
    private static final int MAX_WIDTH = 180;
    private static final int MAX_HEIGHT = 130;
    private final HintsContainerWidget parent;
    private final Rectangle bounds = new Rectangle();
    private final Rectangle okayBounds = new Rectangle();
    private final int margin;
    private final Supplier<Point> point;
    private final String uuid;
    private final Collection<? extends class_5348> lines;
    private List<List<class_5481>> wrapped;
    private final NumberAnimator<Double> scroll = ValueAnimator.ofDouble(0);
    private int contentHeight;
    
    public HintWidget(HintsContainerWidget parent, int margin, Supplier<Point> point, String uuid, Collection<? extends class_5348> lines) {
        this.parent = parent;
        this.margin = margin;
        this.point = point;
        this.uuid = uuid;
        this.lines = lines;
        recalculateBounds();
    }
    
    void recalculateBounds() {
        int screenWidth = minecraft.method_22683().method_4486();
        int screenHeight = minecraft.method_22683().method_4507();
        int width = class_3532.method_15340(CollectionUtils.<class_5348, Integer>mapAndMax((Collection<class_5348>) lines,
                        l -> CollectionUtils.max(font.method_1728(l, MAX_WIDTH - 8),
                                        Comparator.comparingLong(value -> font.method_30880(value) + 8))
                                .map(value -> font.method_30880(value) + 8).orElse(0),
                        Comparator.naturalOrder())
                .orElse(0), 60, MAX_WIDTH);
        Point point = this.point.get();
        int spaceLeft = Math.max(point.x - 4, 0);
        int spaceRight = Math.max(screenWidth - point.x - 4, 0);
        this.bounds.width = Math.min(width, Math.max(spaceLeft, spaceRight));
        if (spaceRight >= spaceLeft) {
            this.bounds.x = point.x + margin;
        } else {
            this.bounds.x = point.x - margin - this.bounds.width;
        }
        this.wrapped = CollectionUtils.map(lines, l -> font.method_1728(l, this.bounds.width - 8));
        int height = 8 + 9;
        for (List<class_5481> formattedCharSequences : wrapped) {
            height += formattedCharSequences.size() * 9;
            height += 2;
        }
        this.contentHeight = height - 9 - 2;
        this.bounds.height = Math.min(height, MAX_HEIGHT);
        this.bounds.y = class_3532.method_15340(point.y + margin - this.bounds.height, 4, screenHeight - this.bounds.height - 4);
    }
    
    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }
    
    public String getUuid() {
        return uuid;
    }
    
    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        this.scroll.setTarget(ScrollingContainer.handleBounceBack(scroll.target(), this.contentHeight - (this.bounds.height - 8 - 9) - 9, delta, .08));
        this.scroll.update(delta);
        
        graphics.method_51448().method_22903();
        int background = 0xf0100010;
        int color1 = 0x505000ff;
        int color2 = color1;
        int x = this.bounds.x, y = this.bounds.y, width = this.bounds.width, height = this.bounds.height;
        graphics.method_33284(x, y - 1, x + width, y, 400, background, background);
        graphics.method_33284(x, y + height, x + width, y + height + 1, 400, background, background);
        graphics.method_33284(x, y, x + width, y + height, 400, background, background);
        graphics.method_33284(x - 1, y, x, y + height, 400, background, background);
        graphics.method_33284(x + width, y, x + width + 1, y + height, 400, background, background);
        graphics.method_33284(x, y + 1, x + 1, y + height - 1, 400, color1, color2);
        graphics.method_33284(x + width - 1, y + 1, x + width, y + height - 1, 400, color1, color2);
        graphics.method_33284(x, y, x + width, y + 1, 400, color1, color1);
        graphics.method_33284(x, y + height - 1, x + width, y + height, 400, color2, color2);
        graphics.method_51448().method_22909();
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416(0, 0, 450);
        int lineY = y + 4;
        
        try (CloseableScissors scissors = Widget.scissor(graphics, new Rectangle(x + 4, y + 4, width - 8, height - 8 - 9 - 2))) {
            for (List<class_5481> block : wrapped) {
                for (class_5481 line : block) {
                    graphics.method_35720(font, line, x + 4, lineY - scroll.intValue(), 0xFFFFFFFF);
                    lineY += 9;
                }
                
                lineY += 2;
            }
        }
        
        class_5250 okay = class_2561.method_43471("gui.ok");
        int okayWidth = font.method_27525(okay);
        int midPoint = x + 4 + (width - 4) / 2;
        this.okayBounds.setBounds(midPoint - okayWidth / 2, lineY, okayWidth, 9);
        if (this.okayBounds.contains(mouseX, mouseY)) {
            okay = okay.method_27692(class_124.field_1073);
        }
        graphics.method_27535(font, okay, this.okayBounds.x, this.okayBounds.y, 0xFF999999);
        
        graphics.method_51448().method_22909();
        
        if (this.bounds.contains(mouseX, mouseY)) {
            ScreenOverlayImpl.getInstance().clearTooltips();
        }
    }
    
    @Override
    public List<? extends class_364> method_25396() {
        return List.of();
    }
    
    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.okayBounds.contains(mouseX, mouseY)) {
            this.parent.removeHint(this);
            Widgets.produceClickSound();
            return true;
        }
        
        return super.method_25402(mouseX, mouseY, button);
    }
    
    @Override
    public boolean method_25401(double mouseX, double mouseY, double amountX, double amountY) {
        if (containsMouse(mouseX, mouseY) && amountY != 0) {
            scroll.setTo(scroll.target() + ClothConfigInitializer.getScrollStep() * amountY * (getBounds().getWidth() / -50.0), ClothConfigInitializer.getScrollDuration());
            return true;
        }
        
        return super.method_25401(mouseX, mouseY, amountX, amountY);
    }
}
