/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020, 2021, 2022, 2023 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.impl.client.gui.fabric;

import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.impl.ClientInternals;
import me.shedaniel.rei.impl.client.gui.ScreenOverlayImpl;
import net.minecraft.class_2477;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import net.minecraft.class_8001;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ScreenOverlayImplFabric extends ScreenOverlayImpl {
    @Override
    public void renderTooltipInner(class_437 screen, class_332 graphics, Tooltip tooltip, int mouseX, int mouseY) {
        List<class_5684> lines = tooltip.entries().stream()
                .flatMap(component -> {
                    if (component.isText()) {
                        List<class_5348> texts = class_310.method_1551().field_1772.method_27527().method_27495(component.getAsText(), 100000, class_2583.field_24360);
                        Stream<class_5481> sequenceStream = texts.isEmpty() ? Stream.of(component.getAsText().method_30937())
                                : texts.stream().map(class_2477.method_10517()::method_30934);
                        return sequenceStream.map(class_5684::method_32662);
                    } else {
                        return Stream.empty();
                    }
                })
                .collect(Collectors.toList());
        for (Tooltip.Entry entry : tooltip.entries()) {
            if (entry.isTooltipComponent()) {
                class_5632 component = entry.getAsTooltipComponent();
                
                if (component instanceof class_5684 client) {
                    lines.add(client);
                    continue;
                }
                
                try {
                    ClientInternals.getClientTooltipComponent(lines, component);
                } catch (Throwable exception) {
                    throw new IllegalArgumentException("Failed to add tooltip component! " + component + ", Class: " + (component == null ? null : component.getClass().getCanonicalName()), exception);
                }
            }
        }
        renderTooltipInner(graphics, lines, tooltip.getX(), tooltip.getY(), tooltip.getTooltipStyle());
    }
    
    public static void renderTooltipInner(class_332 graphics, List<class_5684> lines, int mouseX, int mouseY, @Nullable class_2960 tooltipStyle) {
        if (lines.isEmpty()) {
            return;
        }
        graphics.method_51448().method_22903();
        graphics.method_51435(class_310.method_1551().field_1772, lines, mouseX, mouseY, class_8001.field_41687, tooltipStyle);
        graphics.method_51448().method_22909();
    }
}
