/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020, 2021, 2022, 2023 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.impl.client.gui.error;

import me.shedaniel.rei.impl.client.gui.error.ErrorsEntryListWidget.TextEntry;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_424;
import net.minecraft.class_4264;
import net.minecraft.class_437;
import org.jetbrains.annotations.ApiStatus;

import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

@ApiStatus.Internal
public class ErrorsScreen extends class_437 {
    private List<Object> components;
    private class_4264 doneButton;
    private ErrorsEntryListWidget listWidget;
    private class_437 parent;
    private boolean quitable;
    
    public ErrorsScreen(class_2561 title, List<Object> components, class_437 parent, boolean quitable) {
        super(title);
        this.components = components;
        this.parent = parent;
        this.quitable = quitable;
    }
    
    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            class_310.method_1551().method_1507(parent);
            return true;
        }
        
        return super.method_25404(keyCode, scanCode, modifiers);
    }
    
    @Override
    public boolean method_25422() {
        return false;
    }
    
    @Override
    public void method_25426() {
        method_25429(listWidget = new ErrorsEntryListWidget(field_22787, field_22789, field_22790, 32, field_22790 - 32));
        listWidget._clearItems();
        for (Object component : components) {
            if (component instanceof class_2561) {
                listWidget._addEntry(new TextEntry((class_2561) component, listWidget.getItemWidth()));
            } else {
                listWidget._addEntry(((Function<Integer, ErrorsEntryListWidget.Entry>) component).apply(listWidget.getItemWidth()));
            }
        }
        listWidget._addEntry(new TextEntry(class_2561.method_43473(), listWidget.getItemWidth()));
        if (quitable) {
            method_37063(doneButton = new class_4185(field_22789 / 2 - 100, field_22790 - 26, 200, 20, class_2561.method_43471("gui.done"), button -> class_310.method_1551().method_1507(parent), Supplier::get) {});
        } else {
            method_37063(doneButton = new class_4185(field_22789 / 2 - 100, field_22790 - 26, 200, 20, class_2561.method_43471("menu.quit"), button -> exit(), Supplier::get) {});
        }
    }
    
    private void exit() {
        boolean localServer = this.field_22787.method_1542();
        this.field_22787.field_1687.method_8525();
        
        if (localServer) {
            this.field_22787.method_56134(new class_424(class_2561.method_43471("menu.savingLevel")));
        } else {
            this.field_22787.method_18099();
        }
        
        System.exit(-1);
    }
    
    @Override
    public boolean method_25401(double mouseX, double mouseY, double amountX, double amountY) {
        if (listWidget.method_25401(mouseX, mouseY, amountX, amountY))
            return true;
        return super.method_25401(mouseX, mouseY, amountX, amountY);
    }
    
    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        super.method_25394(graphics, mouseX, mouseY, delta);
        graphics.method_27534(this.field_22793, method_25440(), this.field_22789 / 2, 16, 16777215);
    }
    
    @Override
    public void method_25420(class_332 graphics, int mouseX, int mouseY, float delta) {
        super.method_25420(graphics, mouseX, mouseY, delta);
        this.listWidget.method_25394(graphics, mouseX, mouseY, delta);
    }
}
