/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020, 2021, 2022, 2023 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.impl.client.gui.error;

import me.shedaniel.clothconfig2.gui.widget.DynamicEntryListWidget;
import me.shedaniel.clothconfig2.gui.widget.DynamicSmoothScrollingEntryListWidget;
import me.shedaniel.rei.impl.client.gui.InternalTextures;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1109;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4069;
import net.minecraft.class_437;
import net.minecraft.class_5481;
import net.minecraft.class_6379;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector4f;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;

@ApiStatus.Internal
public class ErrorsEntryListWidget extends DynamicSmoothScrollingEntryListWidget<ErrorsEntryListWidget.Entry> {
    private boolean inFocus;
    
    public ErrorsEntryListWidget(class_310 client, int width, int height, int startY, int endY) {
        super(client, width, height, startY, endY, InternalTextures.LEGACY_DIRT);
    }
    
    public void _clearItems() {
        clearItems();
    }
    
    private me.shedaniel.rei.impl.client.gui.error.ErrorsEntryListWidget.Entry _getEntry(int index) {
        return this.method_25396().get(index);
    }
    
    public void _addEntry(me.shedaniel.rei.impl.client.gui.error.ErrorsEntryListWidget.Entry entry) {
        addItem(entry);
    }
    
    @Override
    public int getItemWidth() {
        return width - 80;
    }
    
    @Override
    protected int getScrollbarPosition() {
        return width - 40;
    }
    
    public static abstract class Entry extends DynamicEntryListWidget.Entry<me.shedaniel.rei.impl.client.gui.error.ErrorsEntryListWidget.Entry> {
        @Override
        public List<? extends class_6379> narratables() {
            return Collections.emptyList();
        }
        
        @Override
        public void method_25365(boolean bl) {
        }
        
        @Override
        public boolean method_25370() {
            return false;
        }
    }
    
    public static class EmptyEntry extends me.shedaniel.rei.impl.client.gui.error.ErrorsEntryListWidget.Entry {
        public final int height;
        
        public EmptyEntry(int height) {
            this.height = height;
        }
        
        @Override
        public void render(class_332 graphics, int i, int i1, int i2, int i3, int i4, int i5, int i6, boolean b, float v) {
        }
        
        @Override
        public int getItemHeight() {
            return height;
        }
    }
    
    public static class IndentedEntry extends me.shedaniel.rei.impl.client.gui.error.ErrorsEntryListWidget.Entry implements class_4069 {
        public final me.shedaniel.rei.impl.client.gui.error.ErrorsEntryListWidget.Entry entry;
        public final int indent;
        
        public IndentedEntry(me.shedaniel.rei.impl.client.gui.error.ErrorsEntryListWidget.Entry entry, int indent) {
            this.entry = entry;
            this.indent = indent;
        }
        
        public me.shedaniel.rei.impl.client.gui.error.ErrorsEntryListWidget.Entry getEntry() {
            entry.setParent(getParent());
            return entry;
        }
        
        @Override
        public void render(class_332 graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            getEntry().render(graphics, index, y, x + indent, entryWidth - indent, entryHeight, mouseX, mouseY, isSelected, delta);
        }
        
        @Override
        public int getItemHeight() {
            return getEntry().getItemHeight();
        }
        
        @Override
        public List<? extends class_6379> narratables() {
            return getEntry().narratables();
        }
        
        @Override
        public List<? extends class_364> method_25396() {
            return Collections.singletonList(getEntry());
        }
        
        @Nullable
        private class_364 focused;
        private boolean isDragging;
        
        @Override
        public final boolean method_25397() {
            return this.isDragging;
        }
        
        @Override
        public final void method_25398(boolean dragging) {
            this.isDragging = dragging;
        }
        
        @Override
        @Nullable
        public class_364 method_25399() {
            return this.focused;
        }
        
        @Override
        public void method_25395(@Nullable class_364 focused) {
            this.focused = focused;
        }
    }
    
    public static class ScaledEntry extends me.shedaniel.rei.impl.client.gui.error.ErrorsEntryListWidget.Entry implements class_4069 {
        public final me.shedaniel.rei.impl.client.gui.error.ErrorsEntryListWidget.Entry entry;
        public final float scale;
        public final Matrix4f transform;
        
        public ScaledEntry(me.shedaniel.rei.impl.client.gui.error.ErrorsEntryListWidget.Entry entry, float scale) {
            this.entry = entry;
            this.scale = scale;
            this.transform = new Matrix4f().scale(scale, scale, scale);
        }
        
        public me.shedaniel.rei.impl.client.gui.error.ErrorsEntryListWidget.Entry getEntry() {
            entry.setParent(getParent());
            return entry;
        }
        
        private Vector4f transformMouse(double mouseX, double mouseY) {
            Vector4f mouse = new Vector4f((float) mouseX, (float) mouseY, 0, 1);
            transform.transform(mouse);
            return mouse;
        }
        
        @Override
        public void render(class_332 graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            Vector4f mouse = transformMouse(mouseX, mouseY);
            graphics.method_51448().method_22903();
            graphics.method_51448().method_23760().method_23761().mul(transform);
            
            Vector4f pos = new Vector4f(x, y, 0, 1);
            pos.mul(new Matrix4f().scale(1 / scale, 1 / scale, 1 / scale));
            getEntry().render(graphics, index, Math.round(pos.y()), Math.round(pos.x()), Math.round(entryWidth / scale), Math.round(entryHeight / scale), (int) mouse.x(), (int) mouse.y(), isSelected, delta);
            graphics.method_51448().method_22909();
        }
        
        @Override
        public int getItemHeight() {
            return getEntry().getItemHeight();
        }
        
        @Override
        public List<? extends class_6379> narratables() {
            return getEntry().narratables();
        }
        
        @Override
        public List<? extends class_364> method_25396() {
            return Collections.singletonList(getEntry());
        }
        
        @Override
        public boolean method_25405(double mouseX, double mouseY) {
            Vector4f mouse = transformMouse(mouseX, mouseY);
            return super.method_25405(mouse.x(), mouse.y());
        }
        
        @Override
        public boolean method_25402(double d, double e, int i) {
            Vector4f mouse = transformMouse(d, e);
            return super.method_25402(mouse.x(), mouse.y(), i);
        }
        
        @Override
        public boolean method_25406(double d, double e, int i) {
            Vector4f mouse = transformMouse(d, e);
            return super.method_25406(mouse.x(), mouse.y(), i);
        }
        
        @Override
        public boolean method_25403(double d, double e, int i, double f, double g) {
            Vector4f mouse = transformMouse(d, e);
            return super.method_25403(mouse.x(), mouse.y(), i, f, g);
        }
        
        @Override
        public boolean method_25401(double d, double e, double amountX, double amountY) {
            Vector4f mouse = transformMouse(d, e);
            return super.method_25401(mouse.x(), mouse.y(), amountX, amountY);
        }
        
        @Nullable
        private class_364 focused;
        private boolean isDragging;
        
        @Override
        public final boolean method_25397() {
            return this.isDragging;
        }
        
        @Override
        public final void method_25398(boolean dragging) {
            this.isDragging = dragging;
        }
        
        @Override
        @Nullable
        public class_364 method_25399() {
            return this.focused;
        }
        
        @Override
        public void method_25395(@Nullable class_364 focused) {
            this.focused = focused;
        }
    }
    
    public static class TextEntry extends me.shedaniel.rei.impl.client.gui.error.ErrorsEntryListWidget.Entry {
        private class_2561 text;
        private int width;
        private List<class_5481> textSplit;
        private int savedX;
        private int savedY;
        
        public TextEntry(class_2561 text, int width) {
            this.text = text;
            this.width = width - 6;
            this.textSplit = text.getString().trim().isEmpty() ? Collections.singletonList(text.method_30937()) : class_310.method_1551().field_1772.method_1728(text, this.width);
        }
        
        @Override
        public void render(class_332 graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            if (this.width != entryWidth - 6) {
                this.width = entryWidth - 6;
                this.textSplit = text.getString().trim().isEmpty() ? Collections.singletonList(text.method_30937()) : class_310.method_1551().field_1772.method_1728(text, width);
            }
            this.savedX = x;
            this.savedY = y;
            int yy = y;
            for (class_5481 textSp : textSplit) {
                graphics.method_35720(class_310.method_1551().field_1772, textSp, x + 5, yy, -1);
                yy += 12;
            }
            
            class_2583 style = this.getTextAt(mouseX, mouseY);
            class_437 screen = class_310.method_1551().field_1755;
            if (style != null && screen != null) {
                if (style.method_10969() != null) {
                    class_2568 hoverEvent = style.method_10969();
                    class_2561 component = hoverEvent.method_10891(class_2568.class_5247.field_24342);
                    if (component != null) {
                        graphics.method_51447(class_310.method_1551().field_1772, class_310.method_1551().field_1772.method_1728(component, Math.max(this.width / 2, 200)), x, y);
                    }
                }
            }
        }
        
        @Override
        public int getItemHeight() {
            return 12 * textSplit.size();
        }
        
        @Override
        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (button == 0) {
                class_2583 style = this.getTextAt(mouseX, mouseY);
                if (style != null && style.method_10970() != null) {
                    class_2558 clickEvent = style.method_10970();
                    class_310.method_1551().method_1483().method_4873(class_1109.method_47978(class_3417.field_15015, 1.0F));
                    try {
                        class_156.method_668().method_673(new URI(clickEvent.method_10844()));
                        return true;
                    } catch (URISyntaxException e) {
                        e.printStackTrace();
                    }
                    return true;
                }
            }
            
            return super.method_25402(mouseX, mouseY, button);
        }
        
        @Nullable
        private class_2583 getTextAt(double x, double y) {
            int lineCount = this.textSplit.size();
            if (lineCount > 0) {
                int textX = class_3532.method_15357(x - (double) this.savedX);
                int textY = class_3532.method_15357(y - (double) this.savedY);
                if (textX >= 0 && textY >= 0 && textX <= this.width && textY < 12 * lineCount + lineCount) {
                    int line = textY / 12;
                    if (line < this.textSplit.size()) {
                        class_5481 orderedText = this.textSplit.get(line);
                        return class_310.method_1551().field_1772.method_27527().method_30876(orderedText, textX);
                    }
                }
            }
            
            return null;
        }
    }
    
    public static class HorizontalRuleEntry extends me.shedaniel.rei.impl.client.gui.error.ErrorsEntryListWidget.Entry {
        private int width;
        
        public HorizontalRuleEntry(int width) {
            this.width = width;
        }
        
        @Override
        public void render(class_332 graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            if (this.width != entryWidth) {
                this.width = entryWidth;
            }
            graphics.method_25294(x + 2, y + 2, x + width - 6 - 2, y + 3, 0xFF777777);
        }
        
        @Override
        public int getItemHeight() {
            return 5;
        }
    }
    
    public static class ImageEntry extends me.shedaniel.rei.impl.client.gui.error.ErrorsEntryListWidget.Entry {
        private class_1043 texture;
        private class_2960 id;
        private int width;
        private int height;
        
        public ImageEntry(int width, class_1043 texture, class_2960 id) {
            this.id = id;
            this.texture = texture;
            this.width = (width - 6) / 2;
            class_1011 image = texture.method_4525();
            this.height = (int) ((double) this.width * ((double) image.method_4323() / (double) image.method_4307()));
        }
        
        @Override
        public void render(class_332 graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            class_1011 image = texture.method_4525();
            width = (entryWidth - 6) / 2;
            this.height = (int) ((double) width * ((double) image.method_4323() / (double) image.method_4307()));
            graphics.method_25294(x, y, x + width, y + height + 2, 0xFFFFFFFF);
            graphics.method_25295(class_1921::method_62277, id, x + 1, x + width - 1, y + 1, y + height + 1, 0, 0, 1, 0, 1);
        }
        
        @Override
        public int getItemHeight() {
            return height + 2;
        }
    }
    
    public static class LinkEntry extends me.shedaniel.rei.impl.client.gui.error.ErrorsEntryListWidget.Entry {
        private class_2561 text;
        private List<class_5481> textSplit;
        private String link;
        private boolean contains;
        
        public LinkEntry(class_2561 text, String link, int width) {
            this.text = text;
            this.textSplit = class_310.method_1551().field_1772.method_1728(text, width - 6);
            this.link = link;
        }
        
        @Override
        public void render(class_332 graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            contains = mouseX >= x && mouseX <= x + entryWidth && mouseY >= y && mouseY <= y + entryHeight;
            if (contains) {
                graphics.method_51438(class_310.method_1551().field_1772, class_2561.method_43470("Click to open link."), mouseX, mouseY);
                int yy = y;
                for (class_5481 textSp : textSplit) {
                    class_5481 underlined = characterVisitor -> {
                        return textSp.accept((charIndex, style, codePoint) -> characterVisitor.accept(charIndex, style.method_27706(class_124.field_1073), codePoint));
                    };
                    graphics.method_35720(class_310.method_1551().field_1772, underlined, x + 5, yy, 0xff1fc3ff);
                    yy += 12;
                }
            } else {
                int yy = y;
                for (class_5481 textSp : textSplit) {
                    graphics.method_35720(class_310.method_1551().field_1772, textSp, x + 5, yy, 0xff1fc3ff);
                    yy += 12;
                }
            }
        }
        
        @Override
        public int getItemHeight() {
            return 12 * textSplit.size();
        }
        
        @Override
        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (contains && button == 0) {
                class_310.method_1551().method_1483().method_4873(class_1109.method_47978(class_3417.field_15015, 1.0F));
                try {
                    class_156.method_668().method_673(new URI(link));
                    return true;
                } catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
            return false;
        }
    }
}
