/*
 * This file is licensed under the MIT License, part of Roughly Enough Items.
 * Copyright (c) 2018, 2019, 2020, 2021, 2022, 2023 shedaniel
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package me.shedaniel.rei.impl.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.impl.client.gui.toast.ExportRecipeIdentifierToast;
import me.shedaniel.rei.impl.display.DisplaySpec;
import net.minecraft.class_1011;
import net.minecraft.class_10366;
import net.minecraft.class_1041;
import net.minecraft.class_1074;
import net.minecraft.class_156;
import net.minecraft.class_276;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_6367;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;

@ApiStatus.Internal
public final class RecipeDisplayExporter {
    private RecipeDisplayExporter() {}
    
    public static void exportRecipeDisplay(Rectangle rectangle, DisplaySpec display, List<Widget> widgets, boolean toast) {
        exportRecipe(rectangle, display, widgets);
        if (toast) {
            ExportRecipeIdentifierToast.addToast(class_1074.method_4662("msg.rei.exported_recipe"), class_1074.method_4662("msg.rei.exported_recipe.desc"));
        }
    }
    
    private static File getExportFilename(DisplaySpec display, File directory) {
        Collection<class_2960> locations = display.provideInternalDisplayIds();
        String string = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date());
        if (!locations.isEmpty()) {
            string = locations.iterator().next().toString().replace('/', '_').replace(':', '_');
        }
        int i = 1;
        
        while (true) {
            File file = new File(directory, string + (i == 1 ? "" : "_" + i) + ".png");
            if (!file.exists()) {
                return file;
            }
            
            ++i;
        }
    }
    
    private static void exportRecipe(Rectangle rectangle, DisplaySpec display, List<Widget> widgets) {
        class_310 client = class_310.method_1551();
        class_1041 window = client.method_22683();
        class_276 renderTarget = new class_6367(window.method_4489(), window.method_4506(), true);
        renderTarget.method_1236(0, 0, 0, 0);
        renderTarget.method_1235(true);
        RenderSystem.clear(256);
        Matrix4f matrix4f = new Matrix4f().setOrtho(0.0F, (float) ((double) window.method_4489() / window.method_4495()), (float) ((double) window.method_4506() / window.method_4495()), 0.0F, 1000.0F, 3000.0F);
        RenderSystem.setProjectionMatrix(matrix4f, class_10366.field_54954);
        Matrix4fStack poseStack = RenderSystem.getModelViewStack();
        poseStack.pushMatrix();
        poseStack.identity();
        poseStack.translate(0.0F, 0.0F, -2000.0F);
        class_308.method_24211();
        class_332 graphics = new class_332(client, client.method_22940().method_23000());
        for (Widget widget : widgets) {
            widget.method_25394(graphics, -1, -1, 0);
        }
        
        class_1011 nativeImage = new class_1011(renderTarget.field_1482, renderTarget.field_1481, false);
        RenderSystem.bindTexture(renderTarget.method_30277());
        nativeImage.method_4327(0, false);
        nativeImage.method_4319();
        int outWidth = (int) (rectangle.width * window.method_4495());
        int outHeight = (int) (rectangle.height * window.method_4495());
        class_1011 strippedImage = new class_1011(outWidth, outHeight, false);
        for (int y = 0; y < outHeight; ++y) {
            for (int x = 0; x < outWidth; ++x) {
                strippedImage.method_61941(x, y, nativeImage.method_61940(x + (int) (rectangle.x * window.method_4495()), y + (int) (rectangle.y * window.method_4495())));
            }
        }
        class_156.method_27958().execute(() -> {
            try {
                File export = new File(class_310.method_1551().field_1697, "rei_exports/" + display.provideInternalDisplay().getCategoryIdentifier().toString().replace('/', '_').replace(':', '_'));
                export.mkdirs();
                strippedImage.method_4325(getExportFilename(display, export));
            } catch (IOException e) {
                e.printStackTrace();
            } finally {
                nativeImage.close();
                strippedImage.close();
            }
        });
        
        renderTarget.method_1238();
        // Minecraft.getInstance().levelRenderer.graphicsChanged();
        class_310.method_1551().method_1522().method_1235(true);
        poseStack.popMatrix();
    }
}
